/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UploadManager
implements BandwidthTracker {
    private static final Log LOG;
    private final int BYPASS_QUEUE = -1;
    private final int REJECTED = 0;
    private final int QUEUED = 1;
    private final int ACCEPTED = 2;
    private final int BANNED = 3;
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private List _activeUploadList = new LinkedList();
    private List _queuedUploads = new ArrayList();
    private volatile boolean _hadSuccesfulUpload = false;
    private static final int MAX_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SPEED_SAMPLE_SIZE = 5;
    private static final int MIN_SAMPLE_BYTES = 200000;
    private Buffer speeds = new Buffer(5);
    private volatile int highestSpeed = -1;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private static final float MINIMUM_UPLOAD_SPEED = 3.0f;
    public static final int BROWSE_HOST_FILE_INDEX = -1;
    public static final int UPDATE_FILE_INDEX = -2;
    public static final int BAD_URN_QUERY_INDEX = -3;
    public static final int MALFORMED_REQUEST_INDEX = -4;
    public static final int PUSH_PROXY_FILE_INDEX = -5;
    public static final boolean RECORD_STATS;
    public static final String SERVICE_ID = "service_id";
    private final Map REQUESTS = new FixedsizeForgetfulHashMap(250);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.UploadManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        RECORD_STATS = !CommonUtils.isJava118();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptUpload(HTTPRequestMethod var1_1, Socket var2_2, boolean var3_3) {
        block53: {
            block51: {
                block52: {
                    block50: {
                        UploadManager.LOG.trace((Object)"accepting upload");
                        var4_4 = null;
                        var5_5 = -1L;
                        try {
                            try {
                                var7_6 = -1;
                                var8_8 = "";
                                var9_9 = var1_1;
                                var10_10 = new StalledUploadWatchdog();
                                var11_11 = null;
                                var12_12 = false;
                                while (true) {
                                    if (var4_4 != null) {
                                        this.assertAsComplete(var4_4.getState());
                                    }
                                    if (var11_11 == null) {
                                        var11_11 = new BufferedInputStream(var2_2.getInputStream());
                                    }
                                    var13_13 = this.parseHttpRequest(var2_2, var11_11);
                                    if (UploadManager.LOG.isDebugEnabled()) {
                                        UploadManager.LOG.debug((Object)(var4_4 + " successfully parsed request"));
                                    }
                                    var14_14 = var13_13._fileName;
                                    var12_12 = var4_4 == null || var9_9 != var4_4.getMethod() || var8_8.equalsIgnoreCase(var14_14) == false;
                                    if (var12_12) {
                                        if (UploadManager.LOG.isDebugEnabled()) {
                                            UploadManager.LOG.debug((Object)(var4_4 + " starting new file"));
                                        }
                                        if (var4_4 != null) {
                                            if (var7_6 != 1) {
                                                var7_6 = -1;
                                            } else {
                                                var4_4.setState(5);
                                            }
                                            this.cleanupFinishedUploader(var4_4, var5_5);
                                        }
                                        var4_4 = new HTTPUploader(var9_9, var14_14, var2_2, var13_13._index, var13_13.getParameters(), var10_10);
                                    } else {
                                        if (UploadManager.LOG.isDebugEnabled()) {
                                            UploadManager.LOG.debug((Object)(var4_4 + " continuing old file"));
                                        }
                                        var4_4.reinitialize(var9_9, var13_13.getParameters());
                                    }
                                    this.assertAsConnecting(var4_4.getState());
                                    this.setInitialUploadingState(var4_4);
                                    try {
                                        var4_4.readHeader(var11_11);
                                        this.setUploaderStateOffHeaders(var4_4);
                                    }
                                    catch (ProblemReadingHeaderException v0) {
                                        var4_4.setState(11);
                                    }
                                    if (UploadManager.LOG.isDebugEnabled()) {
                                        UploadManager.LOG.debug((Object)(var4_4 + " HTTPUploader created and read all headers"));
                                    }
                                    if (var7_6 != 2 && (var7_6 = this.processNewRequest(var4_4, var2_2, var3_3)) == 2) {
                                        var5_5 = System.currentTimeMillis();
                                    }
                                    if (var12_12) {
                                        this.addToGUI(var4_4);
                                    }
                                    this.doSingleUpload(var4_4);
                                    this.assertAsFinished(var4_4.getState());
                                    var8_8 = var14_14;
                                    if (!var13_13.isHTTP11()) {
lbl55:
                                        // 3 sources

                                        while (true) {
                                            var17_17 = null;
                                            if (var4_4 != null && var4_4.getState() != 4) {
                                                var4_4.setState(5);
                                            }
                                            var19_20 = this;
                                            break block50;
                                            break;
                                        }
                                    }
                                    if (UploadManager.LOG.isDebugEnabled()) {
                                        UploadManager.LOG.debug((Object)(var4_4 + " waiting for next request with socket "));
                                    }
                                    var15_15 = var2_2.getSoTimeout();
                                    if (var7_6 != 1) {
                                        var2_2.setSoTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
                                    }
                                    var16_16 = IOUtils.readWord(var11_11, 4);
                                    if (UploadManager.LOG.isDebugEnabled()) {
                                        UploadManager.LOG.debug((Object)(var4_4 + " next request arrived "));
                                    }
                                    var2_2.setSoTimeout(var15_15);
                                    if (var16_16.equals("GET")) {
                                        var9_9 = HTTPRequestMethod.GET;
                                        if (!UploadManager.RECORD_STATS) continue;
                                        UploadStat.SUBSEQUENT_GET.incrementStat();
                                        continue;
                                    }
                                    if (!var16_16.equals("HEAD")) break;
                                    var9_9 = HTTPRequestMethod.HEAD;
                                    if (!UploadManager.RECORD_STATS) continue;
                                    UploadStat.SUBSEQUENT_HEAD.incrementStat();
                                }
                                if (!UploadManager.RECORD_STATS) ** GOTO lbl55
                                UploadStat.SUBSEQUENT_UNKNOWN.incrementStat();
                                ** continue;
                            }
                            catch (IOException var7_7) {
                                if (UploadManager.LOG.isDebugEnabled()) {
                                    UploadManager.LOG.debug((Object)(var4_4 + " IOE thrown, closing socket"), (Throwable)var7_7);
                                }
                                ** GOTO lbl-1000
                            }
                        }
                        catch (Throwable var18_32) {
                            var17_18 = null;
                            if (var4_4 != null && var4_4.getState() != 4) {
                                var4_4.setState(5);
                            }
                            var19_21 = this;
                            synchronized (var19_21) {
                                var20_24 = false;
                                var21_27 = this._queuedUploads.iterator();
                                while (var21_27.hasNext()) {
                                    var22_30 = (KeyValue)var21_27.next();
                                    if (var22_30.getKey() != var2_2) continue;
                                    var21_27.remove();
                                    var20_24 = true;
                                    break;
                                }
                                if (var20_24) {
                                    var4_4.setState(5);
                                }
                                break block51;
                            }
                        }
                    }
                    synchronized (var19_20) {
                        ** try [egrp 3[TRYBLOCK] [6 : 751->829)] { 
lbl111:
                        // 1 sources

                        var20_23 = false;
                        var21_26 = this._queuedUploads.iterator();
                        while (var21_26.hasNext()) {
                            var22_29 = (KeyValue)var21_26.next();
                            if (var22_29.getKey() != var2_2) continue;
                            var21_26.remove();
                            var20_23 = true;
                            break;
                        }
                        if (var20_23) {
                            var4_4.setState(5);
                        }
                        break block52;
lbl122:
                        // 1 sources

                        catch (Throwable v2) {
                            throw v2;
                        }
                    }
                }
                if (var4_4 != null) {
                    var4_4.stop();
                    this.cleanupFinishedUploader(var4_4, var5_5);
                }
                if (UploadManager.LOG.isDebugEnabled()) {
                    UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
                }
                this.close(var2_2);
                return;
            }
            if (var4_4 != null) {
                var4_4.stop();
                this.cleanupFinishedUploader(var4_4, var5_5);
            }
            if (UploadManager.LOG.isDebugEnabled()) {
                UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
            }
            this.close(var2_2);
            throw var18_32;
lbl-1000:
            // 1 sources

            {
                var17_19 = null;
                if (var4_4 != null && var4_4.getState() != 4) {
                    var4_4.setState(5);
                }
                var19_22 = this;
            }
            synchronized (var19_22) {
                ** try [egrp 3[TRYBLOCK] [6 : 751->829)] { 
lbl146:
                // 1 sources

                var20_25 = false;
                var21_28 = this._queuedUploads.iterator();
                while (var21_28.hasNext()) {
                    var22_31 = (KeyValue)var21_28.next();
                    if (var22_31.getKey() != var2_2) continue;
                    var21_28.remove();
                    var20_25 = true;
                    break;
                }
                if (var20_25) {
                    var4_4.setState(5);
                }
                break block53;
lbl157:
                // 1 sources

                catch (Throwable v3) {
                    throw v3;
                }
            }
        }
        if (var4_4 != null) {
            var4_4.stop();
            this.cleanupFinishedUploader(var4_4, var5_5);
        }
        if (UploadManager.LOG.isDebugEnabled()) {
            UploadManager.LOG.debug((Object)(var4_4 + " closing socket"));
        }
        this.close(var2_2);
    }

    private boolean shouldShowInGUI(Uploader uploader) {
        return uploader.getIndex() != -1 && uploader.getIndex() != -5 && uploader.getIndex() != -2 && uploader.getIndex() != -4 && uploader.getIndex() != -3 && uploader.getMethod() != HTTPRequestMethod.HEAD;
    }

    private boolean shouldBypassQueue(Uploader uploader) {
        return uploader.getState() != 0 || uploader.getMethod() == HTTPRequestMethod.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFinishedUploader(HTTPUploader hTTPUploader, long l) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " cleaning up finished."));
        }
        int n = hTTPUploader.getState();
        int n2 = hTTPUploader.getLastTransferState();
        this.assertAsFinished(n);
        long l2 = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            if (l > 0L) {
                this.reportUploadSpeed(l2 - l, hTTPUploader.getTotalAmountUploaded());
            }
            this.removeFromList(hTTPUploader);
        }
        hTTPUploader.closeFileStreams();
        if (RECORD_STATS) {
            switch (n) {
                case 4: {
                    UploadStat.COMPLETED.incrementStat();
                    if (n2 != 3 && n2 != 15) break;
                    UploadStat.COMPLETED_FILE.incrementStat();
                    break;
                }
                case 5: {
                    UploadStat.INTERRUPTED.incrementStat();
                }
            }
        }
        if (this.shouldShowInGUI(hTTPUploader)) {
            object = hTTPUploader.getFileDesc();
            if (object != null && n == 4 && (n2 == 3 || n2 == 15)) {
                ((FileDesc)object).incrementCompletedUploads();
                RouterService.getCallback().handleSharedFileUpdate(((FileDesc)object).getFile());
            }
            RouterService.getCallback().removeUpload(hTTPUploader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialUploadingState(HTTPUploader hTTPUploader) {
        switch (hTTPUploader.getIndex()) {
            case -1: {
                hTTPUploader.setState(8);
                return;
            }
            case -5: {
                hTTPUploader.setState(12);
                return;
            }
            case -2: {
                hTTPUploader.setState(10);
                return;
            }
            case -3: {
                hTTPUploader.setState(7);
                return;
            }
            case -4: {
                hTTPUploader.setState(11);
                return;
            }
        }
        FileManager fileManager = RouterService.getFileManager();
        FileDesc fileDesc = null;
        int n = hTTPUploader.getIndex();
        FileManager fileManager2 = fileManager;
        synchronized (fileManager2) {
            if (fileManager.isValidIndex(n)) {
                fileDesc = fileManager.get(n);
            }
        }
        if (fileDesc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " fd is null"));
            }
            hTTPUploader.setState(7);
            return;
        }
        if (!hTTPUploader.getFileName().equals(fileDesc.getName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " wrong file name"));
            }
            hTTPUploader.setState(7);
            return;
        }
        try {
            hTTPUploader.setFileDesc(fileDesc);
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(hTTPUploader + " could not create file stream"));
            }
            hTTPUploader.setState(7);
            return;
        }
        this.assertAsConnecting(hTTPUploader.getState());
    }

    private void setUploaderStateOffHeaders(HTTPUploader hTTPUploader) {
        FileDesc fileDesc = hTTPUploader.getFileDesc();
        if (hTTPUploader.getState() == 0) {
            URN uRN = hTTPUploader.getRequestedURN();
            if (fileDesc != null && uRN != null && !fileDesc.containsUrn(uRN)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(hTTPUploader + " wrong content urn"));
                }
                hTTPUploader.setState(7);
                return;
            }
            if (hTTPUploader.isTHEXRequest()) {
                if (hTTPUploader.getFileDesc().getHashTree() != null) {
                    hTTPUploader.setState(15);
                } else {
                    hTTPUploader.setState(7);
                }
                return;
            }
            if (fileDesc instanceof IncompleteFileDesc) {
                int n;
                if (!UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                    hTTPUploader.setState(7);
                    return;
                }
                if (hTTPUploader.isTHEXRequest()) {
                    hTTPUploader.setState(7);
                    return;
                }
                IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
                int n2 = hTTPUploader.getUploadBegin();
                if (!incompleteFileDesc.isRangeSatisfiable(n2, n = hTTPUploader.getUploadEnd())) {
                    hTTPUploader.setState(13);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processNewRequest(HTTPUploader hTTPUploader, Socket socket, boolean bl) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(hTTPUploader + " processing new request."));
        }
        int n = -1;
        if (!this.shouldBypassQueue(hTTPUploader)) {
            if (bl) {
                n = 2;
            } else {
                n = this.checkAndQueue(hTTPUploader, socket);
                Assert.that(n != -1);
            }
        } else {
            n = -1;
        }
        switch (n) {
            case 0: {
                hTTPUploader.setState(2);
                break;
            }
            case 3: {
                hTTPUploader.setState(14);
                break;
            }
            case 1: {
                hTTPUploader.setState(9);
                socket.setSoTimeout(120000);
                break;
            }
            case 2: {
                this.assertAsConnecting(hTTPUploader.getState());
                UploadManager uploadManager = this;
                synchronized (uploadManager) {
                    this._activeUploadList.add((Object)hTTPUploader);
                    break;
                }
            }
            case -1: {
                break;
            }
            default: {
                Assert.that(false, "Invalid queued state: " + n);
            }
        }
        return n;
    }

    private void addToGUI(Uploader uploader) {
        if (RECORD_STATS) {
            UploadStat.ATTEMPTED.incrementStat();
        }
        if (this.shouldShowInGUI(uploader)) {
            RouterService.getCallback().addUpload(uploader);
            FileDesc fileDesc = uploader.getFileDesc();
            if (fileDesc != null) {
                fileDesc.incrementAttemptedUploads();
                RouterService.getCallback().handleSharedFileUpdate(fileDesc.getFile());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSingleUpload(HTTPUploader hTTPUploader) throws IOException {
        block15: {
            switch (hTTPUploader.getState()) {
                case 13: {
                    if (!RECORD_STATS) break;
                    UploadStat.UNAVAILABLE_RANGE.incrementStat();
                    break;
                }
                case 7: {
                    if (!RECORD_STATS) break;
                    UploadStat.FILE_NOT_FOUND.incrementStat();
                    break;
                }
                case 1: {
                    if (!RECORD_STATS) break;
                    UploadStat.FREELOADER.incrementStat();
                    break;
                }
                case 2: {
                    if (!RECORD_STATS) break;
                    UploadStat.LIMIT_REACHED.incrementStat();
                    break;
                }
                case 9: {
                    if (!RECORD_STATS) break;
                    UploadStat.QUEUED.incrementStat();
                    break;
                }
                case 14: {
                    if (!RECORD_STATS) break;
                    UploadStat.BANNED.incrementStat();
                    break;
                }
                case 0: {
                    hTTPUploader.setState(3);
                    if (!RECORD_STATS) break;
                    UploadStat.UPLOADING.incrementStat();
                    break;
                }
                case 15: {
                    if (!RECORD_STATS) break;
                    UploadStat.THEX.incrementStat();
                    break;
                }
                case 4: 
                case 5: {
                    Assert.that(false, "invalid state in doSingleUpload");
                    break;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(hTTPUploader + " doing single upload"));
            }
            boolean bl = false;
            try {
                hTTPUploader.initializeStreams();
                hTTPUploader.writeResponse();
                bl = hTTPUploader.getCloseConnection();
                hTTPUploader.setState(4);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                hTTPUploader.closeFileStreams();
                throw throwable;
            }
            {
                Object var3_5 = null;
                hTTPUploader.closeFileStreams();
                if (!bl) break block15;
            }
            throw new IOException("close connection");
        }
    }

    public void close(Socket socket) {
        try {
            if (socket != null) {
                socket.getOutputStream().close();
            }
        }
        catch (Exception exception) {}
        try {
            if (socket != null) {
                socket.getInputStream().close();
            }
        }
        catch (Exception exception) {}
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {}
    }

    public synchronized boolean isServiceable() {
        return !this.isBusy() && this._queuedUploads.isEmpty();
    }

    public synchronized boolean isBusy() {
        if (RouterService.getIsShuttingDown()) {
            return true;
        }
        return !this.testTotalUploadLimit();
    }

    public synchronized boolean isQueueFull() {
        if (RouterService.getIsShuttingDown()) {
            return true;
        }
        return this._queuedUploads.size() >= UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
    }

    public synchronized int uploadsInProgress() {
        return this._activeUploadList.size();
    }

    public synchronized int getNumQueuedUploads() {
        return this._queuedUploads.size();
    }

    public boolean hadSuccesfulUpload() {
        return this._hadSuccesfulUpload;
    }

    public synchronized boolean killUploadsForFileDesc(FileDesc fileDesc) {
        boolean bl = false;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            HTTPUploader hTTPUploader = (HTTPUploader)iterator.next();
            FileDesc fileDesc2 = hTTPUploader.getFileDesc();
            if (fileDesc2 == null || !fileDesc2.equals(fileDesc)) continue;
            bl = true;
            hTTPUploader.stop();
        }
        return bl;
    }

    private synchronized int checkAndQueue(Uploader uploader, Socket socket) throws IOException {
        RequestCache requestCache = (RequestCache)this.REQUESTS.get((Object)uploader.getHost());
        if (requestCache == null) {
            requestCache = new RequestCache();
        }
        this.REQUESTS.put((Object)uploader.getHost(), (Object)requestCache);
        boolean bl = requestCache.isGreedy(uploader.getFileDesc().getSHA1Urn());
        if (requestCache.isHammering()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(uploader + " banned."));
            }
            return 3;
        }
        int n = this._queuedUploads.size();
        int n2 = this.positionInQueue(socket);
        int n3 = UploadSettings.UPLOAD_QUEUE_SIZE.getValue();
        boolean bl2 = n >= n3;
        int n4 = -1;
        boolean bl3 = false;
        if (bl && n >= 1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(uploader + " greedy -- limit reached."));
            }
            if (RECORD_STATS) {
                UploadStat.LIMIT_REACHED_GREEDY.incrementStat();
            }
            bl3 = true;
        } else if (n2 < 0 && (bl3 = this.hostLimitReached(uploader.getHost()))) {
            requestCache.limitReached(uploader.getFileDesc().getSHA1Urn());
        }
        boolean bl4 = uploader.supportsQueueing();
        Assert.that(n3 > 0, "queue size 0, cannot use");
        Assert.that(uploader.getState() == 0, "Bad state: " + uploader.getState());
        Assert.that(uploader.getMethod() == HTTPRequestMethod.GET);
        if (n2 == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + "Uploader not in que(capacity:" + n3 + ")"));
            }
            if (bl3 || bl2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(uploader + " limited? " + bl3 + " wontAccept? " + bl2));
                }
                return 0;
            }
            this.addToQueue(socket);
            n2 = n;
            n4 = 1;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " new uploader added to queue"));
            }
        } else {
            KeyValue keyValue = (KeyValue)this._queuedUploads.get(n2);
            Long l = (Long)keyValue.getValue();
            if (l + 45000L > System.currentTimeMillis()) {
                this._queuedUploads.remove(n2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(uploader + " queued uploader flooding-throwing exception"));
                }
                throw new IOException();
            }
            keyValue.setValue(new Long(System.currentTimeMillis()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " updated queued uploader"));
            }
            n4 = 1;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(uploader + " checking if given uploader is can be accomodated "));
        }
        if (!this.isBusy() && this.hasFreeSlot(n2 + this.uploadsInProgress())) {
            n4 = 2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(uploader + " accepting upload"));
            }
            this._queuedUploads.remove(n2);
        } else if (!bl4) {
            this._queuedUploads.remove(n2);
            n4 = 0;
        }
        return n4;
    }

    private synchronized void addToQueue(Socket socket) {
        Long l = new Long(System.currentTimeMillis());
        this._queuedUploads.add((Object)new KeyValue(socket, l));
    }

    public synchronized int positionInQueue(Socket socket) {
        int n = 0;
        Iterator iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            Object object = ((KeyValue)iterator.next()).getKey();
            if (object == socket) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private synchronized void removeFromList(Uploader uploader) {
        this._activeUploadList.remove((Object)uploader);
        if (this._activeUploadList.size() == 0) {
            RouterService.getCallback().uploadsComplete();
        }
    }

    private synchronized boolean hostLimitReached(String string) {
        Object object;
        int n = UploadSettings.UPLOADS_PER_PERSON.getValue();
        int n2 = 0;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            object = (Uploader)iterator.next();
            if (!object.getHost().equals(string)) continue;
            ++n2;
        }
        iterator = this._queuedUploads.iterator();
        while (iterator.hasNext()) {
            object = (Socket)((KeyValue)iterator.next()).getKey();
            if (!((Socket)object).getInetAddress().getHostAddress().equals(string)) continue;
            ++n2;
        }
        return n2 >= n;
    }

    private boolean hasFreeSlot(int n) {
        if (n >= UploadSettings.HARD_MAX_UPLOADS.getValue()) {
            return false;
        }
        if (n < UploadSettings.SOFT_MAX_UPLOADS.getValue()) {
            return true;
        }
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f = Math.max(f, f2);
        }
        return f > 3.0f;
    }

    private boolean testTotalUploadLimit() {
        return this.hasFreeSlot(this.uploadsInProgress());
    }

    public int calculateBandwidth() {
        float f = this.getTotalBandwith();
        float f2 = f / (float)this.uploadsInProgress();
        return (int)f2;
    }

    private float getTotalBandwith() {
        float f = (float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f;
        float f2 = UploadSettings.UPLOAD_SPEED.getValue();
        float f3 = f * (f2 / 100.0f);
        return f3;
    }

    public int measuredUploadSpeed() {
        return this.highestSpeed;
    }

    private void reportUploadSpeed(long l, long l2) {
        if (l2 < 200000L) {
            return;
        }
        int n = 8 * (int)((float)l2 / (float)l);
        this.speeds.add(new Integer(n));
        if (this.speeds.size() >= 5) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.speeds.size()) {
                n2 = Math.max(n2, (Integer)this.speeds.get(n3));
                ++n3;
            }
            this.highestSpeed = n2;
        }
    }

    private HttpRequestLine parseHttpRequest(Socket socket, InputStream inputStream) throws IOException {
        socket.setSoTimeout(8000);
        ByteReader byteReader = new ByteReader(inputStream);
        String string = byteReader.readLine();
        try {
            if (string == null) {
                throw new IOException();
            }
            string.trim();
            if (this.isURNGet(string)) {
                return this.parseURNGet(string);
            }
            return UploadManager.parseTraditionalGet(string);
        }
        catch (IOException iOException) {
            LOG.debug((Object)"http request failed", (Throwable)iOException);
            if (RECORD_STATS) {
                UploadStat.MALFORMED_REQUEST.incrementStat();
            }
            if (string == null) {
                return new HttpRequestLine(-4, "Malformed Request", false);
            }
            return new HttpRequestLine(-4, "Malformed Request", UploadManager.isHTTP11Request(string));
        }
    }

    private boolean isURNGet(String string) {
        int n = string.indexOf("/");
        int n2 = string.indexOf("/", n + 1);
        if (n == -1 || n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static HttpRequestLine parseTraditionalGet(String string) throws IOException {
        try {
            int n;
            int n2 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 2) {
                throw new IOException("invalid request: " + string);
            }
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = null;
            HashMap hashMap = null;
            if (string2.equals("/")) {
                n2 = -1;
                string3 = "Browse-Host Request";
                if (RECORD_STATS) {
                    UploadStat.BROWSE_HOST.incrementStat();
                }
            } else if (string2.equals("/update.xml")) {
                n2 = -2;
                string3 = "Update-File Request";
                if (RECORD_STATS) {
                    UploadStat.UPDATE_FILE.incrementStat();
                }
            } else if (string2.startsWith("/gnutella/push-proxy") || string2.startsWith("/gnet/push-proxy")) {
                n = string2.indexOf(63);
                if (n == -1) {
                    throw new IOException("Malformed PushProxy Req");
                }
                string2 = string2.substring(n + 1);
                n2 = -5;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=&");
                if (stringTokenizer2.countTokens() < 2 || stringTokenizer2.countTokens() % 2 != 0) {
                    throw new IOException("Malformed PushProxy HTTP Request");
                }
                Integer n3 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    String string5 = stringTokenizer2.nextToken();
                    if (string4.equalsIgnoreCase("ServerId")) {
                        if (string3 != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        byte[] byArray = Base32.decode(string5);
                        if (byArray.length != 16) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        string3 = new GUID(byArray).toHexString();
                        continue;
                    }
                    if (string4.equalsIgnoreCase("guid")) {
                        if (string3 != null) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        if (string5.length() != 32) {
                            throw new IOException("Malformed PushProxy Req");
                        }
                        string3 = string5;
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("file")) continue;
                    if (n3 != null) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    n3 = Integer.valueOf(string5);
                    if (n3 < 0) {
                        throw new IOException("Malformed PushProxy Req");
                    }
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    hashMap.put((Object)"file", (Object)n3);
                }
                if (RECORD_STATS) {
                    UploadStat.PUSH_PROXY.incrementStat();
                }
            } else {
                n = string.indexOf("/get/");
                int n4 = string.indexOf("/", n + 5);
                String string6 = string.substring(n + 5, n4);
                n2 = Integer.parseInt(string6);
                int n5 = string.indexOf(" HTTP/", n4);
                try {
                    string3 = URLDecoder.decode(string.substring(n4 + 1, n5));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string3 = string.substring(n4 + 1, n5);
                }
                if (RECORD_STATS) {
                    UploadStat.TRADITIONAL_GET.incrementStat();
                }
            }
            n = UploadManager.isHTTP11Request(string);
            return new HttpRequestLine(n2, string3, n != 0, (Map)hashMap);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
    }

    private HttpRequestLine parseURNGet(String string) throws IOException {
        URN uRN = URN.createSHA1UrnFromHttpRequest(string);
        HashMap hashMap = new HashMap();
        String string2 = string.toUpperCase(Locale.US);
        if (string2.indexOf("N2X?") > 0) {
            hashMap.put((Object)SERVICE_ID, (Object)"N2X?");
        } else if (string2.indexOf("N2R?") > 0) {
            hashMap.put((Object)SERVICE_ID, (Object)"N2R?");
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Invalid URN query: " + string));
            }
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(string));
        }
        FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
        if (fileDesc == null) {
            if (RECORD_STATS) {
                UploadStat.UNKNOWN_URN_GET.incrementStat();
            }
            return new HttpRequestLine(-3, "Invalid URN query", UploadManager.isHTTP11Request(string));
        }
        if (RECORD_STATS) {
            UploadStat.URN_GET.incrementStat();
        }
        return new HttpRequestLine(fileDesc.getIndex(), fileDesc.getName(), UploadManager.isHTTP11Request(string), (Map)hashMap);
    }

    private static boolean isHTTP11Request(String string) {
        return string.endsWith("1.1");
    }

    private void assertAsConnecting(int n) {
        Assert.that(n == 0, "invalid state: " + n);
    }

    private void assertAsComplete(int n) {
        Assert.that(n == 4, "invalid state: " + n);
    }

    private void assertAsFinished(int n) {
        Assert.that(n == 5 || n == 4, "invalid state: " + n);
    }

    public synchronized void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            bl = true;
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this._activeUploadList.iterator();
        while (iterator.hasNext()) {
            BandwidthTracker bandwidthTracker = (BandwidthTracker)iterator.next();
            float f2 = 0.0f;
            try {
                f2 = bandwidthTracker.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    static void tBandwidthTracker(UploadManager uploadManager) {
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 2000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 3000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 4000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == -1);
        uploadManager.reportUploadSpeed(100000L, 5000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 400);
        uploadManager.reportUploadSpeed(100000L, 6000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(1L, 1000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 480);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        uploadManager.reportUploadSpeed(100000L, 1000000L);
        Assert.that(uploadManager.measuredUploadSpeed() == 80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getUploads() {
        ArrayList arrayList = new ArrayList();
        UploadManager uploadManager = this;
        synchronized (uploadManager) {
            arrayList.addAll((Collection)this._activeUploadList);
        }
        return arrayList.iterator();
    }

    private static final class HttpRequestLine {
        final int _index;
        final String _fileName;
        final boolean _http11;
        final Map _params;

        HttpRequestLine(int n, String string, boolean bl) {
            this(n, string, bl, DataUtils.EMPTY_MAP);
        }

        HttpRequestLine(int n, String string, boolean bl, Map map) {
            this._index = n;
            this._fileName = string;
            this._http11 = bl;
            this._params = map == null ? DataUtils.EMPTY_MAP : map;
        }

        boolean isHTTP11() {
            return this._http11;
        }

        Map getParameters() {
            return this._params;
        }
    }

    private static class RequestCache {
        private static final double MAX_REQUESTS = 5000.0;
        private static final int MAX_ENTRIES = 10;
        static long WAIT_TIME = 900000L;
        static long FIRST_CHECK_TIME = 30000L;
        private final Set REQUESTS = new FixedSizeExpiringSet(10, WAIT_TIME);
        private double _numRequests = 0.0;
        private long _lastRequest = this._firstRequest = System.currentTimeMillis();
        private long _firstRequest;

        RequestCache() {
        }

        boolean isGreedy(URN uRN) {
            this.countRequest();
            return this.REQUESTS.contains((Object)uRN);
        }

        boolean isHammering() {
            if (this._lastRequest - this._firstRequest <= FIRST_CHECK_TIME) {
                return false;
            }
            return (double)(this._lastRequest - this._firstRequest) / this._numRequests < 5000.0;
        }

        void limitReached(URN uRN) {
            this.REQUESTS.add((Object)uRN);
        }

        private void countRequest() {
            this._numRequests += 1.0;
            this._lastRequest = System.currentTimeMillis();
        }
    }
}

