/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IncompleteFileManager
implements Serializable {
    static final long serialVersionUID = -7658285233614679878L;
    static final String SEPARATOR = "-";
    public static final String PREVIEW_PREFIX = "Preview-";
    private Map blocks = new TreeMap(Comparators.fileComparator());
    private Map hashes = new HashMap();

    public synchronized boolean purge(boolean bl) {
        File file;
        boolean bl2 = false;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (file.exists() && (!IncompleteFileManager.isOld(file) || !bl)) continue;
            bl2 = true;
            RouterService.getFileManager().removeFileIfShared(file);
            file.delete();
            iterator.remove();
        }
        if (bl) {
            iterator = this.hashes.values().iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (file.exists()) continue;
                iterator.remove();
                bl2 = true;
            }
        }
        return bl2;
    }

    private static final boolean isOld(File file) {
        long l = file.lastModified();
        long l2 = SharingSettings.INCOMPLETE_PURGE_TIME.getValue();
        long l3 = System.currentTimeMillis() - l2 * 24L * 60L * 60L * 1000L;
        return l < l3;
    }

    static boolean same(RemoteFileDesc remoteFileDesc, RemoteFileDesc remoteFileDesc2) {
        return IncompleteFileManager.same(remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn(), remoteFileDesc2.getFileName(), remoteFileDesc2.getSize(), remoteFileDesc2.getSHA1Urn());
    }

    static boolean same(String string, int n, URN uRN, String string2, int n2, URN uRN2) {
        if (uRN != null && uRN2 != null) {
            return uRN.equals(uRN2);
        }
        return n == n2 && string.equals(string2);
    }

    public synchronized File getFile(RemoteFileDesc remoteFileDesc) throws IOException {
        File file = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        file.mkdirs();
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (uRN != null) {
            File file2 = (File)this.hashes.get((Object)uRN);
            if (file2 != null) {
                return file2;
            }
            int n = 1;
            while (true) {
                file2 = new File(file, IncompleteFileManager.tempName(file.getAbsolutePath(), remoteFileDesc.getFileName(), remoteFileDesc.getSize(), n));
                file2 = FileUtils.getCanonicalFile(file2);
                if (!this.hashes.values().contains((Object)file2)) break;
                ++n;
            }
            this.hashes.put((Object)uRN, (Object)file2);
            FileUtils.touch(file2);
            return file2;
        }
        File file3 = new File(file, IncompleteFileManager.tempName(file.getAbsolutePath(), remoteFileDesc.getFileName(), remoteFileDesc.getSize(), 0));
        file3 = FileUtils.getCanonicalFile(file3);
        return file3;
    }

    public synchronized File getFileForUrn(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null urn");
        }
        return (File)this.hashes.get((Object)uRN);
    }

    private static String tempName(String string, String string2, int n, int n2) {
        if (n2 <= 1) {
            return "T-" + n + SEPARATOR + CommonUtils.convertFileName(string2, String.valueOf(string) + "T-" + n + SEPARATOR);
        }
        int n3 = string2.lastIndexOf(46);
        if (n3 < 0) {
            return "T-" + n + SEPARATOR + CommonUtils.convertFileName(string2, String.valueOf(string) + "T-" + n + "- (" + n2 + ")") + " (" + n2 + ")";
        }
        String string3 = string2.substring(0, n3);
        String string4 = string2.substring(n3);
        return "T-" + n + SEPARATOR + CommonUtils.convertFileName(string3, String.valueOf(string) + "T-" + n + "- (" + n2 + ")" + string4) + " (" + n2 + ")" + string4;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hashes = new HashMap();
        objectInputStream.defaultReadObject();
        this.blocks = this.transform(this.blocks);
        this.hashes = this.verifyHashes();
        this.registerAllIncompleteFiles();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        Map map = this.blocks;
        try {
            this.blocks = this.invTransform();
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.blocks = map;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.blocks = map;
            return;
        }
    }

    private Map verifyHashes() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!(entry.getKey() instanceof URN) || !(entry.getValue() instanceof File)) continue;
            URN uRN = (URN)entry.getKey();
            File file = (File)entry.getValue();
            try {
                file = FileUtils.getCanonicalFile(file);
                if (hashMap.values().contains((Object)file)) continue;
                hashMap.put((Object)uRN, (Object)file);
            }
            catch (IOException iOException) {}
        }
        return hashMap;
    }

    private Map transform(Object object) {
        Map map = (Map)object;
        TreeMap treeMap = new TreeMap(Comparators.fileComparator());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            VerifyingFile verifyingFile;
            Object object2 = iterator.next();
            Object object3 = map.get(object2);
            if (object3 == null || !(object2 instanceof File)) continue;
            File file = (File)object2;
            try {
                file = FileUtils.getCanonicalFile(file);
            }
            catch (IOException iOException) {
                continue;
            }
            Iterator iterator2 = ((List)object3).iterator();
            try {
                verifyingFile = new VerifyingFile(true, (int)IncompleteFileManager.getCompletedSize(file));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                verifyingFile = new VerifyingFile(true);
            }
            while (iterator2.hasNext()) {
                Interval interval = (Interval)iterator2.next();
                --interval.high;
                if (interval.high < interval.low) continue;
                verifyingFile.addInterval(interval);
            }
            treeMap.put((Object)file, (Object)verifyingFile);
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map invTransform() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            VerifyingFile verifyingFile;
            ArrayList arrayList = new ArrayList();
            Object object = iterator.next();
            VerifyingFile verifyingFile2 = verifyingFile = (VerifyingFile)this.blocks.get(object);
            synchronized (verifyingFile2) {
                List list = verifyingFile.getBlocksAsList();
                int n = 0;
                while (n < list.size()) {
                    Interval interval = (Interval)list.get(n);
                    Interval interval2 = new Interval(interval.low, interval.high + 1);
                    arrayList.add((Object)interval2);
                    ++n;
                }
            }
            hashMap.put(object, (Object)arrayList);
        }
        return hashMap;
    }

    public synchronized void removeEntry(File file) {
        this.blocks.remove((Object)file);
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!file.equals(entry.getValue())) continue;
            iterator.remove();
        }
        RouterService.getFileManager().removeFileIfShared(file);
    }

    public synchronized void addEntry(File file, VerifyingFile verifyingFile) throws IOException {
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {}
        this.blocks.put((Object)file, (Object)verifyingFile);
        this.registerIncompleteFile(file);
    }

    public synchronized VerifyingFile getEntry(File file) {
        Object object = this.blocks.get((Object)file);
        return (VerifyingFile)object;
    }

    public synchronized int getBlockSize(File file) {
        Object object = this.blocks.get((Object)file);
        if (object == null) {
            return 0;
        }
        VerifyingFile verifyingFile = (VerifyingFile)object;
        return verifyingFile.getBlockSize();
    }

    public synchronized void registerAllIncompleteFiles() {
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists() || IncompleteFileManager.isOld(file)) continue;
            this.registerIncompleteFile(file);
        }
    }

    private synchronized void registerIncompleteFile(File file) {
        Set set = this.getAllCompletedHashes(file);
        if (set.size() == 0) {
            return;
        }
        RouterService.getFileManager().addIncompleteFile(file, set, IncompleteFileManager.getCompletedName(file), (int)IncompleteFileManager.getCompletedSize(file), this.getEntry(file));
    }

    public static String getCompletedName(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        if (n2 == string.length() - 1) {
            throw new IllegalArgumentException("No name after last separator");
        }
        return string.substring(n2 + 1);
    }

    public static long getCompletedSize(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        try {
            return Long.parseLong(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number format: " + string);
        }
    }

    public synchronized URN getCompletedHash(File file) {
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!file.equals(entry.getValue())) continue;
            return (URN)entry.getKey();
        }
        return null;
    }

    public synchronized Set getAllCompletedHashes(File file) {
        HashSet hashSet = new HashSet(1);
        Iterator iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!file.equals(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        Iterator iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            File file = (File)iterator.next();
            List list = ((VerifyingFile)this.blocks.get((Object)file)).getBlocksAsList();
            stringBuffer.append(file);
            stringBuffer.append(":");
            stringBuffer.append(list.toString());
            bl = false;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public synchronized String dumpHashes() {
        return this.hashes.toString();
    }
}

