/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.ByteOrder;

public class IP {
    private static final String MSG = "Could not parse: ";
    private final long addr;
    private final long mask;

    public IP(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException(MSG);
        }
        this.addr = IP.bytesToLong(byArray, 0);
        this.mask = 0xFFFFFFFFL;
    }

    public IP(String string) throws IllegalArgumentException {
        int n = string.indexOf("/");
        if (n == -1) {
            this.addr = IP.stringToLong(string);
            this.mask = IP.createNetmaskFromWildChars(string);
        } else if (string.lastIndexOf("/") == n) {
            this.addr = IP.stringToLong(string.substring(0, n));
            this.mask = IP.parseNetmask(string.substring(n + 1));
        } else {
            throw new IllegalArgumentException(MSG + string);
        }
    }

    private static long parseNetmask(String string) throws IllegalArgumentException {
        if (string.indexOf(".") == -1) {
            try {
                int n = Short.parseShort(string);
                if (n > 32 || n < 0) {
                    throw new IllegalArgumentException(MSG + string);
                }
                long l = 0L;
                int n2 = 0;
                while (n2 < n) {
                    l <<= 1;
                    ++l;
                    ++n2;
                }
                return l <<= 32 - n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(MSG + string);
            }
        }
        return IP.stringToLong(string);
    }

    private static long bytesToLong(byte[] byArray, int n) {
        return ByteOrder.ubytes2long(ByteOrder.beb2int(byArray, n));
    }

    private static long stringToLong(String string) throws IllegalArgumentException {
        long l = 0L;
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c == '.') {
                    if (n5 != 0) break;
                    throw new IllegalArgumentException(MSG + string);
                }
                if (n5 > 2) {
                    throw new IllegalArgumentException(MSG + string);
                }
                if (c == '*') {
                    if (n5 != 0) {
                        throw new IllegalArgumentException(MSG + string);
                    }
                } else {
                    if (c < '0' || c > '9') {
                        throw new IllegalArgumentException(MSG + string);
                    }
                    if ((n4 = (int)((short)(n4 * 10 + c - 48))) > 255 || n4 < 0) {
                        throw new IllegalArgumentException(MSG + string);
                    }
                }
                ++n3;
                ++n5;
            }
            l = (l << 8) + (long)n4;
            ++n3;
            ++n;
        }
        while (n < 4) {
            l <<= 8;
            ++n;
        }
        if (n != 4) {
            throw new IllegalArgumentException(MSG + string);
        }
        return l;
    }

    private static long createNetmaskFromWildChars(String string) throws IllegalArgumentException {
        long l = 0L;
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c == '.') {
                    if (n5 != 0) break;
                    throw new IllegalArgumentException(MSG + string);
                }
                if (n5 > 2) {
                    throw new IllegalArgumentException(MSG + string);
                }
                if (c != '*') {
                    n4 = 255;
                } else if (n5 != 0) {
                    throw new IllegalArgumentException(MSG + string);
                }
                ++n3;
                ++n5;
            }
            l = (l << 8) + (long)n4;
            ++n3;
            ++n;
        }
        while (n < 4) {
            l <<= 8;
            ++n;
        }
        if (n != 4) {
            throw new IllegalArgumentException(MSG + string);
        }
        return l;
    }

    public boolean contains(IP iP) {
        return (iP.addr & this.mask) == (this.addr & this.mask);
    }

    public boolean equals(Object object) {
        if (object instanceof IP) {
            IP iP = (IP)object;
            return this.addr == iP.addr && this.mask == iP.mask;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.addr ^ this.mask);
    }
}

