/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.search.ProbeQuery;
import com.limegroup.gnutella.search.ResultCounter;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryHandler {
    private static final Log LOG;
    private final int RESULTS;
    public static final byte MAX_QUERY_TTL = 6;
    public static final int ULTRAPEER_RESULTS = 250;
    public static final double UP_RESULT_BUMP = 1.15;
    private static final int OLD_LEAF_RESULTS = 20;
    private static final int NEW_LEAF_RESULTS = 38;
    private static final int HASH_QUERY_RESULTS = 10;
    private static final int MAXIMUM_ROUTED_FOR_LEAVES = 75;
    private volatile long _timeToWaitPerHop = 2400L;
    private volatile long _timeToDecreasePerHop = 10L;
    private volatile int _numDecrements = 0;
    public static final int MAX_QUERY_TIME = 200000;
    private static MessageRouter _messageRouter;
    private static ConnectionManager _connectionManager;
    private volatile int _numResultsReportedByLeaf = 0;
    private volatile long _nextQueryTime = 0L;
    private volatile int _theoreticalHostsQueried = 1;
    private final ResultCounter RESULT_COUNTER;
    private final List QUERIED_CONNECTIONS = new ArrayList();
    private final List QUERIED_PROBE_CONNECTIONS = new ArrayList();
    private volatile long _queryStartTime = 0L;
    private volatile long _curTime = 0L;
    private final ReplyHandler REPLY_HANDLER;
    final QueryRequest QUERY;
    private volatile boolean _forwardedToLeaves = false;
    private boolean _probeQuerySent;
    private final String _prefLocale;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.search.QueryHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        _messageRouter = RouterService.getMessageRouter();
        _connectionManager = RouterService.getConnectionManager();
    }

    private QueryHandler(QueryRequest queryRequest, int n, ReplyHandler replyHandler, ResultCounter resultCounter) {
        if (queryRequest == null) {
            throw new IllegalArgumentException("null query");
        }
        if (replyHandler == null) {
            throw new IllegalArgumentException("null reply handler");
        }
        if (resultCounter == null) {
            throw new IllegalArgumentException("null result counter");
        }
        boolean bl = !queryRequest.getQueryUrns().isEmpty();
        this.QUERY = queryRequest;
        this.RESULTS = bl ? 10 : n;
        this.REPLY_HANDLER = replyHandler;
        this.RESULT_COUNTER = resultCounter;
        this._prefLocale = replyHandler.getLocalePref();
    }

    public static QueryHandler createHandler(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter) {
        return new QueryHandler(queryRequest, 250, replyHandler, resultCounter);
    }

    public static QueryHandler createHandlerForMe(QueryRequest queryRequest, ResultCounter resultCounter) {
        return new QueryHandler(queryRequest, 287, ForMeReplyHandler.instance(), resultCounter);
    }

    public static QueryHandler createHandlerForOldLeaf(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter) {
        return new QueryHandler(queryRequest, 20, replyHandler, resultCounter);
    }

    public static QueryHandler createHandlerForNewLeaf(QueryRequest queryRequest, ReplyHandler replyHandler, ResultCounter resultCounter) {
        return new QueryHandler(queryRequest, 38, replyHandler, resultCounter);
    }

    public static QueryRequest createQuery(QueryRequest queryRequest, byte by) {
        if (by < 1 || by > 6) {
            throw new IllegalArgumentException("ttl too high: " + by);
        }
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        if (queryRequest.getHops() == 0) {
            return QueryRequest.createQuery(queryRequest, by);
        }
        try {
            return QueryRequest.createNetworkQuery(queryRequest.getGUID(), by, queryRequest.getHops(), queryRequest.getPayload(), queryRequest.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            ErrorService.error(badPacketException);
            return null;
        }
    }

    QueryRequest createQuery(byte by) {
        return QueryHandler.createQuery(this.QUERY, by);
    }

    public void sendQuery() {
        Object object;
        if (this.hasEnoughResults()) {
            return;
        }
        this._curTime = System.currentTimeMillis();
        if (this._curTime < this._nextQueryTime) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Query = " + this.QUERY.getQuery() + ", numHostsQueried: " + this._theoreticalHostsQueried));
        }
        if (this._queryStartTime == 0L) {
            this._queryStartTime = this._curTime;
        }
        if (!this._forwardedToLeaves) {
            this._forwardedToLeaves = true;
            object = RouterService.getMessageRouter().getQueryRouteTable();
            QueryRequest queryRequest = QueryHandler.createQuery(this.QUERY, (byte)1);
            this._theoreticalHostsQueried += 25;
            if (object != null && ((QueryRouteTable)object).contains(queryRequest)) {
                RouterService.getMessageRouter().forwardQueryRequestToLeaves(queryRequest, this.REPLY_HANDLER);
                this._nextQueryTime = System.currentTimeMillis() + this._timeToWaitPerHop;
                return;
            }
        }
        if (!this._probeQuerySent) {
            object = new ProbeQuery(_connectionManager.getInitializedConnections(), this);
            long l = ((ProbeQuery)object).getTimeToWait();
            this._theoreticalHostsQueried += ((ProbeQuery)object).sendProbe();
            this._nextQueryTime = System.currentTimeMillis() + l;
            this._probeQuerySent = true;
            return;
        }
        int n = this.sendQuery((List)new ArrayList((Collection)_connectionManager.getInitializedConnections()));
        if (n == 0) {
            this._nextQueryTime = System.currentTimeMillis() + 6000L;
        }
        this._theoreticalHostsQueried += n;
        if (this._timeToWaitPerHop > 100L && System.currentTimeMillis() - this._queryStartTime > 6000L) {
            this._timeToWaitPerHop -= this._timeToDecreasePerHop;
            int n2 = Math.max(1, this.RESULTS / 2 - 30 * this.RESULT_COUNTER.getNumResults());
            int n3 = Math.max(1, this._numDecrements / 6);
            int n4 = n2 * n3;
            n4 = Math.max(5, n4);
            this._timeToDecreasePerHop += (long)n4;
            ++this._numDecrements;
            if (this._timeToWaitPerHop < 100L) {
                this._timeToWaitPerHop = 100L;
            }
        }
    }

    private int sendQuery(List list) {
        int n;
        List list2 = _connectionManager.getInitializedConnectionsMatchLocale(this._prefLocale);
        this.QUERIED_CONNECTIONS.retainAll((Collection)list);
        this.QUERIED_PROBE_CONNECTIONS.retainAll((Collection)list);
        if (!list2.isEmpty()) {
            list2.removeAll((Collection)this.QUERIED_CONNECTIONS);
            list2.removeAll((Collection)this.QUERIED_PROBE_CONNECTIONS);
        }
        if (list2.isEmpty()) {
            list2 = list;
            list2.removeAll((Collection)this.QUERIED_CONNECTIONS);
            list2.removeAll((Collection)this.QUERIED_PROBE_CONNECTIONS);
        }
        int n2 = list2.size();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("potential querier size: " + n2));
        }
        int n3 = 0;
        ManagedConnection managedConnection = null;
        Collections.shuffle((List)list2);
        int n4 = 0;
        while (n4 < n2) {
            ManagedConnection managedConnection2 = (ManagedConnection)list2.get(n4);
            if (managedConnection2.isStable(this._curTime)) {
                managedConnection = managedConnection2;
                break;
            }
            ++n4;
        }
        n4 = Math.max(n2 + this.QUERIED_PROBE_CONNECTIONS.size(), 0);
        if (n4 == 0) {
            return 0;
        }
        if (n4 > 4) {
            n4 -= 4;
        }
        boolean bl = false;
        if (managedConnection == null) {
            if (this.QUERIED_PROBE_CONNECTIONS.isEmpty()) {
                return 0;
            }
            managedConnection = (ManagedConnection)this.QUERIED_PROBE_CONNECTIONS.remove(0);
            bl = true;
        }
        int n5 = this._numResultsReportedByLeaf > 0 ? this._numResultsReportedByLeaf : this.RESULT_COUNTER.getNumResults();
        double d = (double)n5 / (double)this._theoreticalHostsQueried;
        int n6 = this.RESULTS - n5;
        int n7 = 40000;
        if (d != 0.0) {
            n7 = (int)((double)n6 / d);
        }
        if ((n3 = QueryHandler.calculateNewTTL(n = n7 / n4, managedConnection.getNumIntraUltrapeerConnections(), managedConnection.headers().getMaxTTL())) == 1 && (managedConnection.isUltrapeerQueryRoutingConnection() && !managedConnection.shouldForwardQuery(this.QUERY) || bl)) {
            n3 = 2;
        }
        QueryRequest queryRequest = QueryHandler.createQuery(this.QUERY, (byte)n3);
        return QueryHandler.sendQueryToHost(queryRequest, managedConnection, this);
    }

    static int sendQueryToHost(QueryRequest queryRequest, ManagedConnection managedConnection, QueryHandler queryHandler) {
        if (!_messageRouter.originateQuery(queryRequest, managedConnection)) {
            return 0;
        }
        byte by = queryRequest.getTTL();
        if (by == 1 && managedConnection.supportsProbeQueries()) {
            queryHandler.QUERIED_PROBE_CONNECTIONS.add((Object)managedConnection);
        } else {
            queryHandler.QUERIED_CONNECTIONS.add((Object)managedConnection);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("QUERIED_CONNECTIONS.size() = " + queryHandler.QUERIED_CONNECTIONS.size()));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Querying host " + managedConnection.getAddress() + " with ttl " + queryRequest.getTTL()));
        }
        queryHandler._nextQueryTime = System.currentTimeMillis() + (long)by * queryHandler._timeToWaitPerHop;
        return QueryHandler.calculateNewHosts(managedConnection, by);
    }

    private static byte calculateNewTTL(int n, int n2, byte by) {
        if (by > 6) {
            by = (byte)6;
        }
        byte by2 = 1;
        while (by2 < 6) {
            int n3 = (int)(16.0 * (double)QueryHandler.calculateNewHosts(n2, by2));
            if (n3 >= n) {
                if (by2 > by) {
                    return by;
                }
                return by2;
            }
            by2 = (byte)(by2 + 1);
        }
        return by;
    }

    private static int calculateNewHosts(Connection connection, byte by) {
        return QueryHandler.calculateNewHosts(connection.getNumIntraUltrapeerConnections(), by);
    }

    private static int calculateNewHosts(int n, byte by) {
        double d = 0.0;
        while (by > 0) {
            d += Math.pow(n - 1, by - 1);
            by = (byte)(by - 1);
        }
        return (int)d;
    }

    public boolean hasEnoughResults() {
        if (this._queryStartTime == 0L) {
            return false;
        }
        if (this._numResultsReportedByLeaf > 0) {
            if (this.RESULT_COUNTER.getNumResults() >= 75) {
                return true;
            }
            if (this._numResultsReportedByLeaf > this.RESULTS) {
                return true;
            }
        } else if (this.RESULT_COUNTER.getNumResults() >= this.RESULTS) {
            return true;
        }
        if (this._theoreticalHostsQueried > 110000) {
            return true;
        }
        int n = (int)(System.currentTimeMillis() - this._queryStartTime);
        return n > 200000;
    }

    public void updateLeafResults(int n) {
        if (n > this._numResultsReportedByLeaf) {
            this._numResultsReportedByLeaf = n;
        }
    }

    public int getNumResultsReportedByLeaf() {
        return this._numResultsReportedByLeaf;
    }

    public ReplyHandler getReplyHandler() {
        return this.REPLY_HANDLER;
    }

    public long getTimeToWaitPerHop() {
        return this._timeToWaitPerHop;
    }

    public String toString() {
        return "QueryHandler: QUERY: " + this.QUERY;
    }

    public GUID getGUID() {
        return new GUID(this.QUERY.getGUID());
    }
}

