/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptCBC;
import org.logi.crypto.modes.EncryptCBC;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.DHEKEKeyEx;
import org.logi.crypto.protocols.InterAuthServer;
import org.logi.crypto.protocols.InterKeyExServer;
import org.logi.crypto.protocols.ValidationException;

public class DHEKEKeyExServer
extends DHEKEKeyEx
implements InterKeyExServer,
InterAuthServer {
    private int nextStep = 1;

    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        try {
            switch (this.nextStep) {
                case 1: {
                    if (byArray == null) {
                        throw new CryptoProtocolException("Message expected");
                    }
                    ++this.nextStep;
                    Object object = new BigInteger(1, byArray);
                    byte[] byArray2 = ((BigInteger)object).modPow(this.myPrivate, this.m).toByteArray();
                    try {
                        this.sessionKey = Crypto.makeSessionKey(this.keyType, byArray2);
                        this.pbs = this.sessionKey.plainBlockSize();
                        this.cbs = this.sessionKey.plainBlockSize();
                    }
                    catch (InvalidCDSException invalidCDSException) {
                        throw new CryptoProtocolException(invalidCDSException.getMessage());
                    }
                    byArray2 = this.myPublic.toByteArray();
                    byte[] byArray3 = new byte[byArray2.length + 2];
                    Crypto.writeBytes(byArray2.length, byArray3, 0, 2);
                    System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
                    object = new EncryptCBC(this.secretKey).flush(byArray3, 0, byArray3.length);
                    this.myRandom = new byte[this.pbs];
                    random.nextBytes(this.myRandom);
                    byArray2 = new byte[this.cbs];
                    this.sessionKey.encrypt(this.myRandom, 0, byArray2, 0);
                    byArray3 = new byte[2 + ((Object)object).length + byArray2.length];
                    Crypto.writeBytes(((Object)object).length, byArray3, 0, 2);
                    System.arraycopy(object, 0, byArray3, 2, ((Object)object).length);
                    System.arraycopy(byArray2, 0, byArray3, 2 + ((Object)object).length, byArray2.length);
                    return byArray3;
                }
                case 2: {
                    if (byArray == null) {
                        throw new CryptoProtocolException("Message expected");
                    }
                    ++this.nextStep;
                    byte[] byArray4 = new DecryptCBC(this.sessionKey).decrypt(byArray, 0, byArray.length);
                    if (byArray4.length < 2 * this.pbs) {
                        throw new CryptoProtocolException("The message was too short");
                    }
                    int n = 0;
                    while (n < this.pbs) {
                        if (byArray4[this.pbs + n] != this.myRandom[n]) {
                            throw new ValidationException("The client does not know the secret");
                        }
                        ++n;
                    }
                    byte[] byArray5 = new byte[this.cbs];
                    this.sessionKey.encrypt(byArray4, 0, byArray5, 0);
                    this.completed = true;
                    return byArray5;
                }
            }
            throw new CryptoProtocolException("The protocol has been completed");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public DHEKEKeyExServer(int n, String string, CipherKey cipherKey) {
        super(n, string, cipherKey);
    }
}

