/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.mpeg.sampled.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import javazoom.spi.mpeg.sampled.file.IcyListener;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileFormat;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import javazoom.spi.mpeg.sampled.file.MpegEncoding;
import javazoom.spi.mpeg.sampled.file.MpegFileFormatType;
import javazoom.spi.mpeg.sampled.file.tag.IcyInputStream;
import javazoom.spi.mpeg.sampled.file.tag.MP3Tag;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    private final int SYNC = -2097152;
    private final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{MpegEncoding.MPEG2L1, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L3}, {MpegEncoding.MPEG1L1, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L3}, {MpegEncoding.MPEG2DOT5L1, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L3}};
    private static final int INITAL_READ_LENGTH = 64000;
    private static final int MARK_LIMIT = 64001;
    private static final String[] id3v1genres = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Capela", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "SynthPop"};

    public MpegAudioFileReader() {
        super(64001, true);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)">MpegAudioFileReader()");
        }
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        return super.getAudioFileFormat(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(URL): begin");
        }
        long l = -1L;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Icy-Metadata", "1");
        InputStream inputStream = uRLConnection.getInputStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream, l);
        }
        finally {
            inputStream.close();
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(URL): end");
        }
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        Object object;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)">MpegAudioFileReader.getAudioFileFormat(InputStream inputStream, long mediaLength): begin");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Comparable<Boolean>> hashMap2 = new HashMap<String, Comparable<Boolean>>();
        int n = (int)l;
        int n2 = inputStream.available();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 64001);
        byte[] byArray = new byte[12];
        pushbackInputStream.read(byArray);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)("InputStream : " + inputStream + " =>" + new String(byArray)));
        }
        if (byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70 && byArray[8] == 87 && byArray[9] == 65 && byArray[10] == 86 && byArray[11] == 69) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"WAV stream found");
            }
            throw new UnsupportedAudioFileException("WAV stream found");
        }
        if (byArray[0] == 46 && byArray[1] == 115 && byArray[2] == 110 && byArray[3] == 100) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"AU stream found");
            }
            throw new UnsupportedAudioFileException("AU stream found");
        }
        if (byArray[0] == 70 && byArray[1] == 79 && byArray[2] == 82 && byArray[3] == 77 && byArray[8] == 65 && byArray[9] == 73 && byArray[10] == 70 && byArray[11] == 70) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"AIFF stream found");
            }
            throw new UnsupportedAudioFileException("AIFF stream found");
        }
        if (byArray[0] == 73 | byArray[0] == 105 && byArray[1] == 67 | byArray[1] == 99 && byArray[2] == 89 | byArray[2] == 121) {
            pushbackInputStream.unread(byArray);
            this.loadShoutcastInfo(pushbackInputStream, hashMap);
        } else {
            if (byArray[0] == 79 | byArray[0] == 111 && byArray[1] == 71 | byArray[1] == 103 && byArray[2] == 71 | byArray[2] == 103) {
                if (TDebug.TraceAudioFileReader) {
                    TDebug.out((String)"Ogg stream found");
                }
                throw new UnsupportedAudioFileException("Ogg stream found");
            }
            pushbackInputStream.unread(byArray);
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        float f = -1.0f;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        boolean bl = false;
        AudioFormat.Encoding encoding = null;
        try {
            Bitstream bitstream = new Bitstream((InputStream)pushbackInputStream);
            hashMap.put("mp3.header.pos", new Integer(bitstream.header_pos()));
            Header header = bitstream.readFrame();
            n3 = header.version();
            if (n3 == 2) {
                hashMap.put("mp3.version.mpeg", Float.toString(2.5f));
            } else {
                hashMap.put("mp3.version.mpeg", Integer.toString(2 - n3));
            }
            n4 = header.layer();
            hashMap.put("mp3.version.layer", Integer.toString(n4));
            n5 = header.sample_frequency();
            n6 = header.mode();
            hashMap.put("mp3.mode", new Integer(n6));
            n12 = n6 == 3 ? 1 : 2;
            hashMap.put("mp3.channels", new Integer(n12));
            bl = header.vbr();
            hashMap2.put("vbr", new Boolean(bl));
            hashMap.put("mp3.vbr", new Boolean(bl));
            hashMap.put("mp3.vbr.scale", new Integer(header.vbr_scale()));
            n7 = header.calculate_framesize();
            hashMap.put("mp3.framesize.bytes", new Integer(n7));
            if (n7 < 0) {
                throw new UnsupportedAudioFileException("Invalid FrameSize : " + n7);
            }
            n9 = header.frequency();
            hashMap.put("mp3.frequency.hz", new Integer(n9));
            f = (float)(1.0 / (double)header.ms_per_frame() * 1000.0);
            hashMap.put("mp3.framerate.fps", new Float(f));
            if (f < 0.0f) {
                throw new UnsupportedAudioFileException("Invalid FrameRate : " + f);
            }
            if (n != -1) {
                hashMap.put("mp3.length.bytes", new Integer(n));
                n10 = header.max_number_of_frames(n);
                hashMap.put("mp3.length.frames", new Integer(n10));
            }
            n11 = header.bitrate();
            hashMap2.put("bitrate", new Integer(n11));
            hashMap.put("mp3.bitrate.nominal.bps", new Integer(n11));
            n13 = header.getSyncHeader();
            encoding = this.sm_aEncodings[n3][n4 - 1];
            hashMap.put("mp3.version.encoding", encoding.toString());
            if (n != -1) {
                n14 = Math.round(header.total_ms(n));
                hashMap.put("duration", new Long((long)n14 * 1000L));
            }
            hashMap.put("mp3.copyright", new Boolean(header.copyright()));
            hashMap.put("mp3.original", new Boolean(header.original()));
            hashMap.put("mp3.crc", new Boolean(header.checksums()));
            hashMap.put("mp3.padding", new Boolean(header.padding()));
            object = bitstream.getRawID3v2();
            if (object != null) {
                hashMap.put("mp3.id3tag.v2", object);
                this.parseID3v2Frames((InputStream)object, hashMap);
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)header.toString());
            }
        }
        catch (Exception exception) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)("not a MPEG stream:" + exception.getMessage()));
            }
            throw new UnsupportedAudioFileException("not a MPEG stream:" + exception.getMessage());
        }
        int n15 = n13 >> 19 & 3;
        if (n15 == 1) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"not a MPEG stream: wrong version");
            }
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int n16 = n13 >> 10 & 3;
        if (n16 == 3) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"not a MPEG stream: wrong sampling rate");
            }
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        if ((long)n2 == l && l != -1L) {
            object = (FileInputStream)inputStream;
            byte[] byArray2 = new byte[128];
            long l2 = ((FileInputStream)object).skip(inputStream.available() - byArray2.length);
            int n17 = ((FileInputStream)object).read(byArray2, 0, byArray2.length);
            if (byArray2[0] == 84 && byArray2[1] == 65 && byArray2[2] == 71) {
                this.parseID3v1Frames(byArray2, hashMap);
            }
        }
        object = new MpegAudioFormat(encoding, n9, -1, n12, -1, f, true, hashMap2);
        return new MpegAudioFileFormat(MpegFileFormatType.MP3, (AudioFormat)object, n10, n, hashMap);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"getAudioInputStream(File file)");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(fileInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        Object object;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioInputStream(URL): begin");
        }
        long l = -1L;
        URLConnection uRLConnection = uRL.openConnection();
        boolean bl = false;
        int n = 4;
        byte[] byArray = new byte[n];
        uRLConnection.setRequestProperty("Icy-Metadata", "1");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        bufferedInputStream.mark(n);
        int n2 = bufferedInputStream.read(byArray, 0, n);
        if (n2 > 2 && byArray[0] == 73 | byArray[0] == 105 && byArray[1] == 67 | byArray[1] == 99 && byArray[2] == 89 | byArray[2] == 121) {
            bl = true;
        }
        bufferedInputStream.reset();
        Object object2 = null;
        if (bl) {
            object = new IcyInputStream(bufferedInputStream);
            ((IcyInputStream)object).addTagParseListener(IcyListener.getInstance());
            object2 = object;
        } else {
            object = uRLConnection.getHeaderField("icy-metaint");
            if (object != null) {
                IcyInputStream icyInputStream = new IcyInputStream((InputStream)bufferedInputStream, (String)object);
                icyInputStream.addTagParseListener(IcyListener.getInstance());
                object2 = icyInputStream;
            } else {
                object2 = bufferedInputStream;
            }
        }
        object = null;
        try {
            object = this.getAudioInputStream((InputStream)object2, l);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)object2).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)object2).close();
            throw iOException;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioInputStream(URL): end");
        }
        return object;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioInputStream(InputStream inputStream)");
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return super.getAudioInputStream(inputStream);
    }

    protected void parseID3v1Frames(byte[] byArray, HashMap hashMap) {
        String string;
        int n;
        String string2 = new String(byArray, 0, byArray.length);
        int n2 = 3;
        String string3 = this.chopSubstring(string2, n2, n2 += 30);
        String string4 = (String)hashMap.get("title");
        if ((string4 == null || string4.length() == 0) && string3 != null) {
            hashMap.put("title", string3);
        }
        String string5 = this.chopSubstring(string2, n2, n2 += 30);
        String string6 = (String)hashMap.get("author");
        if ((string6 == null || string6.length() == 0) && string5 != null) {
            hashMap.put("author", string5);
        }
        String string7 = this.chopSubstring(string2, n2, n2 += 30);
        String string8 = (String)hashMap.get("album");
        if ((string8 == null || string8.length() == 0) && string7 != null) {
            hashMap.put("album", string7);
        }
        String string9 = this.chopSubstring(string2, n2, n2 += 4);
        String string10 = (String)hashMap.get("year");
        if ((string10 == null || string10.length() == 0) && string9 != null) {
            hashMap.put("year", string9);
        }
        String string11 = this.chopSubstring(string2, n2, n2 += 28);
        String string12 = (String)hashMap.get("comment");
        if ((string12 == null || string12.length() == 0) && string11 != null) {
            hashMap.put("comment", string11);
        }
        String string13 = "" + (byArray[126] & 0xFF);
        String string14 = (String)hashMap.get("mp3.id3tag.track");
        if ((string14 == null || string14.length() == 0) && string13 != null) {
            hashMap.put("mp3.id3tag.track", string13);
        }
        if ((n = byArray[127] & 0xFF) >= 0 && n < id3v1genres.length && ((string = (String)hashMap.get("mp3.id3tag.genre")) == null || string.length() == 0)) {
            hashMap.put("mp3.id3tag.genre", id3v1genres[n]);
        }
    }

    private String chopSubstring(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        int n3 = string2.indexOf(0);
        if (n3 != -1) {
            string2 = string2.substring(0, n3);
        }
        return string2;
    }

    protected void parseID3v2Frames(InputStream inputStream, HashMap hashMap) {
        block22: {
            int n;
            byte[] byArray;
            block21: {
                byArray = null;
                n = -1;
                try {
                    n = inputStream.available();
                    byArray = new byte[n];
                    inputStream.mark(n);
                    inputStream.read(byArray);
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceAudioFileReader) break block21;
                    TDebug.out((String)("Cannot parse ID3v2 :" + iOException.getMessage()));
                }
            }
            try {
                String string = null;
                for (int i = 0; i < byArray.length - 4; ++i) {
                    String string2 = new String(byArray, i, 4);
                    if (!string2.equals("TALB") && !string2.equals("TIT2") && !string2.equals("TYER") && !string2.equals("TPE1") && !string2.equals("TCOP") && !string2.equals("COMM") && !string2.equals("TCON") && !string2.equals("TRCK")) continue;
                    n = (byArray[(i += 10) - 6] << 24) + (byArray[i - 5] << 16) + (byArray[i - 4] << 8) + byArray[i - 3];
                    string = string2.equals("COMM") ? this.parseText(byArray, i, n, 5) : this.parseText(byArray, i, n, 1);
                    if (string != null && string.length() > 0) {
                        if (string2.equals("TALB")) {
                            hashMap.put("album", string);
                        } else if (string2.equals("TIT2")) {
                            hashMap.put("title", string);
                        } else if (string2.equals("TYER")) {
                            hashMap.put("date", string);
                        } else if (string2.equals("TPE1")) {
                            hashMap.put("author", string);
                        } else if (string2.equals("TCOP")) {
                            hashMap.put("copyright", string);
                        } else if (string2.equals("COMM")) {
                            hashMap.put("comment", string);
                        } else if (string2.equals("TCON")) {
                            hashMap.put("mp3.id3tag.genre", string);
                        } else if (string2.equals("TRCK")) {
                            hashMap.put("mp3.id3tag.track", string);
                        }
                    }
                    i = i + n - 1;
                }
            }
            catch (RuntimeException runtimeException) {
                if (!TDebug.TraceAudioFileReader) break block22;
                TDebug.out((String)("Cannot parse ID3v2 :" + runtimeException.getMessage()));
            }
        }
    }

    protected String parseText(byte[] byArray, int n, int n2, int n3) {
        String string;
        block2: {
            string = null;
            try {
                String[] stringArray = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
                string = new String(byArray, n + n3, n2 - n3, stringArray[byArray[n]]);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!TDebug.TraceAudioFileReader) break block2;
                TDebug.out((String)("ID3v2 Encoding error :" + unsupportedEncodingException.getMessage()));
            }
        }
        return string;
    }

    protected void loadShoutcastInfo(InputStream inputStream, HashMap hashMap) throws IOException {
        MP3Tag[] mP3TagArray;
        IcyInputStream icyInputStream = new IcyInputStream(new BufferedInputStream(inputStream));
        HashMap hashMap2 = icyInputStream.getTagHash();
        MP3Tag mP3Tag = icyInputStream.getTag("icy-name");
        if (mP3Tag != null) {
            hashMap.put("title", ((String)mP3Tag.getValue()).trim());
        }
        if ((mP3TagArray = icyInputStream.getTags()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < mP3TagArray.length; ++i) {
                String string = mP3TagArray[i].getName();
                String string2 = ((String)icyInputStream.getTag(string).getValue()).trim();
                hashMap.put("mp3.shoutcast.metadata." + string, string2);
            }
        }
    }
}

