/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader;

import edu.emory.mathcs.util.classloader.ResourceFinder;
import edu.emory.mathcs.util.classloader.ResourceHandle;
import edu.emory.mathcs.util.security.action.GetPropertyAction;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class GenericClassLoader
extends SecureClassLoader {
    protected ResourceFinder finder;
    private AccessControlContext acc;

    public GenericClassLoader(ResourceFinder finder, ClassLoader parent) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.finder = finder;
        this.acc = AccessController.getContext();
    }

    public GenericClassLoader(ResourceFinder finder) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.finder = finder;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    ResourceHandle h = GenericClassLoader.this.finder.getResource(path);
                    if (h != null) {
                        try {
                            return GenericClassLoader.this.defineClass(name, h);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected Class defineClass(String name, ResourceHandle h) throws IOException {
        int i = name.lastIndexOf(46);
        URL url = h.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = h.getManifest();
            if (pkg != null) {
                boolean ok;
                if (pkg.isSealed()) {
                    ok = pkg.isSealed(url);
                } else {
                    boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                }
                if (!ok) {
                    throw new SecurityException("sealing violation: " + name);
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        byte[] b = h.getBytes();
        Certificate[] certs = h.getCertificates();
        CodeSource cs = new CodeSource(url, certs);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected URL findResource(final String name) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return GenericClassLoader.this.finder.findResource(name);
            }
        }, this.acc);
    }

    protected Enumeration findResources(final String name) throws IOException {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return GenericClassLoader.this.finder.findResources(name);
            }
        }, this.acc);
    }

    protected String findLibrary(String libname) {
        ResourceHandle md = this.getLibraryHandle(libname);
        if (md == null) {
            return null;
        }
        URL url = md.getURL();
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        return new File(URI.create(url.toString())).getPath();
    }

    protected ResourceHandle getClassHandle(String name) {
        String path = name.replace('.', '/').concat(".class");
        return this.getResourceHandle(path);
    }

    protected ResourceHandle getResourceHandle(final String name) {
        return (ResourceHandle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return GenericClassLoader.this.finder.getResource(name);
            }
        }, this.acc);
    }

    protected ResourceHandle getLibraryHandle(String name) {
        String simplename;
        String path;
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            path = "";
            simplename = name;
        } else {
            if (idx == name.length() - 1) {
                throw new IllegalArgumentException(name);
            }
            path = name.substring(0, idx + 1);
            simplename = name.substring(idx + 1);
        }
        return this.getResourceHandle(path + System.mapLibraryName(simplename));
    }

    protected Enumeration getResourceHandles(final String name) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return GenericClassLoader.this.finder.getResources(name);
            }
        }, this.acc);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        URL sealBase = null;
        Attributes entryAttr = man.getAttributes(path);
        Attributes mainAttr = man.getMainAttributes();
        String specTitle = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealed = GenericClassLoader.getManifestVal(entryAttr, mainAttr, Attributes.Name.SEALED);
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static String getManifestVal(Attributes entryAttr, Attributes mainAttr, Attributes.Name key) {
        String val = null;
        if (entryAttr != null) {
            val = entryAttr.getValue(key);
        }
        if (val == null && mainAttr != null) {
            val = mainAttr.getValue(key);
        }
        return val;
    }

    public static URLStreamHandler getDefaultURLStreamHandler(String protocol) {
        String pkgList = (String)AccessController.doPrivileged(new GetPropertyAction("java.protocol.handler.pkgs", ""));
        if (pkgList.length() > 0) {
            pkgList = pkgList + "|";
        }
        pkgList = pkgList + "sun.net.www.protocol";
        StringTokenizer tokenizer = new StringTokenizer(pkgList, "|");
        while (tokenizer.hasMoreTokens()) {
            String pkg = tokenizer.nextToken().trim();
            try {
                Class<?> cls;
                String clname = pkg + "." + protocol + ".Handler";
                try {
                    cls = Class.forName(clname);
                }
                catch (ClassNotFoundException e) {
                    cls = Class.forName(clname, false, null);
                }
                return (URLStreamHandler)cls.newInstance();
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

