/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class ResourceHandle {
    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] buf;
        InputStream in = this.getInputStream();
        try {
            int len;
            if (len != -1) {
                int read;
                buf = new byte[len];
                for (len = this.getContentLength(); len > 0; len -= read) {
                    read = in.read(buf, buf.length - len, len);
                    if (read >= 0) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] aux;
                buf = new byte[2048];
                int total = 0;
                while ((len = in.read(buf, total, buf.length - total)) >= 0) {
                    if ((total += len) < buf.length) continue;
                    aux = new byte[total * 2];
                    System.arraycopy(buf, 0, aux, 0, total);
                    buf = aux;
                }
                if (total != buf.length) {
                    aux = new byte[total];
                    System.arraycopy(buf, 0, aux, 0, total);
                    buf = aux;
                }
            }
        }
        finally {
            in.close();
        }
        return buf;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public Attributes getAttributes() throws IOException {
        Manifest m = this.getManifest();
        if (m == null) {
            return null;
        }
        String entry = this.getURL().getFile();
        return m.getAttributes(entry);
    }

    public void close() {
    }

    public String toString() {
        return "[" + this.getName() + ": " + this.getURL() + "; code source: " + this.getCodeSourceURL() + "]";
    }
}

