/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader;

import edu.emory.mathcs.util.classloader.ResourceHandle;
import edu.emory.mathcs.util.classloader.ResourceUtils;
import edu.emory.mathcs.util.classloader.jar.JarURLStreamHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ResourceLoader {
    private static final String JAR_INDEX_ENTRY_NAME = "META-INF/INDEX.LIST";
    final URLStreamHandler jarHandler;
    final Map url2jarInfo = new HashMap();
    static /* synthetic */ Class class$edu$emory$mathcs$util$classloader$ResourceLoader;

    public ResourceLoader() {
        this(new JarURLStreamHandler());
    }

    public ResourceLoader(URLStreamHandler jarHandler) {
        this.jarHandler = jarHandler;
    }

    public ResourceHandle getResource(URL source, String name) {
        return this.getResource(source, name, new HashSet(), null);
    }

    public ResourceHandle getResource(URL[] sources, String name) {
        HashSet visited = new HashSet();
        for (int i = 0; i < sources.length; ++i) {
            ResourceHandle h = this.getResource(sources[i], name, visited, null);
            if (h == null) continue;
            return h;
        }
        return null;
    }

    public Enumeration getResources(URL source, String name) {
        return new ResourceEnumeration(new URL[]{source}, name, false);
    }

    public Enumeration getResources(URL[] sources, String name) {
        return new ResourceEnumeration((URL[])sources.clone(), name, false);
    }

    private ResourceHandle getResource(final URL source, String name, Set visitedJars, Set skip) {
        name = ResourceUtils.canonizePath(name);
        if (ResourceLoader.isDir(source)) {
            URLConnection conn;
            URL url;
            try {
                URI relUri = new URI(null, null, null, -1, name, null, null);
                url = new URL(source, relUri.getRawPath());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal resource name: " + name);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if (skip != null && skip.contains(url)) {
                return null;
            }
            try {
                conn = url.openConnection();
                conn.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
            final String finalName = name;
            return new ResourceHandle(){

                public String getName() {
                    return finalName;
                }

                public URL getURL() {
                    return url;
                }

                public URL getCodeSourceURL() {
                    return source;
                }

                public InputStream getInputStream() throws IOException {
                    return conn.getInputStream();
                }

                public int getContentLength() {
                    return conn.getContentLength();
                }

                public void close() {
                    try {
                        this.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        try {
            return this.getJarInfo(source).getResource(name, visitedJars, skip);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL findResource(URL source, String name) {
        return this.findResource(source, name, new HashSet(), null);
    }

    public URL findResource(URL[] sources, String name) {
        HashSet visited = new HashSet();
        for (int i = 0; i < sources.length; ++i) {
            URL url = this.findResource(sources[i], name, visited, null);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration findResources(URL source, String name) {
        return new ResourceEnumeration(new URL[]{source}, name, true);
    }

    public Enumeration findResources(URL[] sources, String name) {
        return new ResourceEnumeration((URL[])sources.clone(), name, true);
    }

    private URL findResource(URL source, String name, Set visitedJars, Set skip) {
        name = ResourceUtils.canonizePath(name);
        if (ResourceLoader.isDir(source)) {
            URL url;
            try {
                url = new URL(source, name);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if (skip != null && skip.contains(url)) {
                return null;
            }
            try {
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    httpConn.setRequestMethod("HEAD");
                    if (httpConn.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    conn.getInputStream().close();
                }
            }
            catch (IOException e) {
                return null;
            }
            return url;
        }
        try {
            ResourceHandle rh = this.getJarInfo(source).getResource(name, visitedJars, skip);
            return rh != null ? rh.getURL() : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected static boolean isDir(URL url) {
        String file = url.getFile();
        return file != null && file.endsWith("/");
    }

    private static Map package2url(Map indexes) {
        Map.Entry entry;
        HashMap<String, ArrayList<URL>> prefix2url = new HashMap<String, ArrayList<URL>>();
        Iterator i = indexes.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            URL url = (URL)entry.getKey();
            List idx = (List)entry.getValue();
            Iterator j = idx.iterator();
            while (j.hasNext()) {
                String prefix = (String)j.next();
                ArrayList<URL> prefixList = (ArrayList<URL>)prefix2url.get(prefix);
                if (prefixList == null) {
                    prefixList = new ArrayList<URL>();
                    prefix2url.put(prefix, prefixList);
                }
                prefixList.add(url);
            }
        }
        i = prefix2url.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            List list = (List)entry.getValue();
            entry.setValue(list.toArray(new URL[list.size()]));
        }
        return prefix2url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarInfo getJarInfo(URL url) throws MalformedURLException {
        JarInfo jinfo;
        Map map = this.url2jarInfo;
        synchronized (map) {
            jinfo = (JarInfo)this.url2jarInfo.get(url.toExternalForm());
            if (jinfo == null) {
                jinfo = new JarInfo(this, url);
                this.url2jarInfo.put(url.toExternalForm(), jinfo);
            }
        }
        return jinfo;
    }

    private static Map parseJarIndex(URL cxt, JarFile jar) throws IOException {
        String line;
        JarEntry entry = jar.getJarEntry(JAR_INDEX_ENTRY_NAME);
        if (entry == null) {
            return Collections.EMPTY_MAP;
        }
        InputStream is = jar.getInputStream(entry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        LinkedHashMap result = new LinkedHashMap();
        while ((line = reader.readLine()) != null && line.trim().length() > 0) {
        }
        ArrayList<String> currentList = null;
        block1: while ((line = reader.readLine()) != null) {
            URL currentURL = new URL(cxt, line);
            currentList = new ArrayList<String>();
            result.put(currentURL, currentList);
            while (true) {
                if ((line = reader.readLine()) == null || line.trim().length() == 0) continue block1;
                currentList.add(line);
            }
            break;
        }
        return result;
    }

    private static URL[] parseClassPath(JarFile jar, URL source) throws IOException {
        Manifest man = jar.getManifest();
        if (man == null) {
            return new URL[0];
        }
        Attributes attr = man.getMainAttributes();
        if (attr == null) {
            return new URL[0];
        }
        String cp = attr.getValue(Attributes.Name.CLASS_PATH);
        if (cp == null) {
            return new URL[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(cp);
        ArrayList<URL> cpList = new ArrayList<URL>();
        URI sourceURI = URI.create(source.toString());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                try {
                    URI uri = new URI(token);
                    if (!uri.isAbsolute()) {
                        uri = sourceURI.resolve(uri);
                    }
                    cpList.add(uri.toURL());
                }
                catch (URISyntaxException e) {
                    URL url = new URL(source, token);
                    cpList.add(url);
                }
            }
            catch (MalformedURLException e) {
                throw new IOException(e.getMessage());
            }
        }
        return cpList.toArray(new URL[cpList.size()]);
    }

    private class ResourceEnumeration
    implements Enumeration {
        final URL[] urls;
        final String name;
        final boolean findOnly;
        int idx;
        Object next;
        Set previousURLs = new HashSet();

        ResourceEnumeration(URL[] urls, String name, boolean findOnly) {
            this.urls = urls;
            this.name = name;
            this.findOnly = findOnly;
            this.idx = 0;
        }

        public boolean hasMoreElements() {
            this.fetchNext();
            return this.next != null;
        }

        public Object nextElement() {
            this.fetchNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        private void fetchNext() {
            if (this.next != null) {
                return;
            }
            while (this.idx < this.urls.length) {
                if (this.findOnly) {
                    URL url = ResourceLoader.this.findResource(this.urls[this.idx], this.name, new HashSet(), this.previousURLs);
                    if (url != null) {
                        this.previousURLs.add(url);
                        this.next = url;
                        return;
                    }
                } else {
                    ResourceHandle h = ResourceLoader.this.getResource(this.urls[this.idx], this.name, new HashSet(), this.previousURLs);
                    if (h != null) {
                        this.previousURLs.add(h.getURL());
                        this.next = h;
                        return;
                    }
                }
                ++this.idx;
            }
        }
    }

    private static class JarResourceHandle
    extends ResourceHandle {
        final JarFile jar;
        final JarEntry jentry;
        final URL url;
        final URL codeSource;

        JarResourceHandle(JarFile jar, JarEntry jentry, URL url, URL codeSource) {
            this.jar = jar;
            this.jentry = jentry;
            this.url = url;
            this.codeSource = codeSource;
        }

        public String getName() {
            return this.jentry.getName();
        }

        public URL getURL() {
            return this.url;
        }

        public URL getCodeSourceURL() {
            return this.codeSource;
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.getInputStream(this.jentry);
        }

        public int getContentLength() {
            return (int)this.jentry.getSize();
        }

        public Manifest getManifest() throws IOException {
            return this.jar.getManifest();
        }

        public Attributes getAttributes() throws IOException {
            return this.jentry.getAttributes();
        }

        public Certificate[] getCertificates() {
            return this.jentry.getCertificates();
        }

        public void close() {
        }
    }

    private static class JarInfo {
        final ResourceLoader loader;
        final URL source;
        final URL base;
        JarFile jar;
        boolean resolved;
        Permission perm;
        URL[] classPath;
        String[] index;
        Map package2url;
        static final /* synthetic */ boolean $assertionsDisabled;

        JarInfo(ResourceLoader loader, URL source) throws MalformedURLException {
            this.loader = loader;
            this.source = source;
            this.base = new URL("jar", "", -1, source + "!/", loader.jarHandler);
        }

        public ResourceHandle getResource(String name) {
            return this.getResource(name, new HashSet());
        }

        ResourceHandle getResource(String name, Set visited) {
            return this.getResource(name, visited, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResourceHandle getResource(String name, Set visited, Set skip) {
            URL[] dependencies;
            Object jentry;
            URL url;
            visited.add(this.source);
            try {
                URI relUri = new URI(null, null, null, -1, name, null, null);
                url = new URL(this.base, relUri.getRawPath());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal resource name: " + name);
            }
            catch (MalformedURLException e) {
                return null;
            }
            try {
                JarFile jfile = this.getJarFileIfPossiblyContains(name);
                if (!(jfile == null || (jentry = this.jar.getJarEntry(name)) == null || skip != null && skip.contains(url))) {
                    return new JarResourceHandle(jfile, (JarEntry)jentry, url, this.source);
                }
            }
            catch (IOException e) {
                return null;
            }
            jentry = this;
            synchronized (jentry) {
                if (this.package2url != null) {
                    int idx = name.lastIndexOf("/");
                    String prefix = idx > 0 ? name.substring(0, idx) : name;
                    dependencies = (URL[])this.package2url.get(prefix);
                } else {
                    if (!$assertionsDisabled && this.classPath == null) {
                        throw new AssertionError();
                    }
                    dependencies = this.classPath;
                }
            }
            if (dependencies == null) {
                return null;
            }
            for (int i = 0; i < dependencies.length; ++i) {
                URL cpUrl = dependencies[i];
                if (visited.contains(cpUrl)) continue;
                try {
                    JarInfo depJInfo = this.loader.getJarInfo(cpUrl);
                    ResourceHandle rh = depJInfo.getResource(name, visited, skip);
                    if (rh == null) continue;
                    return rh;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return null;
        }

        synchronized void setIndex(List newIndex) {
            if (this.jar != null) {
                return;
            }
            if (this.index != null) {
                HashSet<String> violating = new HashSet<String>(Arrays.asList(this.index));
                violating.removeAll(newIndex);
                if (!violating.isEmpty()) {
                    throw new RuntimeException("Invalid JAR index: the following entries were previously declared, but they are not present in the new index: " + ((Object)violating).toString());
                }
            }
            this.index = newIndex.toArray(new String[newIndex.size()]);
            Arrays.sort(this.index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarFile getJarFileIfPossiblyContains(String name) throws IOException {
            JarInfo jarInfo;
            Map indexes;
            JarInfo jarInfo2 = this;
            synchronized (jarInfo2) {
                if (this.jar != null) {
                    SecurityManager security = System.getSecurityManager();
                    if (security != null) {
                        security.checkPermission(this.perm);
                    }
                    try {
                        while (!this.resolved) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted");
                    }
                    return this.jar;
                }
                if (this.index != null) {
                    int pos = name.lastIndexOf(47);
                    if (pos > 0) {
                        name = name.substring(0, pos);
                    }
                    if (Arrays.binarySearch(this.index, name) < 0) {
                        return null;
                    }
                }
                JarURLConnection conn = (JarURLConnection)this.base.openConnection();
                this.perm = conn.getPermission();
                JarFile jar = conn.getJarFile();
                if (this.index != null) {
                    HashSet<String> indices = new HashSet<String>(Arrays.asList(this.index));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String indexEntry = entry.getName();
                        int pos = indexEntry.lastIndexOf(47);
                        if (pos > 0) {
                            indexEntry = indexEntry.substring(0, pos);
                        }
                        indices.remove(indexEntry);
                    }
                    if (!indices.isEmpty()) {
                        throw new RuntimeException("Invalid JAR index: the following entries not found in JAR: " + indices);
                    }
                }
                this.jar = jar;
                this.classPath = ResourceLoader.parseClassPath(jar, this.source);
                indexes = ResourceLoader.parseJarIndex(this.source, jar);
                indexes.remove(this.source.toExternalForm());
                if (!indexes.isEmpty()) {
                    this.package2url = ResourceLoader.package2url(indexes);
                }
            }
            try {
                Iterator itr = indexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    URL url = (URL)entry.getKey();
                    if (url.toExternalForm().equals(this.source.toExternalForm())) continue;
                    List index = (List)entry.getValue();
                    this.loader.getJarInfo(url).setIndex(index);
                }
                Object var13_15 = null;
                jarInfo = this;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                JarInfo jarInfo3 = this;
                synchronized (jarInfo3) {
                    this.resolved = true;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (jarInfo) {
                this.resolved = true;
                this.notifyAll();
            }
            return this.jar;
        }

        static {
            $assertionsDisabled = !(class$edu$emory$mathcs$util$classloader$ResourceLoader == null ? (class$edu$emory$mathcs$util$classloader$ResourceLoader = ResourceLoader.class$("edu.emory.mathcs.util.classloader.ResourceLoader")) : class$edu$emory$mathcs$util$classloader$ResourceLoader).desiredAssertionStatus();
        }
    }
}

