/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceUtils {
    private static final Pattern dotInMiddlePattern = Pattern.compile("/\\./");
    private static final Pattern dotAtBegPattern = Pattern.compile("^\\./");
    private static final Pattern dotAtEndPattern = Pattern.compile("/\\.$");
    private static final Pattern multipleSlashPattern = Pattern.compile("//+");
    private static final Pattern initialParentPattern = Pattern.compile("/?(\\.\\./)*");
    private static final Pattern embeddedParentPattern = Pattern.compile("[^/]+/\\.\\./");
    private static final Pattern trailingParentPattern = Pattern.compile("[^/]+/\\.\\.$");
    private static final Pattern initialAbsParentPattern = Pattern.compile("^/(\\.\\./)+");
    private static final Pattern initialAbsSingleParentPattern = Pattern.compile("^/\\.\\.$");

    private ResourceUtils() {
    }

    public static boolean isLocalFile(URI uri) {
        if (!uri.isAbsolute()) {
            return false;
        }
        if (uri.isOpaque()) {
            return false;
        }
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            return false;
        }
        if (uri.getAuthority() != null) {
            return false;
        }
        if (uri.getFragment() != null) {
            return false;
        }
        if (uri.getQuery() != null) {
            return false;
        }
        return !"".equals(uri.getPath());
    }

    public static String canonizePath(String path) {
        StringBuffer buf = new StringBuffer(path);
        StringBuffer aux = new StringBuffer();
        while (ResourceUtils.replaceAll(buf, aux, dotInMiddlePattern, "/", 0)) {
        }
        ResourceUtils.replaceAll(buf, aux, multipleSlashPattern, "/", 0);
        ResourceUtils.replaceFirst(buf, aux, dotAtBegPattern, "", 0);
        ResourceUtils.replaceFirst(buf, aux, dotAtEndPattern, "/", 0);
        int pos = 0;
        while (pos < buf.length() && ResourceUtils.replaceFirst(buf, aux, embeddedParentPattern, "", pos += ResourceUtils.skipPrefix(buf, aux, initialParentPattern, pos))) {
        }
        ResourceUtils.replaceFirst(buf, aux, trailingParentPattern, "", pos);
        ResourceUtils.replaceFirst(buf, aux, initialAbsParentPattern, "/", 0);
        ResourceUtils.replaceFirst(buf, aux, initialAbsSingleParentPattern, "/", 0);
        return buf.toString();
    }

    public static boolean isAbsolute(String path) {
        return path.length() > 0 && path.charAt(0) == '/';
    }

    private static boolean replaceFirst(StringBuffer buf, StringBuffer aux, Pattern pattern, String replacement, int pos) {
        boolean chg = false;
        aux.setLength(0);
        Matcher matcher = pattern.matcher(buf);
        if (matcher.find(pos)) {
            matcher.appendReplacement(aux, replacement);
            chg = true;
        }
        matcher.appendTail(aux);
        buf.setLength(0);
        buf.append(aux);
        return chg;
    }

    private static boolean replaceAll(StringBuffer buf, StringBuffer aux, Pattern pattern, String replacement, int pos) {
        boolean found;
        aux.setLength(0);
        Matcher matcher = pattern.matcher(buf);
        boolean chg = found = matcher.find(pos);
        while (found) {
            matcher.appendReplacement(aux, replacement);
            found = matcher.find();
        }
        matcher.appendTail(aux);
        buf.setLength(0);
        buf.append(aux);
        return chg;
    }

    private static int skipPrefix(StringBuffer buf, StringBuffer aux, Pattern pattern, int pos) {
        Matcher matcher = initialParentPattern.matcher(buf);
        if (matcher.find(pos)) {
            return matcher.end() - pos;
        }
        return 0;
    }
}

