/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader.jar;

import edu.emory.mathcs.util.classloader.ResourceUtils;
import edu.emory.mathcs.util.classloader.jar.JarURLConnection;
import edu.emory.mathcs.util.io.RedirectingInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarProxy
implements JarURLConnection.JarOpener {
    private final Map cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFile openJarFile(JarURLConnection conn) throws IOException {
        CachedJarFile result;
        URL url = conn.getJarFileURL();
        Map map = this.cache;
        synchronized (map) {
            result = (CachedJarFile)this.cache.get(url);
        }
        if (result != null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(result.perm);
            }
            return result;
        }
        try {
            URI uri = new URI(url.toString());
            if (ResourceUtils.isLocalFile(uri)) {
                File file = new File(uri);
                FilePermission perm = new FilePermission(file.getAbsolutePath(), "read");
                result = new CachedJarFile(file, perm, false);
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (result == null) {
            final URLConnection jarconn = url.openConnection();
            jarconn.setAllowUserInteraction(conn.getAllowUserInteraction());
            jarconn.setDoInput(conn.getDoInput());
            jarconn.setDoOutput(conn.getDoOutput());
            jarconn.setIfModifiedSince(conn.getIfModifiedSince());
            Map<String, List<String>> map2 = conn.getRequestProperties();
            Iterator<Map.Entry<String, List<String>>> itr = map2.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, List<String>> entry = itr.next();
                jarconn.setRequestProperty(entry.getKey(), (String)((Object)entry.getValue()));
            }
            jarconn.setUseCaches(conn.getUseCaches());
            final InputStream in = this.getJarInputStream(jarconn);
            try {
                result = (CachedJarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        File file = File.createTempFile("jar_cache", "");
                        FileOutputStream out = new FileOutputStream(file);
                        try {
                            RedirectingInputStream r = new RedirectingInputStream(in, false, false);
                            int len = r.redirectAll(out);
                            out.flush();
                            if (len == 0) {
                                Object var5_5 = null;
                                return var5_5;
                            }
                        }
                        finally {
                            out.close();
                        }
                        return new CachedJarFile(file, jarconn.getPermission(), true);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
            finally {
                in.close();
            }
        }
        if (result == null) {
            return null;
        }
        map = this.cache;
        synchronized (map) {
            CachedJarFile asyncResult = (CachedJarFile)this.cache.get(url);
            if (asyncResult != null) {
                result.closeCachedFile();
                return asyncResult;
            }
            this.cache.put(url, result);
            return result;
        }
    }

    protected InputStream getJarInputStream(URLConnection conn) throws IOException {
        return conn.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        HashMap cache;
        Map map = this.cache;
        synchronized (map) {
            cache = new HashMap(this.cache);
            this.cache.clear();
        }
        Iterator itr = cache.values().iterator();
        while (itr.hasNext()) {
            CachedJarFile jfile = (CachedJarFile)itr.next();
            try {
                jfile.closeCachedFile();
            }
            catch (IOException e) {}
        }
    }

    protected void finalize() {
        this.clear();
    }

    private static class CachedJarFile
    extends JarFile {
        final Permission perm;

        CachedJarFile(File file, Permission perm, boolean tmp) throws IOException {
            super(file, true, 1 | (tmp ? 4 : 0));
            this.perm = perm;
        }

        public Manifest getManifest() throws IOException {
            Manifest orig = super.getManifest();
            if (orig == null) {
                return null;
            }
            Manifest man = new Manifest();
            man.getMainAttributes().putAll((Map<?, ?>)orig.getMainAttributes());
            Iterator<Map.Entry<String, Attributes>> itr = orig.getEntries().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, Attributes> entry = itr.next();
                man.getEntries().put(entry.getKey(), new Attributes(entry.getValue()));
            }
            return man;
        }

        public ZipEntry getEntry(String name) {
            return super.getEntry(name);
        }

        protected void finalize() throws IOException {
            this.closeCachedFile();
        }

        protected void closeCachedFile() throws IOException {
            super.close();
        }

        public void close() throws IOException {
        }

        private static class Entry
        extends JarEntry {
            JarEntry jentry;

            Entry(JarEntry jentry) {
                super(jentry);
                this.jentry = jentry;
            }

            public Certificate[] getCertificates() {
                Certificate[] certs = this.jentry.getCertificates();
                return certs == null ? null : (Certificate[])certs.clone();
            }

            public Attributes getAttributes() throws IOException {
                Attributes attr = this.jentry.getAttributes();
                return attr == null ? null : new Attributes(attr);
            }
        }
    }
}

