/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections;

import edu.emory.mathcs.backport.java.util.AbstractMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class AsyncWeakValueMap
extends AbstractMap
implements ConcurrentMap {
    private final ConcurrentMap map;
    transient Set entrySet;
    private static final ReferenceQueue rqueue = new ReferenceQueue();
    static boolean prunerStarted;

    public AsyncWeakValueMap() {
        this(new ConcurrentHashMap());
    }

    public AsyncWeakValueMap(ConcurrentMap map) {
        if (!map.isEmpty()) {
            throw new IllegalStateException("Backing map is not empty");
        }
        this.map = map;
        this.startPruner();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        return value == null ? false : this.map.containsValue(new CompareRef(value));
    }

    public void putAll(Map t) {
        Iterator itr = t.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            Object key = e.getKey();
            this.map.put(key, this.wrapValue(key, e.getValue(), rqueue));
        }
    }

    public Set entrySet() {
        Set entrySet = this.entrySet;
        if (entrySet == null) {
            this.entrySet = entrySet = new EntrySetView();
        }
        return entrySet;
    }

    public Object get(Object key) {
        return AsyncWeakValueMap.unwrapValue(this.map.get(key));
    }

    public Object remove(Object key) {
        return AsyncWeakValueMap.detachValue(this.map.remove(key));
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, new CompareRef(value));
    }

    public boolean replace(Object key, Object oldVal, Object newVal) {
        ValueRef ref = this.wrapValue(key, newVal, rqueue);
        boolean replaced = this.map.replace(key, new CompareRef(oldVal), ref);
        if (!replaced) {
            AsyncWeakValueMap.detachValue(ref);
        }
        return replaced;
    }

    public Object replace(Object key, Object newVal) {
        ValueRef ref = this.wrapValue(key, newVal, rqueue);
        Object oldVal = AsyncWeakValueMap.detachValue(this.map.replace(key, ref));
        if (oldVal != null) {
            AsyncWeakValueMap.detachValue(ref);
        }
        return oldVal;
    }

    public Object put(Object key, Object value) {
        ValueRef ref = this.wrapValue(key, value, rqueue);
        return AsyncWeakValueMap.detachValue(this.map.put(key, ref));
    }

    public Object putIfAbsent(Object key, Object value) {
        ValueRef ref = this.wrapValue(key, value, rqueue);
        Object oldVal = AsyncWeakValueMap.detachValue(this.map.putIfAbsent(key, ref));
        if (oldVal != null) {
            AsyncWeakValueMap.detachValue(ref);
        }
        return oldVal;
    }

    private static boolean eqNonNull(Object o1, Object o2) {
        return o1 == null ? false : o1.equals(o2);
    }

    private ValueRef wrapValue(Object key, Object value, ReferenceQueue rqueue) {
        return new ValueRef(this.map, key, value, rqueue);
    }

    private static Object unwrapValue(Object value) {
        return value == null ? null : ((ValueRef)value).getValue();
    }

    private static Object detachValue(Object value) {
        if (value == null) {
            return null;
        }
        ValueRef ref = (ValueRef)value;
        Object val = ref.getValue();
        ref.clear();
        return val;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    synchronized void startPruner() {
        if (prunerStarted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                new Pruner().start();
                return null;
            }
        });
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        return tg;
    }

    private static final class Pruner
    extends Thread {
        Pruner() {
            super(AsyncWeakValueMap.getRootThreadGroup(), "Weak Collection Pruner");
            this.setDaemon(true);
            this.setContextClassLoader(null);
        }

        public void run() {
            try {
                while (true) {
                    DestroyableReference r = (DestroyableReference)((Object)rqueue.remove());
                    r.destroy();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface DestroyableReference {
        public void destroy();
    }

    private class EntryWrapper
    implements Map.Entry {
        final Map.Entry entry;
        Object val;

        EntryWrapper(Map.Entry entry, Object val) {
            this.entry = entry;
            this.val = val;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object val) {
            Object old = this.val;
            this.entry.setValue(AsyncWeakValueMap.this.wrapValue(this.entry.getKey(), val, rqueue));
            this.val = val;
            return old;
        }

        void clear() {
            ValueRef val = (ValueRef)this.entry.getValue();
            val.clear();
            val.enqueue();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return AsyncWeakValueMap.eq(this.entry.getKey(), e.getKey()) && this.val.equals(e.getValue());
        }

        public int hashCode() {
            Object key = this.entry.getKey();
            return (key == null ? 0 : key.hashCode()) ^ this.val.hashCode();
        }

        public String toString() {
            return this.entry.getKey() + "=" + this.val;
        }
    }

    private class EntryIterator
    implements Iterator {
        final Iterator itr;
        EntryWrapper cursor;
        EntryWrapper lastRet;

        EntryIterator(Iterator itr) {
            this.itr = itr;
            this.cursor = this.fetchNext();
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.fetchNext();
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.lastRet.clear();
            this.lastRet = null;
        }

        private EntryWrapper fetchNext() {
            while (this.itr.hasNext()) {
                Map.Entry e = (Map.Entry)this.itr.next();
                Object val = AsyncWeakValueMap.unwrapValue(e.getValue());
                if (val == null) continue;
                return new EntryWrapper(e, val);
            }
            return null;
        }
    }

    private class EntrySetView
    extends AbstractSet {
        EntrySetView() {
        }

        public int size() {
            return AsyncWeakValueMap.this.map.size();
        }

        public void clear() {
            AsyncWeakValueMap.this.map.clear();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object val = e.getValue();
            if (val == null) {
                return false;
            }
            return AsyncWeakValueMap.eqNonNull(AsyncWeakValueMap.unwrapValue(AsyncWeakValueMap.this.map.get(e.getKey())), val);
        }

        public boolean isEmpty() {
            return AsyncWeakValueMap.this.map.isEmpty();
        }

        public boolean remove(Object o) {
            if (AsyncWeakValueMap.this.map.isEmpty()) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object val = e.getValue();
            if (val == null) {
                return false;
            }
            return AsyncWeakValueMap.this.map.remove(key, new CompareRef(val));
        }

        public Iterator iterator() {
            return new EntryIterator(AsyncWeakValueMap.this.map.entrySet().iterator());
        }
    }

    private static class CompareRef {
        final Object val;

        CompareRef(Object val) {
            this.val = val;
        }

        public Object getValue() {
            return this.val;
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ValueRef) {
                return AsyncWeakValueMap.eqNonNull(this.getValue(), ((ValueRef)other).getValue());
            }
            return false;
        }
    }

    private static class ValueRef
    extends WeakReference
    implements DestroyableReference {
        final Object key;
        final ConcurrentMap map;

        ValueRef(ConcurrentMap map, Object key, Object val, ReferenceQueue rqueue) {
            super(val, rqueue);
            this.key = key;
            this.map = map;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.get();
        }

        public int hashCode() {
            Object val = this.getValue();
            return val == null ? 0 : val.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ValueRef) {
                return AsyncWeakValueMap.eqNonNull(this.getValue(), ((ValueRef)other).getValue());
            }
            if (other instanceof CompareRef) {
                return AsyncWeakValueMap.eqNonNull(this.getValue(), ((CompareRef)other).getValue());
            }
            return false;
        }

        public void destroy() {
            this.map.remove(this.key, this);
        }
    }
}

