/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

public class RadkeHashMap
implements Map,
Cloneable,
Serializable {
    transient Object[] keys;
    transient Object[] values;
    transient int size;
    transient int fill;
    int treshold;
    final float loadFactor;
    final float resizeTreshold;
    transient KeySet keySet;
    transient EntrySet entrySet;
    transient Values valueCollection;
    private static final int[] radkeNumbers = new int[]{3, 7, 11, 19, 43, 67, 139, 263, 523, 1031, 2063, 4099, 8219, 16411, 32779, 65539, 131111, 262147, 524347, 0x100007, 2097211, 0x40000F, 0x80000B, 16777259, 0x2000023, 0x400000F, 0x8000033, 0x10000003, 0x2000000B, 0x40000003};
    private static final Object NULL = new Object();
    private static final Object REMOVED = new Object();
    private static final long serialVersionUID = 362498820763181265L;

    public RadkeHashMap() {
        this(19);
    }

    public RadkeHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public RadkeHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 0.3f);
    }

    public RadkeHashMap(int initialCapacity, float loadFactor, float resizeTreshold) {
        initialCapacity = RadkeHashMap.radkeAtLeast(initialCapacity);
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be betweeen 0 and 1");
        }
        if (resizeTreshold <= 0.0f || resizeTreshold > 1.0f) {
            throw new IllegalArgumentException("Fill treshold must be betweeen 0 and 1");
        }
        this.keys = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
        this.size = 0;
        this.fill = 0;
        this.loadFactor = loadFactor;
        this.resizeTreshold = resizeTreshold;
        this.treshold = (int)(loadFactor * (float)initialCapacity);
    }

    public RadkeHashMap(Map m) {
        this(Math.max((int)((double)m.size() / 0.75) + 1, 19), 0.75f);
        this.putAll(m);
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            key = NULL;
        }
        int hsize = this.keys.length;
        int start = (key.hashCode() & Integer.MAX_VALUE) % hsize;
        int refill = -1;
        Object prevkey = this.keys[start];
        if (prevkey == null) {
            this.keys[start] = key;
            this.values[start] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (prevkey == REMOVED) {
            refill = start;
        } else if (RadkeHashMap.eqNonNull(prevkey, key)) {
            Object oldval = this.values[start];
            this.values[start] = value;
            return oldval;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prevkey = this.keys[p]) == null) {
            if (refill >= 0) {
                this.keys[refill] = key;
                this.values[refill] = value;
                ++this.size;
                return null;
            }
            this.keys[p] = key;
            this.values[p] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (prevkey == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (RadkeHashMap.eqNonNull(prevkey, key)) {
            Object oldval = this.values[p];
            this.values[p] = value;
            return oldval;
        }
        if ((p = start - 1) < 0) {
            p += hsize;
        }
        if ((prevkey = this.keys[p]) == null) {
            if (refill >= 0) {
                this.keys[refill] = key;
                this.values[refill] = value;
                ++this.size;
                return null;
            }
            this.keys[p] = key;
            this.values[p] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (prevkey == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (RadkeHashMap.eqNonNull(prevkey, key)) {
            Object oldval = this.values[p];
            this.values[p] = value;
            return oldval;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prevkey = this.keys[pu]) == null) {
                if (refill >= 0) {
                    this.keys[refill] = key;
                    this.values[refill] = value;
                    ++this.size;
                    return null;
                }
                this.keys[pu] = key;
                this.values[pu] = value;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (prevkey == REMOVED) {
                if (refill < 0) {
                    refill = pu;
                }
            } else if (RadkeHashMap.eqNonNull(prevkey, key)) {
                Object oldval = this.values[pu];
                this.values[pu] = value;
                return oldval;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prevkey = this.keys[pd]) == null) {
                if (refill >= 0) {
                    this.keys[refill] = key;
                    this.values[refill] = value;
                    ++this.size;
                    return null;
                }
                this.keys[pd] = key;
                this.values[pd] = value;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (prevkey == REMOVED) {
                if (refill < 0) {
                    refill = pd;
                }
            } else if (RadkeHashMap.eqNonNull(prevkey, key)) {
                Object oldval = this.values[pd];
                this.values[pd] = value;
                return oldval;
            }
            pu += j;
            pd -= j;
        }
        throw new RuntimeException("hash map is full");
    }

    public Object get(Object key) {
        if (key == null) {
            key = NULL;
        }
        int hsize = this.keys.length;
        int start = (key.hashCode() & Integer.MAX_VALUE) % hsize;
        Object prevkey = this.keys[start];
        if (prevkey == null) {
            return null;
        }
        if (RadkeHashMap.eqNonNull(prevkey, key)) {
            return this.values[start];
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prevkey = this.keys[p]) == null) {
            return null;
        }
        if (RadkeHashMap.eqNonNull(prevkey, key)) {
            return this.values[p];
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prevkey = this.keys[p]) == null) {
            return null;
        }
        if (RadkeHashMap.eqNonNull(prevkey, key)) {
            return this.values[p];
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prevkey = this.keys[pu]) == null) {
                return null;
            }
            if (RadkeHashMap.eqNonNull(prevkey, key)) {
                return this.values[pu];
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prevkey = this.keys[pd]) == null) {
                return null;
            }
            if (RadkeHashMap.eqNonNull(prevkey, key)) {
                return this.values[pd];
            }
            pu += j;
            pd -= j;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return this.find(key) >= 0;
    }

    private boolean containsMapping(Object key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        return RadkeHashMap.equals(value, this.values[p]);
    }

    public Object remove(Object key) {
        int p = this.find(key);
        if (p < 0) {
            return null;
        }
        Object removed = this.values[p];
        this.keys[p] = REMOVED;
        this.values[p] = null;
        --this.size;
        return removed;
    }

    private boolean removeMapping(Object key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object val = this.values[p];
        if (!RadkeHashMap.equals(value, val)) {
            return false;
        }
        this.keys[p] = REMOVED;
        this.values[p] = null;
        --this.size;
        return true;
    }

    private final int find(Object key) {
        if (key == null) {
            key = NULL;
        }
        int hsize = this.keys.length;
        int start = (key.hashCode() & Integer.MAX_VALUE) % hsize;
        Object prevkey = this.keys[start];
        if (prevkey == null) {
            return -1;
        }
        if (RadkeHashMap.eqNonNull(prevkey, key)) {
            return start;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prevkey = this.keys[p]) == null) {
            return -1;
        }
        if (RadkeHashMap.eqNonNull(prevkey, key)) {
            return p;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prevkey = this.keys[p]) == null) {
            return -1;
        }
        if (RadkeHashMap.eqNonNull(prevkey, key)) {
            return p;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prevkey = this.keys[pu]) == null) {
                return -1;
            }
            if (RadkeHashMap.eqNonNull(prevkey, key)) {
                return pu;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prevkey = this.keys[pd]) == null) {
                return -1;
            }
            if (RadkeHashMap.eqNonNull(prevkey, key)) {
                return pd;
            }
            pu += j;
            pd -= j;
        }
        return -1;
    }

    public boolean containsValue(Object val) {
        int p = this.findVal(val);
        return p >= 0;
    }

    private int findVal(Object value) {
        if (value == null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.values[i] != null || this.keys[i] == null || this.keys[i] == REMOVED) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!RadkeHashMap.eqNonNull(value, this.values[i])) continue;
            return i;
        }
        return -1;
    }

    private void rehash() {
        if ((float)this.size >= (float)this.fill * this.resizeTreshold) {
            this.rehash(RadkeHashMap.radkeAtLeast(this.keys.length + 1));
        } else {
            this.rehash(this.keys.length);
        }
    }

    private void rehash(int newcapacity) {
        Object[] oldkeys = this.keys;
        Object[] oldvals = this.values;
        this.keys = new Object[newcapacity];
        this.values = new Object[newcapacity];
        this.size = 0;
        this.fill = 0;
        this.treshold = (int)(this.loadFactor * (float)newcapacity);
        for (int i = 0; i < oldkeys.length; ++i) {
            if (oldkeys[i] == null || oldkeys[i] == REMOVED) continue;
            this.put(oldkeys[i], oldvals[i]);
        }
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.fill = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void putAll(Map map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.valueCollection == null) {
            this.valueCollection = new Values();
        }
        return this.valueCollection;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            Object val = this.values[i];
            Object val2 = that.get(key);
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
                if (that.containsKey(key)) continue;
                return false;
            }
            if (val2 != null && (val == val2 || val.equals(val2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            Object val = this.values[i];
            hash += (key == null ? 0 : key.hashCode()) ^ (val == null ? 0 : val.hashCode());
        }
        return hash;
    }

    public Object clone() {
        RadkeHashMap result;
        try {
            result = (RadkeHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.keys = new Object[this.keys.length];
        result.values = new Object[this.values.length];
        result.keySet = null;
        result.entrySet = null;
        result.valueCollection = null;
        result.fill = 0;
        result.size = 0;
        result.putAll((Map)this);
        return result;
    }

    private boolean keySetContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.containsKey(itr.next())) continue;
            return false;
        }
        return true;
    }

    private boolean keySetRemoveMapping(Object key) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object removed = this.values[p];
        this.keys[p] = REMOVED;
        this.values[p] = null;
        --this.size;
        return true;
    }

    private boolean keySetRemoveAll(Collection c) {
        boolean modified = false;
        if (this.keys.length * 2 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (key == null || key == REMOVED) continue;
                if (key == NULL) {
                    key = null;
                }
                if (!c.contains(key)) continue;
                this.keys[i] = REMOVED;
                this.values[i] = null;
                --this.size;
                modified = true;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.keySetRemoveMapping(itr.next());
            }
        }
        return modified;
    }

    private boolean keySetRetainAll(Collection c) {
        boolean modified = false;
        if (this.keys.length * 4 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (key == null || key == REMOVED) continue;
                if (key == NULL) {
                    key = null;
                }
                if (c.contains(key)) continue;
                this.keys[i] = REMOVED;
                this.values[i] = null;
                --this.size;
                modified = true;
            }
        } else {
            RadkeHashMap tmp = new RadkeHashMap(this.keys.length, this.loadFactor, this.resizeTreshold);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                int p = this.find(key);
                if (p < 0) continue;
                tmp.put(key, this.values[p]);
                modified = true;
            }
            if (modified) {
                this.keys = tmp.keys;
                this.values = tmp.values;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    private Object[] keySetToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object key = this.keys[j];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            a[i++] = key;
        }
        return a;
    }

    private Object[] keySetToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object key = this.keys[j];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            a[i++] = key;
        }
        return a;
    }

    private boolean entrySetContainsEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return this.containsMapping(e.getKey(), e.getValue());
    }

    private boolean entrySetContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            Map.Entry e;
            Object o = itr.next();
            if (!(o instanceof Map.Entry) || this.containsMapping((e = (Map.Entry)o).getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean entrySetRemoveMapping(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return this.removeMapping(e.getKey(), e.getValue());
    }

    private boolean entrySetRemoveAll(Collection c) {
        boolean modified = false;
        if (this.keys.length < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object value;
                Object key = this.keys[i];
                if (key == null || key == REMOVED) continue;
                if (key == NULL) {
                    key = null;
                }
                if (!c.contains(new SimpleEntry(key, value = this.values[i]))) continue;
                this.keys[i] = REMOVED;
                this.values[i] = null;
                --this.size;
                modified = true;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.entrySetRemoveMapping(itr.next());
            }
        }
        return modified;
    }

    private boolean entrySetRetainAll(Collection c) {
        boolean modified = false;
        if (this.keys.length * 4 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object value;
                Object key = this.keys[i];
                if (key == null || key == REMOVED) continue;
                if (key == NULL) {
                    key = null;
                }
                if (c.contains(new SimpleEntry(key, value = this.values[i]))) continue;
                this.keys[i] = REMOVED;
                this.values[i] = null;
                --this.size;
                modified = true;
            }
        } else {
            RadkeHashMap tmp = new RadkeHashMap(this.keys.length, this.loadFactor, this.resizeTreshold);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Map.Entry e;
                int p;
                Object o = itr.next();
                if (!(o instanceof Map.Entry) || (p = this.find((e = (Map.Entry)o).getKey())) < 0 || !RadkeHashMap.equals(e.getValue(), this.values[p])) continue;
                tmp.put(e.getKey(), this.values[p]);
            }
            boolean bl = modified = this.size != tmp.size;
            if (modified) {
                this.keys = tmp.keys;
                this.values = tmp.values;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    private Object[] entrySetToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object key = this.keys[j];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            Object value = this.values[j];
            a[i++] = new SimpleEntry(key, value);
        }
        return a;
    }

    private Object[] entrySetToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object key = this.keys[j];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            Object value = this.values[j];
            a[i++] = new SimpleEntry(key, value);
        }
        return a;
    }

    private boolean valuesContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.containsValue(itr.next())) continue;
            return false;
        }
        return true;
    }

    private boolean valuesRemoveMapping(Object value) {
        int p = this.findVal(value);
        if (p < 0) {
            return false;
        }
        Object removed = this.values[p];
        this.keys[p] = REMOVED;
        this.values[p] = null;
        --this.size;
        return true;
    }

    private boolean valuesRemoveAll(Collection c) {
        boolean modified = false;
        for (int i = 0; i < this.keys.length; ++i) {
            Object value;
            Object key = this.keys[i];
            if (key == null || key == REMOVED || !c.contains(value = this.values[i])) continue;
            this.keys[i] = REMOVED;
            this.values[i] = null;
            --this.size;
            modified = true;
        }
        return modified;
    }

    private boolean valuesRetainAll(Collection c) {
        boolean modified = false;
        for (int i = 0; i < this.keys.length; ++i) {
            Object value;
            Object key = this.keys[i];
            if (key == null || key == REMOVED || c.contains(value = this.values[i])) continue;
            this.keys[i] = REMOVED;
            this.values[i] = null;
            --this.size;
            modified = true;
        }
        return modified;
    }

    private Object[] valuesToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object key = this.keys[j];
            if (key == null || key == REMOVED) continue;
            a[i++] = this.values[j];
        }
        return a;
    }

    private Object[] valuesToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object key = this.keys[j];
            if (key == null || key == REMOVED) continue;
            a[i++] = this.values[j];
        }
        return a;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.keys.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            out.writeObject(key);
            out.writeObject(this.values[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    public static int radkeAtLeast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative array size");
        }
        for (int i = 0; i < radkeNumbers.length; ++i) {
            if (radkeNumbers[i] < n) continue;
            return radkeNumbers[i];
        }
        throw new IllegalArgumentException("Overflow: hash table too large");
    }

    private static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    private static final boolean eqNonNull(Object o1, Object o2) {
        return o1 == o2 || o1.equals(o2);
    }

    public static void main(String[] args) {
        Test.hashMapTest(100, 1, 21880, 1000);
    }

    private static class Test {
        private Test() {
        }

        public static void hashMapTest(int iters, int floor, int ceil, int gets) {
            Random r = new Random(1L);
            RadkeHashMap rmap = new RadkeHashMap(ceil / 2, 0.75f, 0.3f);
            HashMap<Integer, Integer> hmap = new HashMap<Integer, Integer>(ceil / 2);
            long total = 0L;
            for (int i = 0; i < iters; ++i) {
                System.out.println("total: " + total);
                while (rmap.size() < ceil) {
                    Integer o2;
                    Integer val;
                    Integer key = new Integer(r.nextInt(ceil * 5));
                    Object o1 = rmap.put(key, val = new Integer(r.nextInt()));
                    if (!RadkeHashMap.equals(o1, o2 = hmap.put(key, val))) {
                        throw new IllegalStateException();
                    }
                    if (o1 != null) continue;
                    ++total;
                }
                if (!rmap.equals(hmap) || !hmap.equals(rmap)) {
                    throw new IllegalStateException();
                }
                for (int j = 0; j < gets; ++j) {
                    Object v2;
                    Integer key = new Integer(r.nextInt(ceil * 5));
                    Object v1 = hmap.get(key);
                    if (RadkeHashMap.equals(v1, v2 = rmap.get(key))) continue;
                    throw new IllegalStateException();
                }
                while (rmap.size() > floor) {
                    Object o2;
                    Integer key = new Integer(r.nextInt(ceil * 5));
                    Object o1 = rmap.remove(key);
                    if (RadkeHashMap.equals(o1, o2 = hmap.remove(key))) continue;
                    throw new IllegalStateException();
                }
                if (rmap.equals(hmap) && hmap.equals(rmap)) continue;
                throw new IllegalStateException();
            }
        }
    }

    private class Values
    implements Collection {
        private Values() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            RadkeHashMap.this.clear();
        }

        public int size() {
            return RadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return RadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return RadkeHashMap.this.containsValue(o);
        }

        public boolean containsAll(Collection c) {
            return RadkeHashMap.this.valuesContainsAll(c);
        }

        public boolean remove(Object o) {
            return RadkeHashMap.this.valuesRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return RadkeHashMap.this.valuesRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return RadkeHashMap.this.valuesRetainAll(c);
        }

        public Object[] toArray() {
            return RadkeHashMap.this.valuesToArray();
        }

        public Object[] toArray(Object[] a) {
            return RadkeHashMap.this.valuesToArray(a);
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }

    private class KeySet
    implements Set {
        private KeySet() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            RadkeHashMap.this.clear();
        }

        public int size() {
            return RadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return RadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return RadkeHashMap.this.containsKey(o);
        }

        public boolean containsAll(Collection c) {
            return RadkeHashMap.this.keySetContainsAll(c);
        }

        public boolean remove(Object o) {
            return RadkeHashMap.this.keySetRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return RadkeHashMap.this.keySetRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return RadkeHashMap.this.keySetRetainAll(c);
        }

        public Object[] toArray() {
            return RadkeHashMap.this.keySetToArray();
        }

        public Object[] toArray(Object[] a) {
            return RadkeHashMap.this.keySetToArray(a);
        }

        public Iterator iterator() {
            return new KeyIterator();
        }
    }

    private static class SimpleEntry
    implements Map.Entry {
        final Object key;
        final Object value;

        SimpleEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Immutable object");
        }

        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)other;
            if (!RadkeHashMap.eqNonNull(this.getKey(), that.getKey())) {
                return false;
            }
            return RadkeHashMap.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            Object key = this.getKey();
            Object val = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (val == null ? 0 : val.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    implements Set {
        private EntrySet() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            RadkeHashMap.this.clear();
        }

        public int size() {
            return RadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return RadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return RadkeHashMap.this.entrySetContainsEntry(o);
        }

        public boolean containsAll(Collection c) {
            return RadkeHashMap.this.entrySetContainsAll(c);
        }

        public boolean remove(Object o) {
            return RadkeHashMap.this.entrySetRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return RadkeHashMap.this.entrySetRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return RadkeHashMap.this.entrySetRetainAll(c);
        }

        public Object[] toArray() {
            return RadkeHashMap.this.entrySetToArray();
        }

        public Object[] toArray(Object[] a) {
            return RadkeHashMap.this.entrySetToArray(a);
        }

        public Iterator iterator() {
            return new EntryIterator();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            this.goNext();
            return RadkeHashMap.this.values[this.curr];
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            this.goNext();
            return new Entry(this.curr);
        }
    }

    private class Entry
    implements Map.Entry {
        final int p;

        Entry(int p) {
            this.p = p;
        }

        public Object getKey() {
            Object key = RadkeHashMap.this.keys[this.p];
            if (key == REMOVED || key == NULL) {
                key = null;
            }
            return key;
        }

        public Object getValue() {
            return RadkeHashMap.this.values[this.p];
        }

        public Object setValue(Object value) {
            Object key = RadkeHashMap.this.keys[this.p];
            if (key == REMOVED || key == null) {
                throw new IllegalArgumentException("Mapping has been removed");
            }
            Object old = RadkeHashMap.this.values[this.p];
            RadkeHashMap.this.values[this.p] = value;
            return old;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)other;
            if (!RadkeHashMap.eqNonNull(this.getKey(), that.getKey())) {
                return false;
            }
            return RadkeHashMap.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            Object key = this.getKey();
            Object val = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (val == null ? 0 : val.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            this.goNext();
            return RadkeHashMap.this.keys[this.curr];
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int curr = 0;
        int next = 0;

        HashIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next < RadkeHashMap.this.keys.length;
        }

        protected void goNext() {
            if (this.next >= RadkeHashMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.findNext();
        }

        private void findNext() {
            while (this.next < RadkeHashMap.this.keys.length && (RadkeHashMap.this.keys[this.next] == null || RadkeHashMap.this.keys[this.next] == REMOVED)) {
                ++this.next;
            }
        }

        public void remove() {
            if (RadkeHashMap.this.keys[this.curr] != REMOVED) {
                RadkeHashMap.this.keys[this.curr] = REMOVED;
                RadkeHashMap.this.values[this.curr] = null;
                --RadkeHashMap.this.size;
            }
        }
    }
}

