/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections;

import edu.emory.mathcs.util.collections.RadkeHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class RadkeHashSet
implements Set,
Cloneable,
Serializable {
    transient Object[] elements;
    transient int size;
    transient int fill;
    int treshold;
    final float loadFactor;
    final float resizeTreshold;
    private static final Object NULL = new Object();
    private static final Object REMOVED = new Object();

    public RadkeHashSet() {
        this(19);
    }

    public RadkeHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public RadkeHashSet(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 0.3f);
    }

    public RadkeHashSet(int initialCapacity, float loadFactor, float resizeTreshold) {
        initialCapacity = RadkeHashMap.radkeAtLeast(initialCapacity);
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be betweeen 0 and 1");
        }
        if (resizeTreshold <= 0.0f || resizeTreshold > 1.0f) {
            throw new IllegalArgumentException("Fill treshold must be betweeen 0 and 1");
        }
        this.elements = new Object[initialCapacity];
        this.size = 0;
        this.fill = 0;
        this.loadFactor = loadFactor;
        this.resizeTreshold = resizeTreshold;
        this.treshold = (int)(loadFactor * (float)initialCapacity);
    }

    public RadkeHashSet(Set m) {
        this(Math.max((int)((double)m.size() / 0.75) + 1, 19), 0.75f);
        this.addAll((Collection)m);
    }

    public boolean add(Object elem) {
        if (elem == null) {
            elem = NULL;
        }
        int hsize = this.elements.length;
        int start = (elem.hashCode() & Integer.MAX_VALUE) % hsize;
        int refill = -1;
        Object prev = this.elements[start];
        if (prev == null) {
            this.elements[start] = elem;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return true;
        }
        if (prev == REMOVED) {
            refill = start;
        } else if (RadkeHashSet.eqNonNull(prev, elem)) {
            return false;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            if (refill >= 0) {
                this.elements[refill] = elem;
                ++this.size;
                return true;
            }
            this.elements[p] = elem;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return true;
        }
        if (prev == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (RadkeHashSet.eqNonNull(prev, elem)) {
            return false;
        }
        if ((p = start - 1) < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            if (refill >= 0) {
                this.elements[refill] = elem;
                ++this.size;
                return true;
            }
            this.elements[p] = elem;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return true;
        }
        if (prev == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (RadkeHashSet.eqNonNull(prev, elem)) {
            return false;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                if (refill >= 0) {
                    this.elements[refill] = elem;
                    ++this.size;
                    return true;
                }
                this.elements[pu] = elem;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return true;
            }
            if (prev == REMOVED) {
                if (refill < 0) {
                    refill = pu;
                }
            } else if (RadkeHashSet.eqNonNull(prev, elem)) {
                return false;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                if (refill >= 0) {
                    this.elements[refill] = elem;
                    ++this.size;
                    return true;
                }
                this.elements[pd] = elem;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return true;
            }
            if (prev == REMOVED) {
                if (refill < 0) {
                    refill = pd;
                }
            } else if (RadkeHashSet.eqNonNull(prev, elem)) {
                return false;
            }
            pu += j;
            pd -= j;
        }
        throw new RuntimeException("set is full");
    }

    public boolean contains(Object elem) {
        if (elem == null) {
            elem = NULL;
        }
        int hsize = this.elements.length;
        int start = (elem.hashCode() & Integer.MAX_VALUE) % hsize;
        Object prev = this.elements[start];
        if (prev == null) {
            return false;
        }
        if (RadkeHashSet.eqNonNull(prev, elem)) {
            return true;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return false;
        }
        if (RadkeHashSet.eqNonNull(prev, elem)) {
            return true;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return false;
        }
        if (RadkeHashSet.eqNonNull(prev, elem)) {
            return true;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                return false;
            }
            if (RadkeHashSet.eqNonNull(prev, elem)) {
                return true;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                return false;
            }
            if (RadkeHashSet.eqNonNull(prev, elem)) {
                return true;
            }
            pu += j;
            pd -= j;
        }
        return false;
    }

    public boolean remove(Object elem) {
        int p = this.find(elem);
        if (p < 0) {
            return false;
        }
        this.elements[p] = REMOVED;
        --this.size;
        return true;
    }

    private int find(Object elem) {
        if (elem == null) {
            elem = NULL;
        }
        int hsize = this.elements.length;
        int start = (elem.hashCode() & Integer.MAX_VALUE) % hsize;
        Object prev = this.elements[start];
        if (prev == null) {
            return -1;
        }
        if (RadkeHashSet.eqNonNull(prev, elem)) {
            return start;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return -1;
        }
        if (RadkeHashSet.eqNonNull(prev, elem)) {
            return p;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((prev = this.elements[p]) == null) {
            return -1;
        }
        if (RadkeHashSet.eqNonNull(prev, elem)) {
            return p;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((prev = this.elements[pu]) == null) {
                return -1;
            }
            if (RadkeHashSet.eqNonNull(prev, elem)) {
                return pu;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((prev = this.elements[pd]) == null) {
                return -1;
            }
            if (RadkeHashSet.eqNonNull(prev, elem)) {
                return pd;
            }
            pu += j;
            pd -= j;
        }
        return -1;
    }

    private void rehash() {
        if ((float)this.size >= (float)this.fill * this.resizeTreshold) {
            this.rehash(RadkeHashMap.radkeAtLeast(this.elements.length + 1));
        } else {
            this.rehash(this.elements.length);
        }
    }

    private void rehash(int newcapacity) {
        Object[] oldelements = this.elements;
        this.elements = new Object[newcapacity];
        this.size = 0;
        this.fill = 0;
        this.treshold = (int)(this.loadFactor * (float)newcapacity);
        for (int i = 0; i < oldelements.length; ++i) {
            if (oldelements[i] == null || oldelements[i] == REMOVED) continue;
            this.add(oldelements[i]);
        }
    }

    public void clear() {
        Arrays.fill(this.elements, null);
        this.size = 0;
        this.fill = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean addAll(Collection c) {
        boolean modified = false;
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    public Iterator iterator() {
        return new HashIterator();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Object elem = this.elements[i];
            if (elem == null || elem == REMOVED) continue;
            if (elem == NULL) {
                elem = null;
            }
            if (that.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            Object elem = this.elements[i];
            if (elem == null || elem == REMOVED) continue;
            if (elem == NULL) {
                elem = null;
            }
            hash += elem == null ? 0 : elem.hashCode();
        }
        return hash;
    }

    public Object clone() {
        RadkeHashSet result;
        try {
            result = (RadkeHashSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.elements = new Object[this.elements.length];
        result.fill = 0;
        result.size = 0;
        result.addAll((Collection)this);
        return result;
    }

    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        if (this.elements.length * 2 < c.size()) {
            for (int i = 0; i < this.elements.length; ++i) {
                Object key = this.elements[i];
                if (key == null || key == REMOVED) continue;
                if (key == NULL) {
                    key = null;
                }
                if (!c.contains(key)) continue;
                this.elements[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.remove(itr.next());
            }
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        boolean modified = false;
        if (this.elements.length * 4 < c.size()) {
            for (int i = 0; i < this.elements.length; ++i) {
                Object key = this.elements[i];
                if (key == null || key == REMOVED) continue;
                if (key == NULL) {
                    key = null;
                }
                if (c.contains(key)) continue;
                this.elements[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            RadkeHashSet tmp = new RadkeHashSet(this.elements.length, this.loadFactor, this.resizeTreshold);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                Object elem = itr.next();
                int p = this.find(elem);
                if (p < 0) continue;
                tmp.add(elem);
                modified = true;
            }
            if (modified) {
                this.elements = tmp.elements;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.elements.length; ++j) {
            Object key = this.elements[j];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            a[i++] = key;
        }
        return a;
    }

    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.elements.length; ++j) {
            Object key = this.elements[j];
            if (key == null || key == REMOVED) continue;
            if (key == NULL) {
                key = null;
            }
            a[i++] = key;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.elements.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.elements.length; ++i) {
            Object elem = this.elements[i];
            if (elem == null || elem == REMOVED) continue;
            if (elem == NULL) {
                elem = null;
            }
            out.writeObject(elem);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.elements = new Object[capacity];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object elem = in.readObject();
            this.add(elem);
        }
    }

    private static final boolean eqNonNull(Object o1, Object o2) {
        return o1 == o2 || o1.equals(o2);
    }

    private class HashIterator
    implements Iterator {
        int curr = 0;
        int next = 0;

        HashIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next < RadkeHashSet.this.elements.length;
        }

        public Object next() {
            if (this.next >= RadkeHashSet.this.elements.length) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.findNext();
            return RadkeHashSet.this.elements[this.curr];
        }

        private void findNext() {
            while (this.next < RadkeHashSet.this.elements.length && (RadkeHashSet.this.elements[this.next] == null || RadkeHashSet.this.elements[this.next] == REMOVED)) {
                ++this.next;
            }
        }

        public void remove() {
            if (RadkeHashSet.this.elements[this.curr] != REMOVED) {
                RadkeHashSet.this.elements[this.curr] = REMOVED;
                --RadkeHashSet.this.size;
            }
        }
    }
}

