/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.AbstractIntSortedSet;
import edu.emory.mathcs.util.collections.ints.IntCollections;
import edu.emory.mathcs.util.collections.ints.IntInterval;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntSet;
import edu.emory.mathcs.util.collections.ints.IntSortedSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIntInterval
extends AbstractIntSortedSet
implements IntInterval {
    protected abstract int getFirst();

    protected abstract int getLast();

    public int min() {
        return this.getFirst();
    }

    public int max() {
        return this.getLast();
    }

    public int first() {
        int last;
        int first = this.getFirst();
        if (first > (last = this.getLast())) {
            throw new NoSuchElementException();
        }
        return first;
    }

    public int last() {
        int last;
        int first = this.getFirst();
        if (first > (last = this.getLast())) {
            throw new NoSuchElementException();
        }
        return last;
    }

    public int intervalCount() {
        return this.isEmpty() ? 0 : 1;
    }

    public IntInterval firstInterval() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public IntInterval lastInterval() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public IntInterval lowerInterval(int n) {
        return n > this.getLast() ? this : null;
    }

    public IntInterval floorInterval(int n) {
        return n >= this.getFirst() ? this : null;
    }

    public IntInterval higherInterval(int n) {
        return n < this.getFirst() ? this : null;
    }

    public IntInterval ceilingInterval(int n) {
        return n <= this.getLast() ? this : null;
    }

    public int size64() {
        int last;
        int first = this.getFirst();
        if (first > (last = this.getLast())) {
            return 0;
        }
        return last - first + 1;
    }

    public boolean isEmpty() {
        return this.getFirst() > this.getLast();
    }

    public boolean contains(int e) {
        return e >= this.getFirst() && e <= this.getLast();
    }

    public int higher(int e) {
        int first = this.getFirst();
        int last = this.getLast();
        if (e >= last || first > last) {
            throw new NoSuchElementException();
        }
        if (e < first) {
            return first;
        }
        return e + 1;
    }

    public int ceiling(int e) {
        int first = this.getFirst();
        int last = this.getLast();
        if (e > last || first > last) {
            throw new NoSuchElementException();
        }
        if (e < first) {
            return first;
        }
        return e;
    }

    public int lower(int e) {
        int first = this.getFirst();
        int last = this.getLast();
        if (e <= first || first > last) {
            throw new NoSuchElementException();
        }
        if (e > last) {
            return last;
        }
        return e - 1;
    }

    public int floor(int e) {
        int first = this.getFirst();
        int last = this.getLast();
        if (e < first || first > last) {
            throw new NoSuchElementException();
        }
        if (e > last) {
            return last;
        }
        return e;
    }

    public boolean containsInterval(int first, int last) {
        return first >= this.getFirst() && last <= this.getLast();
    }

    public IntInterval enclosingInterval(int e) {
        if (!this.contains(e)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    public IntIterator iterator() {
        return new SimpleIntervalItemIterator(this.getFirst(), this.getLast());
    }

    public IntIterator descendingIterator() {
        return new SimpleReverseIntervalItemIterator(this.getFirst(), this.getLast());
    }

    public Iterator intervalIterator() {
        return new IntervalIterator();
    }

    public Iterator descendingIntervalIterator() {
        return new IntervalIterator();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addInterval(int first, int last) {
        throw new UnsupportedOperationException();
    }

    public boolean removeInterval(int first, int last) {
        throw new UnsupportedOperationException();
    }

    public boolean retainInterval(int first, int last) {
        throw new UnsupportedOperationException();
    }

    public int pollFirst() {
        throw new UnsupportedOperationException();
    }

    public int pollLast() {
        throw new UnsupportedOperationException();
    }

    public IntInterval pollFirstInterval() {
        throw new UnsupportedOperationException();
    }

    public IntInterval pollLastInterval() {
        throw new UnsupportedOperationException();
    }

    public IntSortedSet subSet(int first, int last) {
        return new ConstrainedView(this, first, last);
    }

    public IntSet complementSet() {
        return new ComplementView(this, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public String toString() {
        int last;
        int first = this.getFirst();
        if (first > (last = this.getLast())) {
            return "_";
        }
        if (first == last) {
            return String.valueOf(first);
        }
        return "" + first + ".." + last;
    }

    private static class ComplementIterator
    implements Iterator {
        final IntInterval[] intervals = new IntInterval[2];
        final boolean forward;
        int idx;

        ComplementIterator(ComplementView c, boolean forward) {
            this.forward = forward;
            int first = c.base.getFirst();
            int last = c.base.getLast();
            int min = c.min();
            int max = c.max();
            if (min < first) {
                this.intervals[0] = IntCollections.interval(min, first - 1);
            }
            if (max > last) {
                this.intervals[1] = IntCollections.interval(last + 1, max);
            }
            this.idx = forward ? 0 : 1;
        }

        public boolean hasNext() {
            for (int nextIdx = this.idx; nextIdx >= 0 || nextIdx <= 2; nextIdx += this.forward ? 1 : -1) {
                if (this.intervals[nextIdx] == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.idx >= 0 && this.idx <= 1) {
                IntInterval r = this.intervals[this.idx];
                this.idx += this.forward ? 1 : -1;
                if (r == null) continue;
                return r;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ComplementView
    extends AbstractIntSortedSet {
        final AbstractIntInterval base;
        final int beg;
        final int end;

        ComplementView(AbstractIntInterval base, int beg, int end) {
            if (beg > end) {
                throw new IllegalArgumentException();
            }
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public int min() {
            int min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public int max() {
            int max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public int first() {
            int min = this.min();
            if (min < this.base.getFirst()) {
                return min;
            }
            int max = this.max();
            int last = this.base.getLast();
            if (last < max) {
                return last + 1;
            }
            throw new NoSuchElementException();
        }

        public int last() {
            int max = this.max();
            if (max > this.base.getLast()) {
                return max;
            }
            int min = this.min();
            int first = this.base.getFirst();
            if (first > min) {
                return first - 1;
            }
            throw new NoSuchElementException();
        }

        public boolean contains(int e) {
            return e >= this.min() && e <= this.max() && !this.base.contains(e);
        }

        public boolean containsInterval(int first, int last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.min() || last > this.max()) {
                return false;
            }
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            return last < bfirst || blast < first;
        }

        public IntInterval enclosingInterval(int e) {
            if (!this.contains(e)) {
                return null;
            }
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            if (e < bfirst) {
                return IntCollections.interval(this.min(), bfirst - 1);
            }
            if (e > blast) {
                return IntCollections.interval(blast + 1, this.max());
            }
            return null;
        }

        public IntInterval higherInterval(int n) {
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            int min = this.min();
            int max = this.max();
            if (bfirst > Integer.MIN_VALUE && n < min && min < bfirst - 1) {
                return IntCollections.interval(min, bfirst - 1);
            }
            if (blast < Integer.MAX_VALUE && n <= blast && blast + 1 < max) {
                return IntCollections.interval(blast + 1, max);
            }
            return null;
        }

        public IntInterval ceilingInterval(int n) {
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            int min = this.min();
            int max = this.max();
            if (bfirst > Integer.MIN_VALUE && n < bfirst && bfirst - 1 > min) {
                return IntCollections.interval(min, bfirst - 1);
            }
            if (blast < Integer.MAX_VALUE && n <= max && this.end > blast + 1) {
                return IntCollections.interval(blast + 1, max);
            }
            return null;
        }

        public IntInterval lowerInterval(int n) {
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            int min = this.min();
            int max = this.max();
            if (blast < Integer.MAX_VALUE && n > max && max > blast + 1) {
                return IntCollections.interval(blast + 1, max);
            }
            if (bfirst > Integer.MIN_VALUE && n >= bfirst && bfirst - 1 > min) {
                return IntCollections.interval(min, bfirst - 1);
            }
            return null;
        }

        public IntInterval floorInterval(int n) {
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            int min = this.min();
            int max = this.max();
            if (blast < Integer.MAX_VALUE && n > blast && blast + 1 < max) {
                return IntCollections.interval(blast + 1, max);
            }
            if (bfirst > Integer.MIN_VALUE && n >= min && min < bfirst - 1) {
                return IntCollections.interval(min, bfirst - 1);
            }
            return null;
        }

        public IntInterval firstInterval() {
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            int min = this.min();
            int max = this.max();
            if (bfirst > Integer.MIN_VALUE && min < bfirst - 1) {
                return IntCollections.interval(min, bfirst - 1);
            }
            if (blast < Integer.MAX_VALUE && blast + 1 < max) {
                return IntCollections.interval(blast + 1, max);
            }
            return null;
        }

        public IntInterval lastInterval() {
            int bfirst = this.base.getFirst();
            int blast = this.base.getLast();
            int min = this.min();
            int max = this.max();
            if (blast < Integer.MAX_VALUE && blast + 1 < max) {
                return IntCollections.interval(blast + 1, max);
            }
            if (bfirst > Integer.MIN_VALUE && min < bfirst - 1) {
                return IntCollections.interval(min, bfirst - 1);
            }
            return null;
        }

        public IntInterval pollFirstInterval() {
            throw new UnsupportedOperationException();
        }

        public IntInterval pollLastInterval() {
            throw new UnsupportedOperationException();
        }

        public int intervalCount() {
            int count = 0;
            if (this.min() < this.base.getFirst()) {
                ++count;
            }
            if (this.max() > this.base.getLast()) {
                ++count;
            }
            return count;
        }

        public IntSortedSet subSet(int first, int last) {
            if (first <= this.beg && last >= this.end) {
                return this;
            }
            int beg = first > this.beg ? first : this.beg;
            int end = last < this.end ? last : this.end;
            return new ComplementView(this.base, beg, end);
        }

        public IntSet complementSet() {
            if (this.beg == Integer.MIN_VALUE && this.end == Integer.MAX_VALUE) {
                return this.base;
            }
            return new ConstrainedView(this.base, this.beg, this.end);
        }

        public Iterator intervalIterator() {
            return new ComplementIterator(this, true);
        }

        public Iterator descendingIntervalIterator() {
            return new ComplementIterator(this, false);
        }
    }

    protected static class ConstrainedView
    extends AbstractIntInterval {
        final AbstractIntInterval base;
        final int beg;
        final int end;

        ConstrainedView(AbstractIntInterval base, int beg, int end) {
            if (beg > end) {
                throw new IllegalArgumentException();
            }
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        protected int getFirst() {
            int first = this.base.getFirst();
            return first > this.beg ? first : this.beg;
        }

        protected int getLast() {
            int last = this.base.getLast();
            return last < this.end ? last : this.end;
        }

        public int min() {
            int min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public int max() {
            int max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public IntSortedSet subSet(int first, int last) {
            if (first <= this.beg && last >= this.end) {
                return this;
            }
            int beg = first > this.beg ? first : this.beg;
            int end = last < this.end ? last : this.end;
            return new ConstrainedView(this.base, beg, end);
        }

        public IntSet complementSet() {
            return new ComplementView(this.base, this.beg, this.end);
        }
    }

    public static class SimpleReverseIntervalItemIterator
    implements IntIterator {
        final int first;
        final int last;
        int curr;
        boolean eof;

        SimpleReverseIntervalItemIterator(int first, int last) {
            this.first = first;
            this.last = last;
            this.curr = last;
            if (first > last) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            this.eof = false;
            return false;
        }

        public int next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.curr == this.first) {
                this.eof = true;
                return this.curr;
            }
            return this.curr--;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SimpleIntervalItemIterator
    implements IntIterator {
        final int first;
        final int last;
        int curr;
        boolean eof;

        SimpleIntervalItemIterator(int first, int last) {
            this.first = first;
            this.last = last;
            this.curr = first;
            if (first > last) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            this.eof = false;
            return false;
        }

        public int next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            if (this.curr == this.last) {
                this.eof = true;
                return this.curr;
            }
            return this.curr++;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class IntervalIterator
    implements Iterator {
        boolean eof;

        IntervalIterator() {
            if (AbstractIntInterval.this.getFirst() > AbstractIntInterval.this.getLast()) {
                this.eof = true;
            }
        }

        public boolean hasNext() {
            return !this.eof;
        }

        public Object next() {
            if (this.eof) {
                throw new NoSuchElementException();
            }
            this.eof = true;
            return AbstractIntInterval.this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

