/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.AbstractIntSet;
import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntCollections;
import edu.emory.mathcs.util.collections.ints.IntInterval;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntSortedSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIntSortedSet
extends AbstractIntSet
implements IntSortedSet {
    public boolean isEmpty() {
        return !this.intervalIterator().hasNext();
    }

    public int size64() {
        int size = 0;
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            size += ((IntInterval)itr.next()).size();
        }
        return size;
    }

    public int intervalCount() {
        int count = 0;
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            ++count;
        }
        return count;
    }

    public int first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.firstInterval().first();
    }

    public int last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.lastInterval().last();
    }

    public int pollFirst() {
        int first = this.first();
        this.remove(first);
        return first;
    }

    public int pollLast() {
        int last = this.last();
        this.remove(last);
        return last;
    }

    public IntInterval firstInterval() {
        Iterator itr = this.intervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (IntInterval)itr.next();
    }

    public IntInterval lastInterval() {
        Iterator itr = this.descendingIntervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (IntInterval)itr.next();
    }

    public IntInterval pollFirstInterval() {
        Iterator itr = this.intervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        IntInterval r = (IntInterval)itr.next();
        itr.remove();
        return r;
    }

    public IntInterval pollLastInterval() {
        Iterator itr = this.descendingIntervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        IntInterval r = (IntInterval)itr.next();
        itr.remove();
        return r;
    }

    public boolean retainAll(IntCollection c) {
        if (c instanceof IntSortedSet) {
            IntSortedSet s = (IntSortedSet)c;
            boolean modified = false;
            modified |= this.removeAll(s.complementSet());
            if (s.min() > this.min()) {
                modified |= this.removeInterval(this.min(), s.min() - 1);
            }
            if (s.max() < this.max()) {
                modified |= this.removeInterval(s.max() + 1, this.max());
            }
            return modified;
        }
        return super.retainAll(c);
    }

    public boolean retainInterval(int first, int last) {
        boolean modified = false;
        int min = this.min();
        int max = this.max();
        if (first > min) {
            modified |= this.removeInterval(min, first - 1);
        }
        if (last < max) {
            modified |= this.removeInterval(last + 1, max);
        }
        return modified;
    }

    public int higher(int e) {
        if (e == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return this.tailSet(e + 1).first();
    }

    public int ceiling(int e) {
        return this.tailSet(e).first();
    }

    public int lower(int e) {
        if (e == Integer.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.headSet(e - 1).last();
    }

    public int floor(int e) {
        return this.headSet(e).last();
    }

    public IntSortedSet headSet(int last) {
        return this.subSet(Integer.MIN_VALUE, last);
    }

    public IntSortedSet tailSet(int first) {
        return this.subSet(first, Integer.MAX_VALUE);
    }

    public IntIterator iterator() {
        return new ForwardIntervalItemIterator(this.intervalIterator());
    }

    public IntIterator descendingIterator() {
        return new ReverseIntervalItemIterator(this.descendingIntervalIterator());
    }

    public String toCompactString() {
        Iterator itr = this.intervalIterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static abstract class AbstractComplementSubView
    extends AbstractIntSortedSet {
        protected final IntSortedSet base;
        protected final int beg;
        protected final int end;

        protected AbstractComplementSubView(IntSortedSet base, int beg, int end) {
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public int min() {
            int min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public int max() {
            int max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public int size64() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.end - this.beg + 1 - this.base.size64();
            }
            return super.size64();
        }

        public int intervalCount() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                int count = this.base.intervalCount();
                if (count == 0) {
                    return this.isEmpty() ? 0 : 1;
                }
                --count;
                if (this.base.first() > this.min()) {
                    ++count;
                }
                if (this.base.last() < this.max()) {
                    ++count;
                }
                return count;
            }
            return super.intervalCount();
        }

        public boolean add(int e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.remove(e);
        }

        public boolean addInterval(int first, int last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.removeInterval(first, last);
        }

        public boolean remove(int e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.add(e);
        }

        public boolean removeInterval(int first, int last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.addInterval(first, last);
        }

        public boolean contains(int e) {
            return e < this.beg || e > this.end ? false : !this.base.contains(e);
        }

        public boolean containsInterval(int first, int last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.beg || last > this.end) {
                return false;
            }
            return !this.base.containsInterval(first, last);
        }

        public IntInterval enclosingInterval(int e) {
            if (e < this.beg || e > this.end) {
                return null;
            }
            if (this.base.contains(e)) {
                return null;
            }
            IntInterval l = this.base.lowerInterval(e);
            IntInterval h = this.base.higherInterval(e);
            int first = l == null ? Integer.MIN_VALUE : l.last() + 1;
            int last = h == null ? Integer.MIN_VALUE : h.first() - 1;
            return this.trim(first, last);
        }

        public IntInterval lowerInterval(int n) {
            IntInterval e = this.base.enclosingInterval(n);
            IntInterval l = this.base.lowerInterval(n);
            if (e != null) {
                int efirst = e.first();
                if (efirst == Integer.MIN_VALUE) {
                    return null;
                }
                return this.trim(l == null ? Integer.MIN_VALUE : l.last() + 1, efirst - 1);
            }
            if (l == null) {
                return null;
            }
            int lfirst = l.first();
            if (lfirst == Integer.MIN_VALUE) {
                return null;
            }
            IntInterval ll = this.base.lowerInterval(lfirst - 1);
            return this.trim(ll == null ? Integer.MIN_VALUE : ll.last() + 1, lfirst - 1);
        }

        public IntInterval floorInterval(int n) {
            IntInterval e = this.base.enclosingInterval(n);
            IntInterval l = this.base.lowerInterval(n);
            if (e != null) {
                int efirst = e.first();
                if (efirst == Integer.MIN_VALUE) {
                    return null;
                }
                return this.trim(l == null ? Integer.MIN_VALUE : l.last() + 1, efirst - 1);
            }
            int first = l == null ? Integer.MIN_VALUE : l.last() + 1;
            IntInterval h = this.base.higherInterval(n);
            int last = h == null ? Integer.MAX_VALUE : h.first() - 1;
            return this.trim(first, last);
        }

        public IntInterval higherInterval(int n) {
            IntInterval e = this.base.enclosingInterval(n);
            IntInterval h = this.base.higherInterval(n);
            if (e != null) {
                int elast = e.last();
                if (elast == Integer.MAX_VALUE) {
                    return null;
                }
                return this.trim(elast + 1, h == null ? Integer.MAX_VALUE : h.first() - 1);
            }
            if (h == null) {
                return null;
            }
            int hlast = h.last();
            if (hlast == Integer.MAX_VALUE) {
                return null;
            }
            IntInterval hh = this.base.higherInterval(hlast + 1);
            return this.trim(hlast + 1, hh == null ? Integer.MAX_VALUE : hh.first() - 1);
        }

        public IntInterval ceilingInterval(int n) {
            IntInterval e = this.base.enclosingInterval(n);
            IntInterval h = this.base.higherInterval(n);
            if (e != null) {
                int elast = e.last();
                if (elast == Integer.MAX_VALUE) {
                    return null;
                }
                return this.trim(elast + 1, h == null ? Integer.MIN_VALUE : h.first() - 1);
            }
            int last = h == null ? Integer.MAX_VALUE : h.first() - 1;
            IntInterval l = this.base.lowerInterval(n);
            int first = l == null ? Integer.MIN_VALUE : l.last() + 1;
            return this.trim(first, last);
        }

        public void clear() {
            this.base.addInterval(this.beg, this.end);
        }

        private IntInterval trim(int first, int last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return first <= last ? IntCollections.interval(first, last) : null;
        }

        public abstract Iterator intervalIterator();

        public abstract Iterator descendingIntervalIterator();
    }

    protected static abstract class AbstractSubView
    extends AbstractIntSortedSet
    implements Serializable {
        protected final IntSortedSet base;
        protected final int beg;
        protected final int end;

        protected AbstractSubView(IntSortedSet base, int beg, int end) {
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public int min() {
            int min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public int max() {
            int max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public int size64() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.base.size64();
            }
            return super.size64();
        }

        public int intervalCount() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.base.intervalCount();
            }
            return super.intervalCount();
        }

        public void clear() {
            this.removeInterval(this.beg, this.end);
        }

        public boolean add(int e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.add(e);
        }

        public boolean addInterval(int first, int last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.addInterval(first, last);
        }

        public boolean remove(int e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.remove(e);
        }

        public boolean removeInterval(int first, int last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.removeInterval(first, last);
        }

        public boolean contains(int e) {
            return e < this.beg || e > this.end ? false : this.base.contains(e);
        }

        public boolean containsInterval(int first, int last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.beg || last > this.end) {
                return false;
            }
            return this.base.containsInterval(first, last);
        }

        public IntInterval enclosingInterval(int e) {
            if (e < this.beg || e > this.end) {
                return null;
            }
            return this.trim(this.base.enclosingInterval(e));
        }

        public IntInterval higherInterval(int e) {
            return this.trim(this.base.higherInterval(e));
        }

        public IntInterval ceilingInterval(int e) {
            return this.trim(this.base.ceilingInterval(e));
        }

        public IntInterval lowerInterval(int e) {
            return this.trim(this.base.lowerInterval(e));
        }

        public IntInterval floorInterval(int e) {
            return this.trim(this.base.floorInterval(e));
        }

        public abstract IntSortedSet subSet(int var1, int var2);

        public abstract Iterator intervalIterator();

        public abstract Iterator descendingIntervalIterator();

        private IntInterval trim(IntInterval r) {
            int first = r.first();
            int last = r.last();
            if (first >= this.beg && last <= this.end) {
                return r;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return first <= last ? IntCollections.interval(first, last) : null;
        }
    }

    protected static class ReverseIntervalItemIterator
    implements IntIterator {
        Iterator it;
        IntInterval currInterval;
        protected int cursor;
        protected int lastRet;
        protected boolean lastRetValid = false;

        ReverseIntervalItemIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.currInterval != null;
        }

        public int next() {
            if (this.currInterval == null) {
                this.currInterval = (IntInterval)this.it.next();
                this.cursor = this.currInterval.last();
            }
            this.lastRet = this.cursor;
            this.lastRetValid = true;
            if (this.cursor > this.currInterval.first()) {
                --this.cursor;
            } else if (this.it.hasNext()) {
                this.currInterval = (IntInterval)this.it.next();
                this.cursor = this.currInterval.last();
            } else {
                this.currInterval = null;
            }
            return this.lastRet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ForwardIntervalItemIterator
    implements IntIterator {
        Iterator it;
        IntInterval currInterval;
        protected int cursor;
        protected int lastRet;
        protected boolean lastRetValid = false;

        ForwardIntervalItemIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.currInterval != null;
        }

        public int next() {
            if (this.currInterval == null) {
                this.currInterval = (IntInterval)this.it.next();
                this.cursor = this.currInterval.first();
            }
            this.lastRet = this.cursor;
            this.lastRetValid = true;
            if (this.cursor < this.currInterval.last()) {
                ++this.cursor;
            } else if (this.it.hasNext()) {
                this.currInterval = (IntInterval)this.it.next();
                this.cursor = this.currInterval.first();
            } else {
                this.currInterval = null;
            }
            return this.lastRet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

