/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.ints.AbstractIntCollection;
import edu.emory.mathcs.util.collections.ints.AbstractIntInterval;
import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntInterval;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntList;
import edu.emory.mathcs.util.collections.ints.IntListIterator;
import java.util.NoSuchElementException;

public class IntCollections {
    public static final IntInterval EMPTY_INTERVAL = new AbstractIntInterval(){

        public boolean isEmpty() {
            return true;
        }

        public int getFirst() {
            return 0;
        }

        public int getLast() {
            return -1;
        }

        public int min() {
            return 0;
        }

        public int max() {
            return -1;
        }
    };
    public static final IntList EMPTY_LIST = new IntArrAsList(new int[0]);

    private IntCollections() {
    }

    public static IntInterval interval(int first, int last) {
        return first > last ? EMPTY_INTERVAL : new SimpleInterval(first, last);
    }

    public static IntList asList(int[] arr) {
        return new IntArrAsList(arr);
    }

    private static class IntArrAsList
    extends AbstractIntCollection
    implements IntList {
        final int[] arr;

        IntArrAsList(int[] arr) {
            this.arr = arr;
        }

        public int size() {
            return this.arr.length;
        }

        public boolean isEmpty() {
            return this.arr.length == 0;
        }

        public boolean contains(int e) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] != e) continue;
                return true;
            }
            return false;
        }

        public IntIterator iterator() {
            return this.listIterator();
        }

        public int[] toArray() {
            int[] a = new int[this.arr.length];
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }

        public int[] toArray(int[] a) {
            if (a.length < this.arr.length) {
                a = new int[this.arr.length];
            }
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }

        public boolean add(int e) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int idx, IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(int e) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntList)) {
                return false;
            }
            IntList that = (IntList)o;
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == that.getAt(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 1;
            for (int i = 0; i < this.arr.length; ++i) {
                hashCode = 31 * hashCode + this.arr[i];
            }
            return hashCode;
        }

        public int getAt(int index) {
            return this.arr[index];
        }

        public int setAt(int index, int e) {
            int old = this.arr[index];
            this.arr[index] = e;
            return old;
        }

        public void addAt(int index, int e) {
            throw new UnsupportedOperationException();
        }

        public int removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(int e) {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] != e) continue;
                return i;
            }
            return -1;
        }

        public int lastIndexOf(int e) {
            for (int i = this.arr.length - 1; i >= 0; --i) {
                if (this.arr[i] != e) continue;
                return i;
            }
            return -1;
        }

        public IntListIterator listIterator() {
            return new ArrAsListItr(0);
        }

        public IntListIterator listIterator(int index) {
            return new ArrAsListItr(index);
        }

        public IntList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public int size64() {
            return this.arr.length;
        }

        private class ArrAsListItr
        implements IntListIterator {
            int cursor;

            ArrAsListItr(int cursor) {
                this.cursor = cursor;
            }

            public boolean hasNext() {
                return this.cursor < IntArrAsList.this.arr.length;
            }

            public int next() {
                if (this.cursor == IntArrAsList.this.arr.length) {
                    throw new NoSuchElementException();
                }
                return IntArrAsList.this.arr[this.cursor++];
            }

            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public int previous() {
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                return IntArrAsList.this.arr[--this.cursor];
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(int e) {
                IntArrAsList.this.arr[this.cursor] = e;
            }

            public void add(int e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class SimpleInterval
    extends AbstractIntInterval {
        final int first;
        final int last;

        public SimpleInterval(int first, int last) {
            if (first > last) {
                throw new IllegalArgumentException();
            }
            this.first = first;
            this.last = last;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }

        public int first() {
            return this.first;
        }

        public int last() {
            return this.last;
        }

        public int min() {
            return this.first;
        }

        public int max() {
            return this.last;
        }
    }
}

