/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.ints;

import edu.emory.mathcs.util.collections.RadkeHashMap;
import edu.emory.mathcs.util.collections.ints.AbstractIntSet;
import edu.emory.mathcs.util.collections.ints.IntCollection;
import edu.emory.mathcs.util.collections.ints.IntIterator;
import edu.emory.mathcs.util.collections.ints.IntMap;
import edu.emory.mathcs.util.collections.ints.IntSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntRadkeHashMap
implements IntMap,
Cloneable,
Serializable {
    transient int[] keys;
    transient Object[] values;
    transient int size;
    transient int fill;
    int treshold;
    final int minKey;
    final int maxKey;
    final float loadFactor;
    final float resizeTreshold;
    transient KeySet keySet;
    transient EntrySet entrySet;
    transient Values valueCollection;
    private static final Object NULL = new Object();
    private static final Object REMOVED = new Object();

    public IntRadkeHashMap() {
        this(19);
    }

    public IntRadkeHashMap(int minInitialCapacity) {
        this(minInitialCapacity, 0.75f, 0.3f);
    }

    public IntRadkeHashMap(int minInitialCapacity, int minKey, int maxKey) {
        this(minInitialCapacity, minKey, maxKey, 0.75f, 0.3f);
    }

    public IntRadkeHashMap(int minInitialCapacity, float loadFactor, float resizeTreshold) {
        this(minInitialCapacity, Integer.MIN_VALUE, Integer.MAX_VALUE, loadFactor, resizeTreshold);
    }

    public IntRadkeHashMap(int minInitialCapacity, int minKey, int maxKey, float loadFactor, float resizeTreshold) {
        int initialCapacity = RadkeHashMap.radkeAtLeast(minInitialCapacity);
        if (minKey > maxKey) {
            throw new IllegalArgumentException();
        }
        this.minKey = minKey;
        this.maxKey = maxKey;
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be betweeen 0 and 1");
        }
        if (resizeTreshold <= 0.0f || resizeTreshold > 1.0f) {
            throw new IllegalArgumentException("Fill treshold must be betweeen 0 and 1");
        }
        this.keys = new int[initialCapacity];
        this.values = new Object[initialCapacity];
        this.size = 0;
        this.fill = 0;
        this.loadFactor = loadFactor;
        this.resizeTreshold = resizeTreshold;
        this.treshold = (int)(loadFactor * (float)initialCapacity);
    }

    public IntRadkeHashMap(IntMap m) {
        this(Math.max((int)((double)m.size() / 0.75) + 1, 19), m.keySet().min(), m.keySet().max());
        this.putAll(m);
    }

    public Object put(int key, Object value) {
        if (key < this.minKey || key > this.maxKey) {
            return null;
        }
        int hsize = this.keys.length;
        int start = IntRadkeHashMap.phash(key) % hsize;
        int refill = -1;
        value = IntRadkeHashMap.maskNull(value);
        Object oldval = this.values[start];
        if (oldval == null) {
            this.keys[start] = key;
            this.values[start] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (oldval == REMOVED) {
            refill = start;
        } else if (this.keys[start] == key) {
            this.values[start] = value;
            return oldval;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((oldval = this.values[p]) == null) {
            if (refill >= 0) {
                this.keys[refill] = key;
                this.values[refill] = value;
                ++this.size;
                return null;
            }
            this.keys[p] = key;
            this.values[p] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (oldval == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (this.keys[p] == key) {
            this.values[p] = value;
            return oldval;
        }
        if ((p = start - 1) < 0) {
            p += hsize;
        }
        if ((oldval = this.values[p]) == null) {
            if (refill >= 0) {
                this.keys[refill] = key;
                this.values[refill] = value;
                ++this.size;
                return null;
            }
            this.keys[p] = key;
            this.values[p] = value;
            ++this.size;
            ++this.fill;
            if (this.fill >= this.treshold) {
                this.rehash();
            }
            return null;
        }
        if (oldval == REMOVED) {
            if (refill < 0) {
                refill = p;
            }
        } else if (this.keys[p] == key) {
            this.values[p] = value;
            return oldval;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((oldval = this.values[pu]) == null) {
                if (refill >= 0) {
                    this.keys[refill] = key;
                    this.values[refill] = value;
                    ++this.size;
                    return null;
                }
                this.keys[pu] = key;
                this.values[pu] = value;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (oldval == REMOVED) {
                if (refill < 0) {
                    refill = pu;
                }
            } else if (this.keys[pu] == key) {
                this.values[pu] = value;
                return oldval;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((oldval = this.values[pd]) == null) {
                if (refill >= 0) {
                    this.keys[refill] = key;
                    this.values[refill] = value;
                    ++this.size;
                    return null;
                }
                this.keys[pd] = key;
                this.values[pd] = value;
                ++this.size;
                ++this.fill;
                if (this.fill >= this.treshold) {
                    this.rehash();
                }
                return null;
            }
            if (oldval == REMOVED) {
                if (refill < 0) {
                    refill = pd;
                }
            } else if (this.keys[pd] == key) {
                this.values[pd] = value;
                return oldval;
            }
            pu += j;
            pd -= j;
        }
        throw new RuntimeException("hash map is full");
    }

    public Object get(int key) {
        if (key < this.minKey || key > this.maxKey) {
            return null;
        }
        int hsize = this.keys.length;
        int start = IntRadkeHashMap.phash(key) % hsize;
        Object oldval = this.values[start];
        if (oldval == null) {
            return null;
        }
        if (oldval != REMOVED && this.keys[start] == key) {
            return IntRadkeHashMap.unmaskNull(oldval);
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return null;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return IntRadkeHashMap.unmaskNull(oldval);
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return null;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return IntRadkeHashMap.unmaskNull(oldval);
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((oldval = this.values[pu]) == null) {
                return null;
            }
            if (oldval != REMOVED && this.keys[pu] == key) {
                return IntRadkeHashMap.unmaskNull(oldval);
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((oldval = this.values[pd]) == null) {
                return null;
            }
            if (oldval != REMOVED && this.keys[pd] == key) {
                return IntRadkeHashMap.unmaskNull(oldval);
            }
            pu += j;
            pd -= j;
        }
        return null;
    }

    public boolean containsKey(int key) {
        return this.find(key) >= 0;
    }

    private boolean containsMapping(int key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        return IntRadkeHashMap.equals(value, this.values[p]);
    }

    public Object remove(int key) {
        int p = this.find(key);
        if (p < 0) {
            return null;
        }
        Object removed = this.values[p];
        this.values[p] = REMOVED;
        --this.size;
        return IntRadkeHashMap.unmaskNull(removed);
    }

    private boolean removeMapping(int key, Object value) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object val = IntRadkeHashMap.unmaskNull(this.values[p]);
        if (!IntRadkeHashMap.equals(value, val)) {
            return false;
        }
        this.values[p] = REMOVED;
        --this.size;
        return true;
    }

    private int find(int key) {
        if (key < this.minKey || key > this.maxKey) {
            return -1;
        }
        int hsize = this.keys.length;
        int start = IntRadkeHashMap.phash(key) % hsize;
        Object oldval = this.values[start];
        if (oldval == null) {
            return -1;
        }
        if (oldval != REMOVED && this.keys[start] == key) {
            return start;
        }
        int p = start + 1;
        if (p >= hsize) {
            p -= hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return -1;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return p;
        }
        p = start - 1;
        if (p < 0) {
            p += hsize;
        }
        if ((oldval = this.values[p]) == null) {
            return -1;
        }
        if (oldval != REMOVED && this.keys[p] == key) {
            return p;
        }
        int pu = start + 4;
        int pd = start - 4;
        for (int j = 5; j < hsize; j += 2) {
            if (pu >= hsize) {
                pu -= hsize;
            }
            if ((oldval = this.values[pu]) == null) {
                return -1;
            }
            if (oldval != REMOVED && this.keys[pu] == key) {
                return pu;
            }
            if (pd < 0) {
                pd += hsize;
            }
            if ((oldval = this.values[pd]) == null) {
                return -1;
            }
            if (oldval != REMOVED && this.keys[pd] == key) {
                return pd;
            }
            pu += j;
            pd -= j;
        }
        return -1;
    }

    public boolean containsValue(Object val) {
        int p = this.findVal(val);
        return p >= 0;
    }

    private int findVal(Object value) {
        value = IntRadkeHashMap.maskNull(value);
        for (int i = 0; i < this.values.length; ++i) {
            if (!IntRadkeHashMap.equals(this.values[i], value)) continue;
            return i;
        }
        return -1;
    }

    private void rehash() {
        if ((float)this.size >= (float)this.fill * this.resizeTreshold) {
            this.rehash(RadkeHashMap.radkeAtLeast(this.keys.length + 1));
        } else {
            this.rehash(this.keys.length);
        }
    }

    private void rehash(int newcapacity) {
        int[] oldkeys = this.keys;
        Object[] oldvals = this.values;
        this.keys = new int[newcapacity];
        this.values = new Object[newcapacity];
        this.size = 0;
        this.fill = 0;
        this.treshold = (int)(this.loadFactor * (float)newcapacity);
        for (int i = 0; i < oldkeys.length; ++i) {
            if (oldvals[i] == null || oldvals[i] == REMOVED) continue;
            this.put(oldkeys[i], oldvals[i]);
        }
    }

    public void clear() {
        Arrays.fill(this.values, null);
        this.size = 0;
        this.fill = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int size64() {
        return this.size;
    }

    public void putAll(IntMap map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public IntSet keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.valueCollection == null) {
            this.valueCollection = new Values();
        }
        return this.valueCollection;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IntMap)) {
            return false;
        }
        IntMap that = (IntMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object val2;
            Object val = this.values[i];
            if (val == null || val == REMOVED || (val2 = that.get(this.keys[i])) != null && val.equals(val2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED) continue;
            hash += IntRadkeHashMap.hash(this.keys[i]) ^ (val == NULL ? 0 : val.hashCode());
        }
        return hash;
    }

    public Object clone() {
        IntRadkeHashMap result;
        try {
            result = (IntRadkeHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result.keys = new int[this.keys.length];
        result.values = new Object[this.values.length];
        result.keySet = null;
        result.entrySet = null;
        result.valueCollection = null;
        result.fill = 0;
        result.size = 0;
        result.putAll(this);
        return result;
    }

    private boolean keySetContainsAll(IntCollection c) {
        IntIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.containsKey(itr.next())) continue;
            return false;
        }
        return true;
    }

    private boolean keySetRemoveMapping(int key) {
        int p = this.find(key);
        if (p < 0) {
            return false;
        }
        Object removed = this.values[p];
        this.values[p] = REMOVED;
        --this.size;
        return true;
    }

    private boolean keySetRemoveAll(IntCollection c) {
        boolean modified = false;
        if (this.keys.length * 2 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || !c.contains(this.keys[i])) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            IntIterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.keySetRemoveMapping(itr.next());
            }
        }
        return modified;
    }

    private boolean keySetRetainAll(IntCollection c) {
        boolean modified = false;
        if (this.keys.length * 4 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || c.contains(this.keys[i])) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            IntRadkeHashMap tmp = new IntRadkeHashMap(this.keys.length, this.loadFactor, this.resizeTreshold);
            IntIterator itr = c.iterator();
            while (itr.hasNext()) {
                int key = itr.next();
                int p = this.find(key);
                if (p < 0) continue;
                tmp.put(key, this.values[p]);
                modified = true;
            }
            if (modified) {
                this.keys = tmp.keys;
                this.values = tmp.values;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    private int[] keySetToArray(int[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new int[size];
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = this.keys[j];
        }
        return a;
    }

    private int[] keySetToArray() {
        int[] a = new int[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = this.keys[j];
        }
        return a;
    }

    private boolean entrySetContainsEntry(Object o) {
        if (!(o instanceof IntMap.Entry)) {
            return false;
        }
        IntMap.Entry e = (IntMap.Entry)o;
        return this.containsMapping(e.getKey(), e.getValue());
    }

    private boolean entrySetContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            IntMap.Entry e;
            Object o = itr.next();
            if (!(o instanceof IntMap.Entry) || this.containsMapping((e = (IntMap.Entry)o).getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean entrySetRemoveMapping(Object o) {
        if (!(o instanceof IntMap.Entry)) {
            return false;
        }
        IntMap.Entry e = (IntMap.Entry)o;
        return this.removeMapping(e.getKey(), e.getValue());
    }

    private boolean entrySetRemoveAll(Collection c) {
        boolean modified = false;
        if (this.keys.length < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || !c.contains(new SimpleEntry(this.keys[i], IntRadkeHashMap.unmaskNull(val)))) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                modified |= this.entrySetRemoveMapping(itr.next());
            }
        }
        return modified;
    }

    private boolean entrySetRetainAll(Collection c) {
        boolean modified = false;
        if (this.keys.length * 4 < c.size()) {
            for (int i = 0; i < this.keys.length; ++i) {
                Object val = this.values[i];
                if (val == null || val == REMOVED || c.contains(new SimpleEntry(this.keys[i], IntRadkeHashMap.unmaskNull(val)))) continue;
                this.values[i] = REMOVED;
                --this.size;
                modified = true;
            }
        } else {
            IntRadkeHashMap tmp = new IntRadkeHashMap(this.keys.length, this.loadFactor, this.resizeTreshold);
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                IntMap.Entry e;
                int p;
                Object o = itr.next();
                if (!(o instanceof IntMap.Entry) || (p = this.find((e = (IntMap.Entry)o).getKey())) < 0) continue;
                Object val = IntRadkeHashMap.unmaskNull(this.values[p]);
                if (!IntRadkeHashMap.equals(e.getValue(), val)) continue;
                tmp.put(e.getKey(), val);
            }
            boolean bl = modified = this.size != tmp.size;
            if (modified) {
                this.keys = tmp.keys;
                this.values = tmp.values;
                this.size = tmp.size;
                this.fill = tmp.fill;
            }
        }
        return modified;
    }

    private Object[] entrySetToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = new SimpleEntry(this.keys[j], IntRadkeHashMap.unmaskNull(val));
        }
        return a;
    }

    private Object[] entrySetToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = new SimpleEntry(this.keys[j], IntRadkeHashMap.unmaskNull(val));
        }
        return a;
    }

    private boolean valuesContainsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.containsValue(itr.next())) continue;
            return false;
        }
        return true;
    }

    private boolean valuesRemoveMapping(Object value) {
        int p = this.findVal(value);
        if (p < 0) {
            return false;
        }
        Object removed = this.values[p];
        this.values[p] = REMOVED;
        --this.size;
        return true;
    }

    private boolean valuesRemoveAll(Collection c) {
        boolean modified = false;
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED || !c.contains(IntRadkeHashMap.unmaskNull(val))) continue;
            this.values[i] = REMOVED;
            --this.size;
            modified = true;
        }
        return modified;
    }

    private boolean valuesRetainAll(Collection c) {
        boolean modified = false;
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED || c.contains(IntRadkeHashMap.unmaskNull(val))) continue;
            this.values[i] = REMOVED;
            --this.size;
            modified = true;
        }
        return modified;
    }

    private Object[] valuesToArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = IntRadkeHashMap.unmaskNull(val);
        }
        return a;
    }

    private Object[] valuesToArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (int j = 0; j < this.keys.length; ++j) {
            Object val = this.values[j];
            if (val == null || val == REMOVED) continue;
            a[i++] = IntRadkeHashMap.unmaskNull(val);
        }
        return a;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        HashIterator itr = new HashIterator();
        while (itr.hasNext()) {
            itr.goNext();
            int k = this.keys[itr.curr];
            Object v = IntRadkeHashMap.unmaskNull(this.values[itr.curr]);
            buf.append(k).append("=").append(v == this ? "(this Map)" : v);
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.keys.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = this.values[i];
            if (val == null || val == REMOVED) continue;
            out.writeInt(this.keys[i]);
            out.writeObject(IntRadkeHashMap.unmaskNull(val));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int capacity = in.readInt();
        this.keys = new int[capacity];
        this.values = new Object[capacity];
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int key = in.readInt();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    private static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static final Object maskNull(Object obj) {
        return obj == null ? NULL : obj;
    }

    private static final Object unmaskNull(Object obj) {
        return obj == NULL ? null : obj;
    }

    private static final int hash(int e) {
        return e;
    }

    private static final int phash(int e) {
        return e & Integer.MAX_VALUE;
    }

    private class Values
    implements Collection {
        private Values() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            IntRadkeHashMap.this.clear();
        }

        public int size() {
            return IntRadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntRadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return IntRadkeHashMap.this.containsValue(o);
        }

        public boolean containsAll(Collection c) {
            return IntRadkeHashMap.this.valuesContainsAll(c);
        }

        public boolean remove(Object o) {
            return IntRadkeHashMap.this.valuesRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return IntRadkeHashMap.this.valuesRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return IntRadkeHashMap.this.valuesRetainAll(c);
        }

        public Object[] toArray() {
            return IntRadkeHashMap.this.valuesToArray();
        }

        public Object[] toArray(Object[] a) {
            return IntRadkeHashMap.this.valuesToArray(a);
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }

    private static class SimpleEntry
    implements IntMap.Entry {
        final int key;
        final Object value;

        SimpleEntry(int key, Object value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Immutable object");
        }

        public boolean equals(Object other) {
            if (!(other instanceof IntMap.Entry)) {
                return false;
            }
            IntMap.Entry that = (IntMap.Entry)other;
            if (this.getKey() != that.getKey()) {
                return false;
            }
            return IntRadkeHashMap.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            int key = this.getKey();
            Object val = this.getValue();
            return IntRadkeHashMap.hash(key) ^ (val == null ? 0 : val.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    implements Set {
        private EntrySet() {
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            IntRadkeHashMap.this.clear();
        }

        public int size() {
            return IntRadkeHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntRadkeHashMap.this.isEmpty();
        }

        public boolean contains(Object o) {
            return IntRadkeHashMap.this.entrySetContainsEntry(o);
        }

        public boolean containsAll(Collection c) {
            return IntRadkeHashMap.this.entrySetContainsAll(c);
        }

        public boolean remove(Object o) {
            return IntRadkeHashMap.this.entrySetRemoveMapping(o);
        }

        public boolean removeAll(Collection c) {
            return IntRadkeHashMap.this.entrySetRemoveAll(c);
        }

        public boolean retainAll(Collection c) {
            return IntRadkeHashMap.this.entrySetRetainAll(c);
        }

        public Object[] toArray() {
            return IntRadkeHashMap.this.entrySetToArray();
        }

        public Object[] toArray(Object[] a) {
            return IntRadkeHashMap.this.entrySetToArray(a);
        }

        public Iterator iterator() {
            return new EntryIterator();
        }
    }

    private class KeySet
    extends AbstractIntSet
    implements IntSet {
        private KeySet() {
        }

        public int min() {
            return IntRadkeHashMap.this.minKey;
        }

        public int max() {
            return IntRadkeHashMap.this.maxKey;
        }

        public boolean add(int e) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            IntRadkeHashMap.this.clear();
        }

        public int size64() {
            return IntRadkeHashMap.this.size64();
        }

        public boolean isEmpty() {
            return IntRadkeHashMap.this.isEmpty();
        }

        public boolean contains(int e) {
            return IntRadkeHashMap.this.containsKey(e);
        }

        public boolean containsAll(IntCollection c) {
            return IntRadkeHashMap.this.keySetContainsAll(c);
        }

        public boolean remove(int e) {
            return IntRadkeHashMap.this.keySetRemoveMapping(e);
        }

        public boolean removeAll(IntCollection c) {
            return IntRadkeHashMap.this.keySetRemoveAll(c);
        }

        public boolean retainAll(IntCollection c) {
            return IntRadkeHashMap.this.keySetRetainAll(c);
        }

        public int[] toArray() {
            return IntRadkeHashMap.this.keySetToArray();
        }

        public int[] toArray(int[] a) {
            return IntRadkeHashMap.this.keySetToArray(a);
        }

        public IntIterator iterator() {
            return new KeyIterator();
        }
    }

    private class ValueIterator
    extends HashIterator
    implements Iterator {
        private ValueIterator() {
        }

        public Object next() {
            this.goNext();
            return IntRadkeHashMap.unmaskNull(IntRadkeHashMap.this.values[this.curr]);
        }
    }

    private class EntryIterator
    extends HashIterator
    implements Iterator {
        private EntryIterator() {
        }

        public Object next() {
            this.goNext();
            return new Entry(this.curr);
        }
    }

    private class Entry
    implements IntMap.Entry {
        final int p;

        Entry(int p) {
            this.p = p;
        }

        public int getKey() {
            if (IntRadkeHashMap.this.values[this.p] == null || IntRadkeHashMap.this.values[this.p] == REMOVED) {
                throw new IllegalStateException("Mapping was removed");
            }
            return IntRadkeHashMap.this.keys[this.p];
        }

        public Object getValue() {
            if (IntRadkeHashMap.this.values[this.p] == null || IntRadkeHashMap.this.values[this.p] == REMOVED) {
                throw new IllegalStateException("Mapping was removed");
            }
            return IntRadkeHashMap.unmaskNull(IntRadkeHashMap.this.values[this.p]);
        }

        public Object setValue(Object value) {
            Object old = IntRadkeHashMap.this.values[this.p];
            if (old == null || old == REMOVED) {
                throw new IllegalStateException("Mapping was removed");
            }
            IntRadkeHashMap.this.values[this.p] = IntRadkeHashMap.maskNull(value);
            return IntRadkeHashMap.unmaskNull(old);
        }

        public boolean equals(Object other) {
            if (!(other instanceof IntMap.Entry)) {
                return false;
            }
            IntMap.Entry that = (IntMap.Entry)other;
            if (this.getKey() != that.getKey()) {
                return false;
            }
            return IntRadkeHashMap.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            Object val = IntRadkeHashMap.this.values[this.p];
            if (val == REMOVED || val == null) {
                return 0;
            }
            int key = IntRadkeHashMap.this.keys[this.p];
            return IntRadkeHashMap.hash(key) ^ (val == NULL ? 0 : val.hashCode());
        }

        public String toString() {
            Object val = IntRadkeHashMap.this.values[this.p];
            if (val == REMOVED || val == null) {
                return "REMOVED";
            }
            return IntRadkeHashMap.this.keys[this.p] + "=" + IntRadkeHashMap.unmaskNull(val);
        }
    }

    private class KeyIterator
    extends HashIterator
    implements IntIterator {
        private KeyIterator() {
        }

        public int next() {
            this.goNext();
            return IntRadkeHashMap.this.keys[this.curr];
        }
    }

    private class HashIterator {
        int curr = 0;
        int next = 0;

        HashIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next < IntRadkeHashMap.this.keys.length;
        }

        protected void goNext() {
            if (this.next >= IntRadkeHashMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            this.curr = this.next++;
            this.findNext();
        }

        private void findNext() {
            while (this.next < IntRadkeHashMap.this.keys.length && (IntRadkeHashMap.this.values[this.next] == null || IntRadkeHashMap.this.values[this.next] == REMOVED)) {
                ++this.next;
            }
        }

        public void remove() {
            if (IntRadkeHashMap.this.values[this.curr] != REMOVED) {
                IntRadkeHashMap.this.values[this.curr] = REMOVED;
                --IntRadkeHashMap.this.size;
            }
        }
    }
}

