/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongIterator;

public abstract class AbstractLongCollection
implements LongCollection {
    public int size() {
        long size64 = this.size64();
        if (size64 > 0L && size64 <= Integer.MAX_VALUE) {
            return (int)size64;
        }
        if (size64 == 0L && !this.contains(0L)) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public long size64() {
        long size = 0L;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(long e) {
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() != e) continue;
            return true;
        }
        return false;
    }

    public abstract LongIterator iterator();

    public long[] toArray() {
        long[] a = new long[this.size()];
        int i = 0;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        int i = 0;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public boolean add(long e) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(long e) {
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() != e) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(LongCollection c) {
        LongIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(LongCollection c) {
        boolean modified = false;
        LongIterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    public boolean retainAll(LongCollection c) {
        boolean modified = false;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(LongCollection c) {
        boolean modified = false;
        if (c == this) {
            modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public void clear() {
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    public String toString() {
        LongIterator itr = this.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }
}

