/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.AbstractLongSet;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongCollections;
import edu.emory.mathcs.util.collections.longs.LongInterval;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongSortedSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractLongSortedSet
extends AbstractLongSet
implements LongSortedSet {
    public boolean isEmpty() {
        return !this.intervalIterator().hasNext();
    }

    public long size64() {
        long size = 0L;
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            size += (long)((LongInterval)itr.next()).size();
        }
        return size;
    }

    public int intervalCount() {
        int count = 0;
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            ++count;
        }
        return count;
    }

    public long first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.firstInterval().first();
    }

    public long last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.lastInterval().last();
    }

    public long pollFirst() {
        long first = this.first();
        this.remove(first);
        return first;
    }

    public long pollLast() {
        long last = this.last();
        this.remove(last);
        return last;
    }

    public LongInterval firstInterval() {
        Iterator itr = this.intervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (LongInterval)itr.next();
    }

    public LongInterval lastInterval() {
        Iterator itr = this.descendingIntervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (LongInterval)itr.next();
    }

    public LongInterval pollFirstInterval() {
        Iterator itr = this.intervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        LongInterval r = (LongInterval)itr.next();
        itr.remove();
        return r;
    }

    public LongInterval pollLastInterval() {
        Iterator itr = this.descendingIntervalIterator();
        if (!itr.hasNext()) {
            return null;
        }
        LongInterval r = (LongInterval)itr.next();
        itr.remove();
        return r;
    }

    public boolean retainAll(LongCollection c) {
        if (c instanceof LongSortedSet) {
            LongSortedSet s = (LongSortedSet)c;
            boolean modified = false;
            modified |= this.removeAll(s.complementSet());
            if (s.min() > this.min()) {
                modified |= this.removeInterval(this.min(), s.min() - 1L);
            }
            if (s.max() < this.max()) {
                modified |= this.removeInterval(s.max() + 1L, this.max());
            }
            return modified;
        }
        return super.retainAll(c);
    }

    public boolean retainInterval(long first, long last) {
        boolean modified = false;
        long min = this.min();
        long max = this.max();
        if (first > min) {
            modified |= this.removeInterval(min, first - 1L);
        }
        if (last < max) {
            modified |= this.removeInterval(last + 1L, max);
        }
        return modified;
    }

    public long higher(long e) {
        if (e == Long.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return this.tailSet(e + 1L).first();
    }

    public long ceiling(long e) {
        return this.tailSet(e).first();
    }

    public long lower(long e) {
        if (e == Long.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.headSet(e - 1L).last();
    }

    public long floor(long e) {
        return this.headSet(e).last();
    }

    public LongSortedSet headSet(long last) {
        return this.subSet(Long.MIN_VALUE, last);
    }

    public LongSortedSet tailSet(long first) {
        return this.subSet(first, Long.MAX_VALUE);
    }

    public LongIterator iterator() {
        return new ForwardIntervalItemIterator(this.intervalIterator());
    }

    public LongIterator descendingIterator() {
        return new ReverseIntervalItemIterator(this.descendingIntervalIterator());
    }

    public String toCompactString() {
        Iterator itr = this.intervalIterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    protected static abstract class AbstractComplementSubView
    extends AbstractLongSortedSet {
        protected final LongSortedSet base;
        protected final long beg;
        protected final long end;

        protected AbstractComplementSubView(LongSortedSet base, long beg, long end) {
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public long min() {
            long min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public long max() {
            long max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public long size64() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.end - this.beg + 1L - this.base.size64();
            }
            return super.size64();
        }

        public int intervalCount() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                int count = this.base.intervalCount();
                if (count == 0) {
                    return this.isEmpty() ? 0 : 1;
                }
                --count;
                if (this.base.first() > this.min()) {
                    ++count;
                }
                if (this.base.last() < this.max()) {
                    ++count;
                }
                return count;
            }
            return super.intervalCount();
        }

        public boolean add(long e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.remove(e);
        }

        public boolean addInterval(long first, long last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.removeInterval(first, last);
        }

        public boolean remove(long e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.add(e);
        }

        public boolean removeInterval(long first, long last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.addInterval(first, last);
        }

        public boolean contains(long e) {
            return e < this.beg || e > this.end ? false : !this.base.contains(e);
        }

        public boolean containsInterval(long first, long last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.beg || last > this.end) {
                return false;
            }
            return !this.base.containsInterval(first, last);
        }

        public LongInterval enclosingInterval(long e) {
            if (e < this.beg || e > this.end) {
                return null;
            }
            if (this.base.contains(e)) {
                return null;
            }
            LongInterval l = this.base.lowerInterval(e);
            LongInterval h = this.base.higherInterval(e);
            long first = l == null ? Long.MIN_VALUE : l.last() + 1L;
            long last = h == null ? Long.MIN_VALUE : h.first() - 1L;
            return this.trim(first, last);
        }

        public LongInterval lowerInterval(long n) {
            LongInterval e = this.base.enclosingInterval(n);
            LongInterval l = this.base.lowerInterval(n);
            if (e != null) {
                long efirst = e.first();
                if (efirst == Long.MIN_VALUE) {
                    return null;
                }
                return this.trim(l == null ? Long.MIN_VALUE : l.last() + 1L, efirst - 1L);
            }
            if (l == null) {
                return null;
            }
            long lfirst = l.first();
            if (lfirst == Long.MIN_VALUE) {
                return null;
            }
            LongInterval ll = this.base.lowerInterval(lfirst - 1L);
            return this.trim(ll == null ? Long.MIN_VALUE : ll.last() + 1L, lfirst - 1L);
        }

        public LongInterval floorInterval(long n) {
            LongInterval e = this.base.enclosingInterval(n);
            LongInterval l = this.base.lowerInterval(n);
            if (e != null) {
                long efirst = e.first();
                if (efirst == Long.MIN_VALUE) {
                    return null;
                }
                return this.trim(l == null ? Long.MIN_VALUE : l.last() + 1L, efirst - 1L);
            }
            long first = l == null ? Long.MIN_VALUE : l.last() + 1L;
            LongInterval h = this.base.higherInterval(n);
            long last = h == null ? Long.MAX_VALUE : h.first() - 1L;
            return this.trim(first, last);
        }

        public LongInterval higherInterval(long n) {
            LongInterval e = this.base.enclosingInterval(n);
            LongInterval h = this.base.higherInterval(n);
            if (e != null) {
                long elast = e.last();
                if (elast == Long.MAX_VALUE) {
                    return null;
                }
                return this.trim(elast + 1L, h == null ? Long.MAX_VALUE : h.first() - 1L);
            }
            if (h == null) {
                return null;
            }
            long hlast = h.last();
            if (hlast == Long.MAX_VALUE) {
                return null;
            }
            LongInterval hh = this.base.higherInterval(hlast + 1L);
            return this.trim(hlast + 1L, hh == null ? Long.MAX_VALUE : hh.first() - 1L);
        }

        public LongInterval ceilingInterval(long n) {
            LongInterval e = this.base.enclosingInterval(n);
            LongInterval h = this.base.higherInterval(n);
            if (e != null) {
                long elast = e.last();
                if (elast == Long.MAX_VALUE) {
                    return null;
                }
                return this.trim(elast + 1L, h == null ? Long.MIN_VALUE : h.first() - 1L);
            }
            long last = h == null ? Long.MAX_VALUE : h.first() - 1L;
            LongInterval l = this.base.lowerInterval(n);
            long first = l == null ? Long.MIN_VALUE : l.last() + 1L;
            return this.trim(first, last);
        }

        public void clear() {
            this.base.addInterval(this.beg, this.end);
        }

        private LongInterval trim(long first, long last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return first <= last ? LongCollections.interval(first, last) : null;
        }

        public abstract Iterator intervalIterator();

        public abstract Iterator descendingIntervalIterator();
    }

    protected static abstract class AbstractSubView
    extends AbstractLongSortedSet
    implements Serializable {
        protected final LongSortedSet base;
        protected final long beg;
        protected final long end;

        protected AbstractSubView(LongSortedSet base, long beg, long end) {
            this.base = base;
            this.beg = beg;
            this.end = end;
        }

        public long min() {
            long min = this.base.min();
            return this.beg > min ? this.beg : min;
        }

        public long max() {
            long max = this.base.max();
            return this.end < max ? this.end : max;
        }

        public long size64() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.base.size64();
            }
            return super.size64();
        }

        public int intervalCount() {
            if (this.beg <= this.base.min() && this.end >= this.base.max()) {
                return this.base.intervalCount();
            }
            return super.intervalCount();
        }

        public void clear() {
            this.removeInterval(this.beg, this.end);
        }

        public boolean add(long e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.add(e);
        }

        public boolean addInterval(long first, long last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.addInterval(first, last);
        }

        public boolean remove(long e) {
            if (e < this.beg || e > this.end) {
                return false;
            }
            return this.base.remove(e);
        }

        public boolean removeInterval(long first, long last) {
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            if (first > last) {
                return false;
            }
            return this.base.removeInterval(first, last);
        }

        public boolean contains(long e) {
            return e < this.beg || e > this.end ? false : this.base.contains(e);
        }

        public boolean containsInterval(long first, long last) {
            if (first > last) {
                return true;
            }
            if (first == last) {
                return this.contains(first);
            }
            if (first < this.beg || last > this.end) {
                return false;
            }
            return this.base.containsInterval(first, last);
        }

        public LongInterval enclosingInterval(long e) {
            if (e < this.beg || e > this.end) {
                return null;
            }
            return this.trim(this.base.enclosingInterval(e));
        }

        public LongInterval higherInterval(long e) {
            return this.trim(this.base.higherInterval(e));
        }

        public LongInterval ceilingInterval(long e) {
            return this.trim(this.base.ceilingInterval(e));
        }

        public LongInterval lowerInterval(long e) {
            return this.trim(this.base.lowerInterval(e));
        }

        public LongInterval floorInterval(long e) {
            return this.trim(this.base.floorInterval(e));
        }

        public abstract LongSortedSet subSet(long var1, long var3);

        public abstract Iterator intervalIterator();

        public abstract Iterator descendingIntervalIterator();

        private LongInterval trim(LongInterval r) {
            long first = r.first();
            long last = r.last();
            if (first >= this.beg && last <= this.end) {
                return r;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return first <= last ? LongCollections.interval(first, last) : null;
        }
    }

    protected static class ReverseIntervalItemIterator
    implements LongIterator {
        Iterator it;
        LongInterval currInterval;
        protected long cursor;
        protected long lastRet;
        protected boolean lastRetValid = false;

        ReverseIntervalItemIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.currInterval != null;
        }

        public long next() {
            if (this.currInterval == null) {
                this.currInterval = (LongInterval)this.it.next();
                this.cursor = this.currInterval.last();
            }
            this.lastRet = this.cursor;
            this.lastRetValid = true;
            if (this.cursor > this.currInterval.first()) {
                --this.cursor;
            } else if (this.it.hasNext()) {
                this.currInterval = (LongInterval)this.it.next();
                this.cursor = this.currInterval.last();
            } else {
                this.currInterval = null;
            }
            return this.lastRet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class ForwardIntervalItemIterator
    implements LongIterator {
        Iterator it;
        LongInterval currInterval;
        protected long cursor;
        protected long lastRet;
        protected boolean lastRetValid = false;

        ForwardIntervalItemIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext() || this.currInterval != null;
        }

        public long next() {
            if (this.currInterval == null) {
                this.currInterval = (LongInterval)this.it.next();
                this.cursor = this.currInterval.first();
            }
            this.lastRet = this.cursor;
            this.lastRetValid = true;
            if (this.cursor < this.currInterval.last()) {
                ++this.cursor;
            } else if (this.it.hasNext()) {
                this.currInterval = (LongInterval)this.it.next();
                this.cursor = this.currInterval.first();
            } else {
                this.currInterval = null;
            }
            return this.lastRet;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

