/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.longs;

import edu.emory.mathcs.util.collections.longs.AbstractLongInterval;
import edu.emory.mathcs.util.collections.longs.AbstractLongSortedSet;
import edu.emory.mathcs.util.collections.longs.LongCollection;
import edu.emory.mathcs.util.collections.longs.LongCollections;
import edu.emory.mathcs.util.collections.longs.LongInterval;
import edu.emory.mathcs.util.collections.longs.LongIterator;
import edu.emory.mathcs.util.collections.longs.LongSet;
import edu.emory.mathcs.util.collections.longs.LongSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongIntervalSet
extends AbstractLongSortedSet
implements Serializable {
    transient Entry root;
    transient long size;
    transient int intervalCount;
    transient int modCount;
    final long min;
    final long max;

    public LongIntervalSet() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongIntervalSet(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public LongIntervalSet(LongCollection c) {
        this();
        this.addAll(c);
    }

    public LongIntervalSet(LongSet c) {
        this(c.min(), c.max());
        this.addAll(c);
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public int intervalCount() {
        return this.intervalCount;
    }

    public long size64() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void clear() {
        this.root = null;
        this.intervalCount = 0;
        this.size = 0L;
    }

    public boolean add(long n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Entry e = this.getInsertionPoint(n);
        if (e == null) {
            this.insertRight(new Entry(n, n), this.getLastEntry());
            ++this.size;
            return true;
        }
        if (n < e.first - 1L) {
            this.insertLeft(new Entry(n, n), e);
            ++this.size;
            return true;
        }
        if (n == e.first - 1L) {
            e.first--;
            ++this.size;
            return true;
        }
        if (n <= e.last) {
            return false;
        }
        Entry next = LongIntervalSet.successor(e);
        if (next != null && n == next.first - 1L) {
            e.last = next.last;
            this.delete(next);
            ++this.size;
            return true;
        }
        e.last++;
        ++this.size;
        return true;
    }

    public boolean addInterval(long first, long last) {
        Entry e;
        if (first > last) {
            return false;
        }
        if (first == last) {
            return this.add(first);
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        if ((e = this.getInsertionPoint(first)) == null) {
            this.insertRight(new Entry(first, last), this.getLastEntry());
            this.size += last - first + 1L;
            return true;
        }
        if (last < e.first - 1L) {
            this.insertLeft(new Entry(first, last), e);
            this.size += last - first + 1L;
            return true;
        }
        if (last <= e.last) {
            if (first >= e.first) {
                return false;
            }
            this.size += e.first - first;
            e.first = first;
            return true;
        }
        Entry base = e;
        if (first < base.first) {
            this.size += base.first - first;
            base.first = first;
        }
        e = LongIntervalSet.successor(e);
        while (e != null) {
            if (last < e.first - 1L) {
                this.size += last - base.last;
                base.last = last;
                return true;
            }
            this.size -= e.last - e.first + 1L;
            if (last <= e.last) {
                this.size += e.last - base.last;
                base.last = e.last;
                this.delete(e);
                return true;
            }
            e = this.deleteAndAdvance(e);
        }
        this.size += last - base.last;
        base.last = last;
        return true;
    }

    public boolean addAll(LongCollection c) {
        if (c == this) {
            return false;
        }
        if (c instanceof SubView) {
            SubView s = (SubView)c;
            if (s.base == this) {
                return false;
            }
        } else if (c instanceof ComplementSubView) {
            ComplementSubView s = (ComplementSubView)c;
            if (s.base == this) {
                return this.addInterval(s.min(), s.max());
            }
        }
        return super.addAll(c);
    }

    public boolean remove(long n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        Entry e = this.getEntry(n);
        if (e == null) {
            return false;
        }
        if (e.first == e.last) {
            this.delete(e);
        } else if (n == e.first) {
            e.first++;
        } else if (n == e.last) {
            e.last--;
        } else {
            long last = e.last;
            e.last = n - 1L;
            this.insertRight(new Entry(n + 1L, last), e);
        }
        --this.size;
        return true;
    }

    public boolean removeInterval(long first, long last) {
        if (first > last) {
            return false;
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        if (first == last) {
            return this.remove(first);
        }
        Entry e = this.getCeilingEntry(first);
        if (e == null) {
            return false;
        }
        boolean modified = false;
        if (first > e.first) {
            if (last < e.last) {
                Entry newe = new Entry(last + 1L, e.last);
                e.last = first - 1L;
                this.insertRight(newe, e);
                this.size -= last - first + 1L;
                return true;
            }
            this.size -= first - e.last;
            e.last = first - 1L;
            e = LongIntervalSet.successor(e);
            if (e == null) {
                return true;
            }
            modified = true;
        }
        while (last >= e.last) {
            if ((e = this.deleteAndAdvance(e)) == null) {
                return true;
            }
            modified = true;
        }
        if (last >= e.first) {
            this.size -= last - e.first + 1L;
            e.first = last + 1L;
            return true;
        }
        return modified;
    }

    public boolean removeAll(LongCollection c) {
        if (c == this) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        if (c instanceof SubView) {
            SubView s = (SubView)c;
            if (s.base == this) {
                return this.removeInterval(s.min(), s.max());
            }
        } else if (c instanceof ComplementSubView) {
            ComplementSubView s = (ComplementSubView)c;
            if (s.base == this) {
                return false;
            }
        }
        return super.removeAll(c);
    }

    public boolean contains(long n) {
        if (n < this.min || n > this.max) {
            return false;
        }
        return this.getEntry(n) != null;
    }

    public boolean containsInterval(long first, long last) {
        if (first > last) {
            return true;
        }
        if (first == last) {
            return this.contains(first);
        }
        if (first < this.min || last > this.max) {
            return false;
        }
        Entry e = this.getEntry(first);
        return e != null && e.last >= last;
    }

    public LongInterval enclosingInterval(long e) {
        if (e < this.min || e > this.max) {
            return null;
        }
        return this.getEntry(e);
    }

    public long lower(long n) {
        if (n == this.min) {
            throw new NoSuchElementException();
        }
        return this.floor(n - 1L);
    }

    public long floor(long n) {
        if (n < this.min) {
            throw new NoSuchElementException();
        }
        Entry e = this.getFloorEntry(n);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return n <= e.last ? n : e.last;
    }

    public long higher(long n) {
        if (n == this.max) {
            throw new NoSuchElementException();
        }
        return this.ceiling(n + 1L);
    }

    public long ceiling(long n) {
        if (n > this.max) {
            throw new NoSuchElementException();
        }
        Entry e = this.getCeilingEntry(n);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return n >= e.first ? n : e.first;
    }

    public Iterator intervalIterator() {
        return new ForwardIntervalIterator(this.getFirstEntry());
    }

    public LongIterator iterator() {
        return new ForwardItemIterator();
    }

    public Iterator descendingIntervalIterator() {
        return new ReverseIntervalIterator(this.getLastEntry());
    }

    public LongIterator descendingIterator() {
        return new ReverseItemIterator();
    }

    public long first() {
        Entry r = this.getFirstEntry();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return r.first;
    }

    public long last() {
        Entry r = this.getLastEntry();
        if (r == null) {
            throw new NoSuchElementException();
        }
        return r.last;
    }

    public long pollFirst() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        long first = e.first;
        if (e.first == e.last) {
            this.delete(e);
        } else {
            e.first++;
        }
        --this.size;
        return first;
    }

    public long pollLast() {
        Entry e = this.getLastEntry();
        if (e == null) {
            throw new NoSuchElementException();
        }
        long last = e.last;
        if (e.first == e.last) {
            this.delete(e);
        } else {
            e.last--;
        }
        --this.size;
        return last;
    }

    public LongInterval firstInterval() {
        return this.getFirstEntry();
    }

    public LongInterval lastInterval() {
        return this.getLastEntry();
    }

    public LongInterval ceilingInterval(long n) {
        return this.getCeilingEntry(n);
    }

    public LongInterval floorInterval(long n) {
        return this.getFloorEntry(n);
    }

    public LongInterval higherInterval(long n) {
        return this.getHigherEntry(n);
    }

    public LongInterval lowerInterval(long n) {
        return this.getLowerEntry(n);
    }

    public LongInterval pollFirstInterval() {
        Entry e = this.getFirstEntry();
        if (e == null) {
            return null;
        }
        long first = e.first;
        long last = e.last;
        this.delete(e);
        this.size -= last - first + 1L;
        return LongCollections.interval(first, last);
    }

    public LongInterval pollLastInterval() {
        Entry e = this.getLastEntry();
        if (e == null) {
            return null;
        }
        long first = e.first;
        long last = e.last;
        this.delete(e);
        this.size -= last - first + 1L;
        return LongCollections.interval(first, last);
    }

    public LongSortedSet subSet(long first, long last) {
        if (first == this.min && last == this.max) {
            return this;
        }
        if (first < this.min) {
            first = this.min;
        }
        if (last > this.max) {
            last = this.max;
        }
        return new SubView(this, first, last);
    }

    public LongSet complementSet() {
        return new ComplementSubView(this, this.min, this.max);
    }

    private static LongInterval fix(LongInterval r, long min, long max) {
        long first = r.first();
        long last = r.last();
        if (first >= min && last <= max) {
            return r;
        }
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        return LongCollections.interval(first, last);
    }

    private Entry getEntry(long n) {
        Entry t = this.root;
        while (true) {
            if (t == null) {
                return null;
            }
            if (n < t.first) {
                t = t.left;
                continue;
            }
            if (n <= t.last) break;
            t = t.right;
        }
        return t;
    }

    private Entry getInsertionPoint(long n) {
        return n > Long.MIN_VALUE ? this.getCeilingEntry(n - 1L) : this.getFirstEntry();
    }

    private Entry getHigherEntry(long n) {
        Entry t = this.root;
        if (t == null) {
            return null;
        }
        while (true) {
            if (n < t.first) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                return t;
            }
            if (t.right == null) break;
            t = t.right;
        }
        Entry parent = t.parent;
        while (parent != null && t == parent.right) {
            t = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry getFirstEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.left != null) {
            e = e.left;
        }
        return e;
    }

    private Entry getLastEntry() {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (e.right != null) {
            e = e.right;
        }
        return e;
    }

    private Entry getCeilingEntry(long n) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                if (n < e.first) {
                    if (e.left != null) {
                        e = e.left;
                        continue;
                    }
                    return e;
                }
                if (n <= e.last) break block5;
                if (e.right == null) break;
                e = e.right;
            }
            Entry p = e.parent;
            while (p != null && e == p.right) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private Entry getLowerEntry(long n) {
        Entry e = this.root;
        if (e == null) {
            return null;
        }
        while (true) {
            if (n > e.last) {
                if (e.right != null) {
                    e = e.right;
                    continue;
                }
                return e;
            }
            if (e.left == null) break;
            e = e.left;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry getFloorEntry(long n) {
        Entry e;
        block5: {
            e = this.root;
            if (e == null) {
                return null;
            }
            while (true) {
                if (n > e.last) {
                    if (e.right != null) {
                        e = e.right;
                        continue;
                    }
                    return e;
                }
                if (n >= e.first) break block5;
                if (e.left == null) break;
                e = e.left;
            }
            Entry p = e.parent;
            while (p != null && e == p.left) {
                e = p;
                p = p.parent;
            }
            return p;
        }
        return e;
    }

    private void insertLeft(Entry e, Entry where) {
        if (where == null) {
            this.root = e;
            this.intervalCount = 1;
            return;
        }
        if (where.left == null) {
            where.left = e;
        } else {
            where = where.left;
            while (where.right != null) {
                where = where.right;
            }
            where.right = e;
        }
        e.parent = where;
        this.fixAfterInsertion(e);
        ++this.intervalCount;
    }

    private void insertRight(Entry e, Entry where) {
        if (where == null) {
            this.root = e;
            this.intervalCount = 1;
            return;
        }
        if (where.right == null) {
            where.right = e;
        } else {
            where = where.right;
            while (where.left != null) {
                where = where.left;
            }
            where.left = e;
        }
        e.parent = where;
        this.fixAfterInsertion(e);
        ++this.intervalCount;
    }

    private static Entry successor(Entry e) {
        if (e.right != null) {
            e = e.right;
            while (e.left != null) {
                e = e.left;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.right) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private static Entry predecessor(Entry e) {
        if (e.left != null) {
            e = e.left;
            while (e.right != null) {
                e = e.right;
            }
            return e;
        }
        Entry p = e.parent;
        while (p != null && e == p.left) {
            e = p;
            p = p.parent;
        }
        return p;
    }

    private Entry deleteAndAdvance(Entry e) {
        Entry next = e.left == null || e.right == null ? LongIntervalSet.successor(e) : e;
        this.delete(e);
        return next;
    }

    private void delete(Entry e) {
        if (e.left == null && e.right == null && e.parent == null) {
            this.root = null;
            this.intervalCount = 0;
            return;
        }
        if (e.left != null && e.right != null) {
            Entry s = LongIntervalSet.successor(e);
            e.first = s.first;
            e.last = s.last;
            e = s;
        }
        if (e.left == null && e.right == null) {
            if (e.color) {
                this.fixAfterDeletion(e);
            }
            if (e.parent != null) {
                if (e == e.parent.left) {
                    e.parent.left = null;
                } else if (e == e.parent.right) {
                    e.parent.right = null;
                }
                e.parent = null;
            }
        } else {
            Entry replacement = e.left;
            if (replacement == null) {
                replacement = e.right;
            }
            replacement.parent = e.parent;
            if (e.parent == null) {
                this.root = replacement;
            } else if (e == e.parent.left) {
                e.parent.left = replacement;
            } else {
                e.parent.right = replacement;
            }
            e.left = null;
            e.right = null;
            e.parent = null;
            if (e.color) {
                this.fixAfterDeletion(replacement);
            }
        }
        --this.intervalCount;
    }

    static boolean colorOf(Entry p) {
        return p == null ? true : p.color;
    }

    static Entry parentOf(Entry p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static Entry leftOf(Entry p) {
        return p == null ? null : p.left;
    }

    private static Entry rightOf(Entry p) {
        return p == null ? null : p.right;
    }

    private final void rotateLeft(Entry e) {
        Entry r = e.right;
        e.right = r.left;
        if (r.left != null) {
            r.left.parent = e;
        }
        r.parent = e.parent;
        if (e.parent == null) {
            this.root = r;
        } else if (e.parent.left == e) {
            e.parent.left = r;
        } else {
            e.parent.right = r;
        }
        r.left = e;
        e.parent = r;
    }

    private final void rotateRight(Entry e) {
        Entry l = e.left;
        e.left = l.right;
        if (l.right != null) {
            l.right.parent = e;
        }
        l.parent = e.parent;
        if (e.parent == null) {
            this.root = l;
        } else if (e.parent.right == e) {
            e.parent.right = l;
        } else {
            e.parent.left = l;
        }
        l.right = e;
        e.parent = l;
    }

    private final void fixAfterInsertion(Entry e) {
        e.color = false;
        Entry x = e;
        while (x != null && x != this.root && !x.parent.color) {
            Entry y;
            if (LongIntervalSet.parentOf(x) == LongIntervalSet.leftOf(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)))) {
                y = LongIntervalSet.rightOf(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)));
                if (!LongIntervalSet.colorOf(y)) {
                    LongIntervalSet.setColor(LongIntervalSet.parentOf(x), true);
                    LongIntervalSet.setColor(y, true);
                    LongIntervalSet.setColor(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)), false);
                    x = LongIntervalSet.parentOf(LongIntervalSet.parentOf(x));
                    continue;
                }
                if (x == LongIntervalSet.rightOf(LongIntervalSet.parentOf(x))) {
                    x = LongIntervalSet.parentOf(x);
                    this.rotateLeft(x);
                }
                LongIntervalSet.setColor(LongIntervalSet.parentOf(x), true);
                LongIntervalSet.setColor(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)), false);
                if (LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)) == null) continue;
                this.rotateRight(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)));
                continue;
            }
            y = LongIntervalSet.leftOf(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)));
            if (!LongIntervalSet.colorOf(y)) {
                LongIntervalSet.setColor(LongIntervalSet.parentOf(x), true);
                LongIntervalSet.setColor(y, true);
                LongIntervalSet.setColor(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)), false);
                x = LongIntervalSet.parentOf(LongIntervalSet.parentOf(x));
                continue;
            }
            if (x == LongIntervalSet.leftOf(LongIntervalSet.parentOf(x))) {
                x = LongIntervalSet.parentOf(x);
                this.rotateRight(x);
            }
            LongIntervalSet.setColor(LongIntervalSet.parentOf(x), true);
            LongIntervalSet.setColor(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)), false);
            if (LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)) == null) continue;
            this.rotateLeft(LongIntervalSet.parentOf(LongIntervalSet.parentOf(x)));
        }
        this.root.color = true;
    }

    private final Entry fixAfterDeletion(Entry e) {
        Entry x = e;
        while (x != this.root && LongIntervalSet.colorOf(x)) {
            Entry sib;
            if (x == LongIntervalSet.leftOf(LongIntervalSet.parentOf(x))) {
                sib = LongIntervalSet.rightOf(LongIntervalSet.parentOf(x));
                if (!LongIntervalSet.colorOf(sib)) {
                    LongIntervalSet.setColor(sib, true);
                    LongIntervalSet.setColor(LongIntervalSet.parentOf(x), false);
                    this.rotateLeft(LongIntervalSet.parentOf(x));
                    sib = LongIntervalSet.rightOf(LongIntervalSet.parentOf(x));
                }
                if (LongIntervalSet.colorOf(LongIntervalSet.leftOf(sib)) && LongIntervalSet.colorOf(LongIntervalSet.rightOf(sib))) {
                    LongIntervalSet.setColor(sib, false);
                    x = LongIntervalSet.parentOf(x);
                    continue;
                }
                if (LongIntervalSet.colorOf(LongIntervalSet.rightOf(sib))) {
                    LongIntervalSet.setColor(LongIntervalSet.leftOf(sib), true);
                    LongIntervalSet.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = LongIntervalSet.rightOf(LongIntervalSet.parentOf(x));
                }
                LongIntervalSet.setColor(sib, LongIntervalSet.colorOf(LongIntervalSet.parentOf(x)));
                LongIntervalSet.setColor(LongIntervalSet.parentOf(x), true);
                LongIntervalSet.setColor(LongIntervalSet.rightOf(sib), true);
                this.rotateLeft(LongIntervalSet.parentOf(x));
                x = this.root;
                continue;
            }
            sib = LongIntervalSet.leftOf(LongIntervalSet.parentOf(x));
            if (!LongIntervalSet.colorOf(sib)) {
                LongIntervalSet.setColor(sib, true);
                LongIntervalSet.setColor(LongIntervalSet.parentOf(x), false);
                this.rotateRight(LongIntervalSet.parentOf(x));
                sib = LongIntervalSet.leftOf(LongIntervalSet.parentOf(x));
            }
            if (LongIntervalSet.colorOf(LongIntervalSet.rightOf(sib)) && LongIntervalSet.colorOf(LongIntervalSet.leftOf(sib))) {
                LongIntervalSet.setColor(sib, false);
                x = LongIntervalSet.parentOf(x);
                continue;
            }
            if (LongIntervalSet.colorOf(LongIntervalSet.leftOf(sib))) {
                LongIntervalSet.setColor(LongIntervalSet.rightOf(sib), true);
                LongIntervalSet.setColor(sib, false);
                this.rotateLeft(sib);
                sib = LongIntervalSet.leftOf(LongIntervalSet.parentOf(x));
            }
            LongIntervalSet.setColor(sib, LongIntervalSet.colorOf(LongIntervalSet.parentOf(x)));
            LongIntervalSet.setColor(LongIntervalSet.parentOf(x), true);
            LongIntervalSet.setColor(LongIntervalSet.leftOf(sib), true);
            this.rotateRight(LongIntervalSet.parentOf(x));
            x = this.root;
        }
        LongIntervalSet.setColor(x, true);
        return this.root;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.intervalCount);
        Iterator itr = this.intervalIterator();
        while (itr.hasNext()) {
            LongInterval iv = (LongInterval)itr.next();
            out.writeLong(iv.first());
            out.writeLong(iv.last());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int intervalCount = in.readInt();
        for (int i = 0; i < intervalCount; ++i) {
            long first = in.readLong();
            long last = in.readLong();
            this.addInterval(first, last);
        }
    }

    private static class ReverseComplementSubIntervalIterator
    implements Iterator {
        final LongIntervalSet base;
        final long min;
        final long max;
        LongInterval prev;
        long cursor;
        Entry next;
        LongInterval lastRet;

        ReverseComplementSubIntervalIterator(LongIntervalSet base, long min, long max) {
            this.base = base;
            this.min = min;
            this.max = max;
            Entry e = base.getCeilingEntry(max);
            if (e != null) {
                this.cursor = e.first < max ? e.first : max;
                this.next = LongIntervalSet.predecessor(e);
            } else {
                this.cursor = max;
                this.next = base.getLowerEntry(max);
            }
        }

        public boolean hasNext() {
            return this.cursor > this.min;
        }

        public Object next() {
            long first;
            long last;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l = last = this.cursor < this.max ? this.cursor - 1L : this.max;
            if (this.next == null) {
                this.cursor = first = this.min;
            } else {
                first = this.next.last + 1L;
                if (first < this.min) {
                    first = this.min;
                }
                this.cursor = this.next.first;
                this.next = LongIntervalSet.predecessor(this.next);
            }
            this.lastRet = LongCollections.interval(first, last);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.base.addInterval(this.lastRet.first(), this.lastRet.last());
            this.lastRet = null;
            this.next = this.base.getLowerEntry(this.cursor);
        }
    }

    private static class ForwardComplementSubIntervalIterator
    implements Iterator {
        final LongIntervalSet base;
        final long min;
        final long max;
        LongInterval prev;
        long cursor;
        Entry next;
        LongInterval lastRet;

        ForwardComplementSubIntervalIterator(LongIntervalSet base, long min, long max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.cursor = min;
            Entry e = base.getFloorEntry(min);
            if (e != null) {
                this.cursor = e.last > min ? e.last : min;
                this.next = LongIntervalSet.successor(e);
            } else {
                this.cursor = min;
                this.next = base.getHigherEntry(min);
            }
        }

        public boolean hasNext() {
            return this.cursor < this.max;
        }

        public Object next() {
            long last;
            long first;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long l = first = this.cursor > this.min ? this.cursor + 1L : this.min;
            if (this.next == null) {
                this.cursor = last = this.max;
            } else {
                last = this.next.first - 1L;
                if (last > this.max) {
                    last = this.max;
                }
                this.cursor = this.next.last;
                this.next = LongIntervalSet.successor(this.next);
            }
            this.lastRet = LongCollections.interval(first, last);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.base.addInterval(this.lastRet.first(), this.lastRet.last());
            this.lastRet = null;
            this.next = this.base.getHigherEntry(this.cursor);
        }
    }

    private static class ReverseSubItemIterator
    extends AbstractLongSortedSet.ReverseIntervalItemIterator {
        ReverseSubItemIterator(LongIntervalSet base, long first, long last) {
            super(new ReverseSubIntervalIterator(base, first, last, base.getFloorEntry(last)));
        }

        public void remove() {
            boolean restructured;
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            ReverseSubIntervalIterator s = (ReverseSubIntervalIterator)this.it;
            if (this.currInterval != null) {
                long cfirst = this.currInterval.first();
                long clast = this.currInterval.last();
                restructured = this.lastRet < clast || cfirst == s.first || clast == s.last;
            } else {
                restructured = false;
            }
            s.base.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ReverseSubIntervalIterator(s.base, s.first, s.last, s.base.getLowerEntry(this.lastRet));
            }
        }
    }

    private static class ReverseSubIntervalIterator
    implements Iterator {
        final LongIntervalSet base;
        Entry cursor;
        long first;
        long last;
        Entry lastRet;

        ReverseSubIntervalIterator(LongIntervalSet base, long first, long last, Entry e) {
            this.base = base;
            this.first = first;
            this.last = last;
            this.cursor = e;
        }

        public boolean hasNext() {
            return this.cursor != null && this.cursor.last >= this.first;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = LongIntervalSet.predecessor(this.cursor);
            return LongIntervalSet.fix(this.lastRet, this.first, this.last);
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.first >= this.first) {
                if (this.lastRet.left != null && this.lastRet.right != null) {
                    this.cursor = this.lastRet;
                }
                this.base.delete(this.lastRet);
                this.lastRet = null;
            } else {
                this.cursor = null;
                this.base.removeInterval(this.lastRet.first, this.lastRet.last);
                this.lastRet = null;
            }
        }
    }

    private static class ForwardSubItemIterator
    extends AbstractLongSortedSet.ForwardIntervalItemIterator {
        ForwardSubItemIterator(LongIntervalSet base, long first, long last) {
            super(new ForwardSubIntervalIterator(base, first, last, base.getCeilingEntry(first)));
        }

        public void remove() {
            boolean restructured;
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            ForwardSubIntervalIterator s = (ForwardSubIntervalIterator)this.it;
            if (this.currInterval != null) {
                long cfirst = this.currInterval.first();
                long clast = this.currInterval.last();
                restructured = this.lastRet > cfirst || cfirst == s.first || clast == s.last;
            } else {
                restructured = false;
            }
            s.base.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ForwardSubIntervalIterator(s.base, s.first, s.last, s.base.getHigherEntry(this.lastRet));
            }
        }
    }

    private static class ForwardSubIntervalIterator
    implements Iterator {
        final LongIntervalSet base;
        Entry cursor;
        long first;
        long last;
        Entry lastRet;

        ForwardSubIntervalIterator(LongIntervalSet base, long first, long last, Entry e) {
            this.base = base;
            this.first = first;
            this.last = last;
            this.cursor = e;
        }

        public boolean hasNext() {
            return this.cursor != null && this.cursor.first <= this.last;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = LongIntervalSet.successor(this.cursor);
            return LongIntervalSet.fix(this.lastRet, this.first, this.last);
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.last <= this.last) {
                if (this.lastRet.left != null && this.lastRet.right != null) {
                    this.cursor = this.lastRet;
                }
                this.base.delete(this.lastRet);
                this.lastRet = null;
            } else {
                this.cursor = null;
                this.base.removeInterval(this.lastRet.first, this.lastRet.last);
                this.lastRet = null;
            }
        }
    }

    private static abstract class AbstractSubIntervalIterator
    implements Iterator {
        protected final LongIntervalSet base;
        protected final long min;
        protected final long max;
        protected LongInterval curr;
        protected LongInterval next;

        AbstractSubIntervalIterator(LongIntervalSet base, long min, long max) {
            this.base = base;
            this.min = min;
            this.max = max;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = this.fetchNext();
            return this.curr;
        }

        protected abstract LongInterval fetchNext();

        protected LongInterval fix(LongInterval r) {
            long first = r.first();
            long last = r.last();
            if (first >= this.min && last <= this.max) {
                return r;
            }
            if (first < this.min) {
                first = this.min;
            }
            if (last > this.max) {
                last = this.max;
            }
            return LongCollections.interval(first, last);
        }
    }

    static class ComplementSubView
    extends AbstractLongSortedSet.AbstractComplementSubView
    implements Serializable {
        ComplementSubView(LongIntervalSet base, long beg, long end) {
            super(base, beg, end);
        }

        public boolean addAll(LongCollection c) {
            if (c == this) {
                return false;
            }
            if (c instanceof LongIntervalSet) {
                if (c == this.base) {
                    return this.addInterval(this.beg, this.end);
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.addInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.addAll(c);
        }

        public boolean removeAll(LongCollection c) {
            if (c == this) {
                boolean modified = !this.isEmpty();
                this.clear();
                return modified;
            }
            if (c instanceof LongIntervalSet) {
                if (c == this.base) {
                    return this.removeInterval(this.min(), this.max());
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.removeInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.removeAll(c);
        }

        public Iterator intervalIterator() {
            return new ForwardComplementSubIntervalIterator((LongIntervalSet)this.base, this.beg, this.end);
        }

        public Iterator descendingIntervalIterator() {
            return new ReverseComplementSubIntervalIterator((LongIntervalSet)this.base, this.beg, this.end);
        }

        public LongSortedSet subSet(long first, long last) {
            if (first == this.beg && last == this.end) {
                return this;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return new ComplementSubView((LongIntervalSet)this.base, first, last);
        }

        public LongSet complementSet() {
            if (this.beg == Long.MIN_VALUE && this.end == Long.MAX_VALUE) {
                return this.base;
            }
            return this.base.subSet(this.beg, this.end);
        }
    }

    static class SubView
    extends AbstractLongSortedSet.AbstractSubView
    implements Serializable {
        SubView(LongIntervalSet base, long min, long max) {
            super(base, min, max);
        }

        public boolean addAll(LongCollection c) {
            if (c == this) {
                return false;
            }
            if (c instanceof LongIntervalSet) {
                if (c == this.base) {
                    return false;
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return false;
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return this.addInterval(s.min(), s.max());
                }
            }
            return super.addAll(c);
        }

        public boolean removeAll(LongCollection c) {
            if (c == this) {
                boolean modified = !this.isEmpty();
                this.clear();
                return modified;
            }
            if (c instanceof LongIntervalSet) {
                if (c == this.base) {
                    return this.removeInterval(this.min(), this.max());
                }
            } else if (c instanceof SubView) {
                SubView s = (SubView)c;
                if (s.base == this) {
                    return this.removeInterval(s.min(), s.max());
                }
            } else if (c instanceof ComplementSubView) {
                ComplementSubView s = (ComplementSubView)c;
                if (s.base == this.base) {
                    return false;
                }
            }
            return super.removeAll(c);
        }

        public Iterator intervalIterator() {
            LongIntervalSet lbase = (LongIntervalSet)this.base;
            return new ForwardSubIntervalIterator(lbase, this.beg, this.end, lbase.getCeilingEntry(this.beg));
        }

        public LongIterator iterator() {
            LongIntervalSet lbase = (LongIntervalSet)this.base;
            return new ForwardSubItemIterator(lbase, this.beg, this.end);
        }

        public Iterator descendingIntervalIterator() {
            LongIntervalSet lbase = (LongIntervalSet)this.base;
            return new ReverseSubIntervalIterator(lbase, this.beg, this.end, lbase.getFloorEntry(this.end));
        }

        public LongIterator descendingIterator() {
            LongIntervalSet lbase = (LongIntervalSet)this.base;
            return new ReverseSubItemIterator(lbase, this.beg, this.end);
        }

        public LongSet complementSet() {
            return new ComplementSubView((LongIntervalSet)this.base, this.beg, this.end);
        }

        public LongSortedSet subSet(long first, long last) {
            if (first == this.beg && last == this.end) {
                return this;
            }
            if (first < this.beg) {
                first = this.beg;
            }
            if (last > this.end) {
                last = this.end;
            }
            return this.base.subSet(first, last);
        }
    }

    private class ReverseItemIterator
    extends AbstractLongSortedSet.ReverseIntervalItemIterator {
        ReverseItemIterator() {
            super(new ReverseIntervalIterator(LongIntervalSet.this.getLastEntry()));
        }

        public void remove() {
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            boolean restructured = this.currInterval != null && this.lastRet < this.currInterval.last();
            LongIntervalSet.this.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ReverseIntervalIterator(LongIntervalSet.this.getLowerEntry(this.lastRet));
            }
        }
    }

    private class ReverseIntervalIterator
    implements Iterator {
        Entry cursor;
        Entry lastRet;

        ReverseIntervalIterator(Entry cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = LongIntervalSet.predecessor(this.cursor);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            LongIntervalSet.this.size += this.cursor.last - this.cursor.first + 1L;
            if (this.lastRet.left != null && this.lastRet.right != null) {
                this.cursor = this.lastRet;
            }
            LongIntervalSet.this.delete(this.lastRet);
            this.lastRet = null;
        }
    }

    private class ForwardItemIterator
    extends AbstractLongSortedSet.ForwardIntervalItemIterator {
        ForwardItemIterator() {
            super(new ForwardIntervalIterator(LongIntervalSet.this.getFirstEntry()));
        }

        public void remove() {
            if (!this.lastRetValid) {
                throw new IllegalStateException();
            }
            boolean restructured = this.currInterval != null && this.lastRet > this.currInterval.first();
            LongIntervalSet.this.remove(this.lastRet);
            this.lastRetValid = false;
            if (restructured) {
                this.it = new ForwardIntervalIterator(LongIntervalSet.this.getHigherEntry(this.lastRet));
            }
        }
    }

    private class ForwardIntervalIterator
    implements Iterator {
        Entry cursor;
        Entry lastRet;

        ForwardIntervalIterator(Entry cursor) {
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor != null;
        }

        public Object next() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = LongIntervalSet.successor(this.cursor);
            return this.lastRet;
        }

        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            LongIntervalSet.this.size += this.cursor.last - this.cursor.first + 1L;
            if (this.lastRet.left != null && this.lastRet.right != null) {
                this.cursor = this.lastRet;
            }
            LongIntervalSet.this.delete(this.lastRet);
            this.lastRet = null;
        }
    }

    private static class Entry
    extends AbstractLongInterval {
        private static final boolean RED = false;
        private static final boolean BLACK = true;
        private long first;
        private long last;
        private Entry parent;
        private Entry left;
        private Entry right;
        private boolean color;

        Entry(long first, long last) {
            this.first = first;
            this.last = last;
        }

        protected long getFirst() {
            return this.first;
        }

        protected long getLast() {
            return this.last;
        }

        public long first() {
            return this.first;
        }

        public long last() {
            return this.last;
        }

        public long min() {
            return this.first;
        }

        public long max() {
            return this.last;
        }
    }
}

