/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.AbstractShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortInterval;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;
import edu.emory.mathcs.util.collections.shorts.ShortSet;
import edu.emory.mathcs.util.collections.shorts.ShortSortedSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractShortSet
extends AbstractShortCollection
implements ShortSet {
    protected AbstractShortSet() {
    }

    public short min() {
        return Short.MIN_VALUE;
    }

    public short max() {
        return Short.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortSet)) {
            return false;
        }
        ShortSet that = (ShortSet)obj;
        if (this.size() != that.size()) {
            return false;
        }
        try {
            return this.containsAll(that);
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public int hashCode() {
        int h = 0;
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            h += AbstractShortSet.hash(itr.next());
        }
        return h;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean addAll(ShortCollection c) {
        if (c instanceof ShortInterval) {
            ShortInterval r = (ShortInterval)c;
            return this.addInterval(r.first(), r.last());
        }
        if (c instanceof ShortSortedSet) {
            boolean modified = false;
            Iterator itr = ((ShortSortedSet)c).intervalIterator();
            while (itr.hasNext()) {
                ShortInterval r = (ShortInterval)itr.next();
                modified |= this.addInterval(r.first(), r.last());
            }
            return modified;
        }
        return super.addAll(c);
    }

    public boolean removeAll(ShortCollection c) {
        if (c instanceof ShortInterval) {
            ShortInterval r = (ShortInterval)c;
            return this.removeInterval(r.first(), r.last());
        }
        if (c instanceof ShortSortedSet) {
            boolean modified = false;
            Iterator itr = ((ShortSortedSet)c).intervalIterator();
            while (itr.hasNext()) {
                ShortInterval r = (ShortInterval)itr.next();
                modified |= this.removeInterval(r.first(), r.last());
            }
            return modified;
        }
        if (this.size() <= c.size()) {
            return super.removeAll(c);
        }
        boolean modified = false;
        ShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            modified |= this.remove(itr.next());
        }
        return modified;
    }

    public boolean retainAll(ShortCollection c) {
        if (c instanceof ShortInterval) {
            ShortInterval r = (ShortInterval)c;
            return this.retainInterval(r.first(), r.last());
        }
        return super.retainAll(c);
    }

    public boolean containsInterval(short first, short last) {
        if (first > last) {
            return true;
        }
        if (first == last) {
            return this.contains(first);
        }
        short min = this.min();
        short max = this.max();
        if (first < min || last > max) {
            return false;
        }
        short len = (short)(last - first + 1);
        if (len > this.size()) {
            return false;
        }
        for (short e = first; e <= last; e = (short)(e + 1)) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean addInterval(short first, short last) {
        short min = this.min();
        short max = this.max();
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        boolean modified = false;
        for (short e = first; e <= last; e = (short)(e + 1)) {
            modified |= this.add(e);
        }
        return modified;
    }

    public boolean removeInterval(short first, short last) {
        short min = this.min();
        short max = this.max();
        if (first < min) {
            first = min;
        }
        if (last > max) {
            last = max;
        }
        boolean modified = false;
        for (short e = first; e <= last; e = (short)(e + 1)) {
            modified |= this.remove(e);
        }
        return modified;
    }

    public boolean retainInterval(short first, short last) {
        boolean modified = false;
        ShortIterator itr = this.iterator();
        while (itr.hasNext()) {
            short e = itr.next();
            if (e < first || e > last) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public ShortSet complementSet() {
        return new ComplementView(this);
    }

    private static final int hash(short e) {
        return e;
    }

    private static class ComplementIterator
    implements ShortIterator {
        final ShortSet base;
        final short min;
        final short max;
        short next;
        short curr;

        ComplementIterator(ShortSet base, short min, short max) {
            this.base = base;
            this.min = min;
            this.max = max;
            this.next = min;
            this.fetchNext();
        }

        public boolean hasNext() {
            return this.next <= this.max;
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short s = this.next;
            this.next = (short)(s + 1);
            this.curr = s;
            this.fetchNext();
            return this.curr;
        }

        void fetchNext() {
            while (this.next <= this.max && this.base.contains(this.next)) {
                this.next = (short)(this.next + 1);
            }
        }

        public void remove() {
            this.base.add(this.curr);
        }
    }

    private static class ComplementView
    extends AbstractShortSet {
        final ShortSet base;

        ComplementView(ShortSet base) {
            this.base = base;
        }

        public short min() {
            return this.base.min();
        }

        public short max() {
            return this.base.max();
        }

        public boolean contains(short e) {
            return !this.base.contains(e);
        }

        public boolean add(short e) {
            return this.base.remove(e);
        }

        public boolean remove(short e) {
            return this.base.add(e);
        }

        public boolean addAll(ShortCollection c) {
            return this.base.removeAll(c);
        }

        public boolean removeAll(ShortCollection c) {
            return this.base.addAll(c);
        }

        public boolean addInterval(short first, short last) {
            return this.base.removeInterval(first, last);
        }

        public boolean removeInterval(short first, short last) {
            return this.base.addInterval(first, last);
        }

        public void clear() {
            this.base.addInterval(this.min(), this.max());
        }

        public ShortSet complementSet() {
            return this.base;
        }

        public ShortIterator iterator() {
            return new ComplementIterator(this.base, this.min(), this.max());
        }
    }
}

