/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.collections.shorts;

import edu.emory.mathcs.util.collections.shorts.AbstractShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortCollection;
import edu.emory.mathcs.util.collections.shorts.ShortIterator;
import edu.emory.mathcs.util.collections.shorts.ShortList;
import edu.emory.mathcs.util.collections.shorts.ShortListIterator;
import java.util.NoSuchElementException;

public class ShortArrayList
extends AbstractShortCollection
implements ShortList {
    short[] buffer;
    int size;

    public ShortArrayList() {
        this(10);
    }

    public ShortArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new short[initialCapacity];
    }

    public ShortArrayList(ShortCollection c) {
        int cap = c.size();
        cap += cap / 10;
        if (cap < 0) {
            cap = Integer.MAX_VALUE;
        }
        this.buffer = new short[cap];
        this.addAll(c);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(short e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            return true;
        }
        return false;
    }

    public ShortIterator iterator() {
        return new Itr(0);
    }

    public short[] toArray() {
        short[] a = new short[this.size];
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        return a;
    }

    public short[] toArray(short[] a) {
        if (a.length < this.size) {
            a = new short[this.size];
        }
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        return a;
    }

    private void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        if (capacity > this.buffer.length) {
            int newlen = 2 * this.buffer.length;
            if (newlen < this.buffer.length) {
                newlen = Integer.MAX_VALUE;
            }
            if (newlen < capacity) {
                newlen = capacity;
            }
            short[] newbuf = new short[newlen];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.size);
            this.buffer = newbuf;
        }
    }

    public boolean add(short e) {
        this.ensureCapacity(this.size + 1);
        this.buffer[this.size++] = e;
        return true;
    }

    public boolean remove(short e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            System.arraycopy(this.buffer, i + 1, this.buffer, i, this.size - i - 1);
            --this.size;
            return true;
        }
        return false;
    }

    public boolean addAll(ShortCollection c) {
        this.ensureCapacity(this.size + c.size());
        ShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            this.buffer[this.size++] = itr.next();
        }
        return true;
    }

    public boolean addAll(int index, ShortCollection c) {
        int csize = c.size();
        this.ensureCapacity(this.size + csize);
        System.arraycopy(this.buffer, index, this.buffer, index + csize, this.size - index);
        ShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            this.buffer[index++] = itr.next();
        }
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShortList)) {
            return false;
        }
        ShortList that = (ShortList)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] == that.getAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + this.buffer[i];
        }
        return hashCode;
    }

    public short getAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.buffer[index];
    }

    public short setAt(int index, short e) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        short old = this.buffer[index];
        this.buffer[index] = e;
        return old;
    }

    public void addAt(int index, short e) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[index] = e;
        ++this.size;
    }

    public short removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        short e = this.buffer[index];
        System.arraycopy(this.buffer, index + 1, this.buffer, index, this.size - index - 1);
        --this.size;
        return e;
    }

    public int indexOf(short e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != e) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short e) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.buffer[i] != e) continue;
            return i;
        }
        return -1;
    }

    public ShortListIterator listIterator() {
        return new Itr(0);
    }

    public ShortListIterator listIterator(int index) {
        return new Itr(index);
    }

    public ShortList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    class Itr
    implements ShortListIterator {
        int cursor = 0;
        int last = -1;

        Itr(int idx) {
            this.cursor = idx;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public boolean hasNext() {
            return this.cursor < ShortArrayList.this.size();
        }

        public short next() {
            try {
                short e = ShortArrayList.this.getAt(this.cursor);
                this.last = ++this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public short previous() {
            try {
                short e = ShortArrayList.this.getAt(this.cursor - 1);
                this.last = --this.cursor;
                return e;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void set(short e) {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            ShortArrayList.this.setAt(this.last, e);
        }

        public void add(short e) {
            ShortArrayList.this.addAt(this.cursor++, e);
            this.last = -1;
        }

        public void remove() {
            if (this.last < 0) {
                throw new IllegalStateException();
            }
            ShortArrayList.this.removeAt(this.last);
            if (this.last < this.cursor) {
                --this.cursor;
            }
            this.last = -1;
        }
    }
}

