/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.util.concurrent.Callback;
import edu.emory.mathcs.util.concurrent.SecureThreadPoolExecutor;
import edu.emory.mathcs.util.concurrent.ThreadContext;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;

public class ExecutorUtils {
    private ExecutorUtils() {
    }

    public static ExecutorService newFixedSecureThreadPool(int nThreads) {
        return new SecureThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    }

    public static ExecutorService newSecureSingleThreadExecutor() {
        return new DelegatedExecutorService(new SecureThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()));
    }

    public static ExecutorService newSecureCachedThreadPool() {
        return new SecureThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
    }

    public static Runnable delegatedRunnable(Runnable runnable) {
        return new DelegatedRunnable(runnable, ThreadContext.getContext());
    }

    public static Runnable delegatedRunnable(Runnable runnable, ThreadContext tc) {
        return new DelegatedRunnable(runnable, tc);
    }

    public static Callable delegatedCallable(Callable callable) {
        return new DelegatedCallable(callable, ThreadContext.getContext());
    }

    public static Callable delegatedCallable(Callable callable, ThreadContext tc) {
        return new DelegatedCallable(callable, tc);
    }

    public static ThreadFactory safeThreadFactory() {
        return new SafeThreadFactory();
    }

    public static Future completedFuture(Object result) {
        return ExecutorUtils.completedFuture(result, null);
    }

    public static Future completedFuture(Object result, Callback cb) {
        if (cb != null) {
            cb.completed(result);
        }
        return new CompletedFuture(result, null);
    }

    public static Future failedFuture(Throwable cause) {
        return ExecutorUtils.failedFuture(cause, null);
    }

    public static Future failedFuture(Throwable cause, Callback cb) {
        if (cb != null) {
            cb.failed(cause);
        }
        return new CompletedFuture(null, cause);
    }

    static class DelegatedScheduledExecutorService
    extends DelegatedExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService e;

        DelegatedScheduledExecutorService(ScheduledExecutorService executor) {
            super(executor);
            this.e = executor;
        }

        public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
            return this.e.schedule(command, delay, unit);
        }

        public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
            return this.e.schedule(callable, delay, unit);
        }

        public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.e.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.e.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    static class DelegatedExecutorService
    extends AbstractExecutorService {
        private final ExecutorService e;

        DelegatedExecutorService(ExecutorService executor) {
            this.e = executor;
        }

        public void execute(Runnable command) {
            this.e.execute(command);
        }

        public void shutdown() {
            this.e.shutdown();
        }

        public List shutdownNow() {
            return this.e.shutdownNow();
        }

        public boolean isShutdown() {
            return this.e.isShutdown();
        }

        public boolean isTerminated() {
            return this.e.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.awaitTermination(timeout, unit);
        }

        public Future submit(Runnable task) {
            return this.e.submit(task);
        }

        public Future submit(Callable task) {
            return this.e.submit(task);
        }

        public Future submit(Runnable task, Object result) {
            return this.e.submit(task, result);
        }

        public List invokeAll(Collection tasks) throws InterruptedException {
            return this.e.invokeAll(tasks);
        }

        public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.e.invokeAll(tasks, timeout, unit);
        }

        public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
            return this.e.invokeAny(tasks);
        }

        public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.e.invokeAny(tasks, timeout, unit);
        }
    }

    static final class CompletedFuture
    implements Future {
        final Object result;
        final Throwable exception;

        CompletedFuture(Object result, Throwable exception) {
            this.result = result;
            this.exception = exception;
        }

        public Object get() throws ExecutionException {
            if (this.exception != null) {
                throw new ExecutionException("Task has completed abruptly", this.exception);
            }
            return this.result;
        }

        public Object get(long timeout, TimeUnit granularity) throws ExecutionException {
            return this.get();
        }

        public boolean isDone() {
            return true;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }
    }

    public static class SafeThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger();
        final AtomicInteger threadNumber;
        final AccessControlContext acc;
        final ThreadGroup group;
        final ThreadContext tc;
        final String name;
        int idx = 0;

        public SafeThreadFactory() {
            this(null, "safe-pool-" + poolNumber.getAndIncrement() + "-thread-");
        }

        public SafeThreadFactory(String name) {
            this(null, name);
        }

        public SafeThreadFactory(ThreadGroup group) {
            this(group, null);
        }

        public SafeThreadFactory(ThreadGroup group, String name) {
            this(group, name, true);
        }

        public SafeThreadFactory(ThreadGroup group, String name, boolean count) {
            SecurityManager security;
            AtomicInteger atomicInteger = this.threadNumber = count ? new AtomicInteger() : null;
            if (group == null && (security = System.getSecurityManager()) != null) {
                group = security.getThreadGroup();
            }
            if (group == null) {
                group = Thread.currentThread().getThreadGroup();
            }
            this.group = group;
            this.name = name;
            this.acc = AccessController.getContext();
            this.tc = ThreadContext.getContext();
        }

        public Thread newThread(Runnable command) {
            return (Thread)AccessController.doPrivileged(this.tc.wrap(new PrivilegedAction(this, command){
                private final /* synthetic */ Runnable val$command;
                private final /* synthetic */ SafeThreadFactory this$0;
                {
                    this.this$0 = this$0;
                    this.val$command = val$command;
                }

                public Object run() {
                    if (this.this$0.name == null) {
                        return new Thread(this.this$0.group, this.val$command);
                    }
                    String tname = this.this$0.name;
                    if (this.this$0.threadNumber != null) {
                        tname = tname + this.this$0.threadNumber.getAndIncrement();
                    }
                    return new Thread(this.this$0.group, this.val$command, tname);
                }
            }), this.acc);
        }
    }

    static class DelegatedCallable
    implements Callable {
        final Callable callable;
        final AccessControlContext acc;
        final ThreadContext tc;

        public DelegatedCallable(Callable callable, ThreadContext tc) {
            this.callable = callable;
            this.acc = AccessController.getContext();
            this.tc = tc;
        }

        public Object call() throws Exception {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                    private final /* synthetic */ DelegatedCallable this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() throws Exception {
                        return this.this$0.tc.perform(this.this$0.callable);
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }

        public String toString() {
            return this.callable.toString();
        }
    }

    static class DelegatedRunnable
    implements Runnable {
        final Runnable runnable;
        final AccessControlContext acc;
        final PrivilegedAction tcWrappedAction;

        public DelegatedRunnable(Runnable runnable, ThreadContext tc) {
            this.runnable = runnable;
            this.acc = AccessController.getContext();
            this.tcWrappedAction = tc.wrap(new PrivilegedAction(this, runnable){
                private final /* synthetic */ Runnable val$runnable;
                private final /* synthetic */ DelegatedRunnable this$0;
                {
                    this.this$0 = this$0;
                    this.val$runnable = val$runnable;
                }

                public Object run() {
                    this.val$runnable.run();
                    return null;
                }
            });
        }

        public void run() {
            AccessController.doPrivileged(this.tcWrappedAction, this.acc);
        }

        public String toString() {
            return this.runnable.toString();
        }
    }
}

