/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;

public class ThreadSerializingExecutor
implements Executor {
    final Executor pool;
    final ThreadLocal queue = new ThreadLocal(){

        protected Object initialValue() {
            return new TaskQueue();
        }
    };

    public ThreadSerializingExecutor(Executor pool) {
        this.pool = pool;
    }

    public void execute(Runnable runnable) {
        TaskQueue tlqueue = (TaskQueue)this.queue.get();
        Runnable task = tlqueue.put(runnable);
        if (task != null) {
            this.pool.execute(task);
        }
    }

    private static class TaskQueue {
        Node last;

        private TaskQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable put(Runnable runnable) {
            Node node = new Node(runnable);
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                Node prevlast = this.last;
                this.last = node;
                if (prevlast != null) {
                    prevlast.next = node;
                    return null;
                }
                return new Runnable(this, node){
                    private final /* synthetic */ Node val$node;
                    private final /* synthetic */ TaskQueue this$0;
                    {
                        this.this$0 = this$0;
                        this.val$node = val$node;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Node current = this.val$node;
                        while (true) {
                            current.runnable.run();
                            TaskQueue taskQueue = this.this$0;
                            synchronized (taskQueue) {
                                current = current.next;
                                if (current == null) {
                                    this.this$0.last = null;
                                    return;
                                }
                            }
                        }
                    }
                };
            }
        }

        private final class Node {
            final Runnable runnable;
            Node next;

            Node(Runnable runnable) {
                this.runnable = runnable;
            }
        }
    }
}

