/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.gc;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReferenceCleaner {
    private static final Logger logger = Logger.getLogger("edu.emory.mathcs.util.gc.ReferenceCleaner");
    private static final String logID = "ReferenceCleaner: ";
    private final ReferenceQueue queue;
    private final Executor engineExecutor;
    CleanupTask currentCleaner;

    public ReferenceCleaner() {
        this(Executors.privilegedThreadFactory());
    }

    public ReferenceCleaner(ThreadFactory engineThreadFactory) {
        this(new ReferenceQueue(), engineThreadFactory);
    }

    public ReferenceCleaner(Executor engineExecutor) {
        this(new ReferenceQueue(), engineExecutor);
    }

    public ReferenceCleaner(ReferenceQueue queue, ThreadFactory engineThreadFactory) {
        this(queue, ReferenceCleaner.createSingleTaskExecutor(engineThreadFactory));
    }

    public ReferenceCleaner(ReferenceQueue queue, Executor engineExecutor) {
        this.queue = queue;
        this.engineExecutor = engineExecutor;
    }

    public ReferenceQueue getQueue() {
        return this.queue;
    }

    public void cleanNow() {
        Reference ref;
        while ((ref = this.queue.poll()) != null) {
            if (!(ref instanceof CleanableReference)) continue;
            ((CleanableReference)((Object)ref)).cleanReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        CleanupTask newCleaner;
        ReferenceCleaner referenceCleaner = this;
        synchronized (referenceCleaner) {
            if (this.currentCleaner != null) {
                throw new IllegalStateException();
            }
            this.currentCleaner = newCleaner = new CleanupTask();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ReferenceCleaner: starting cleaner");
        }
        this.engineExecutor.execute(newCleaner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ReferenceCleaner referenceCleaner = this;
        synchronized (referenceCleaner) {
            if (this.currentCleaner != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("ReferenceCleaner: stopping cleaner");
                }
                this.currentCleaner.stop();
                this.currentCleaner = null;
            }
        }
    }

    private void runLoop(CleanupTask task) {
        block6: {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("ReferenceCleaner: cleaner started");
                }
                while (!task.stopped) {
                    Reference ref = this.queue.remove();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("ReferenceCleaner: dequeued reference: " + ref);
                    }
                    if (!(ref instanceof CleanableReference)) continue;
                    ((CleanableReference)((Object)ref)).cleanReference();
                }
            }
            catch (InterruptedException e) {
                if (task.stopped) break block6;
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("ReferenceCleaner: cleaner stopped");
        }
    }

    private static Executor createSingleTaskExecutor(ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.NANOSECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static interface CleanableReference {
        public void cleanReference();
    }

    private class CleanupTask
    implements Runnable {
        volatile boolean stopped;
        Thread runner;

        private CleanupTask() {
        }

        synchronized void stop() {
            this.stopped = true;
            if (this.runner != null) {
                this.runner.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CleanupTask cleanupTask = this;
            synchronized (cleanupTask) {
                if (this.stopped) {
                    return;
                }
                this.runner = Thread.currentThread();
            }
            ReferenceCleaner.this.runLoop(this);
        }
    }
}

