/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.StringReader;

public class Base64Decoder
extends InputStream {
    final Reader in;
    private char[] auxCharBuf = new char[4];
    private byte[] triplet = new byte[3];
    int tripletLen = 0;
    int tripletIdx = 0;
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public Base64Decoder(Reader in) {
        this.in = in;
    }

    private int readTriplet(byte[] dest, int off) throws IOException {
        char[] ch = this.auxCharBuf;
        int len = this.in.read(ch);
        if (len < 0) {
            return 0;
        }
        if (len < 4) {
            throw new StreamCorruptedException("Base64 stream abruptly terminated");
        }
        int ch0 = ch[0];
        int ch1 = ch[1];
        int ch2 = ch[2];
        int ch3 = ch[3];
        ch0 = Base64Decoder.base64toInt(ch0);
        ch1 = Base64Decoder.base64toInt(ch1);
        dest[off++] = (byte)(ch0 << 2 | ch1 >> 4);
        if (ch2 == 61) {
            if (ch3 != 61) {
                throw new StreamCorruptedException("Expected '='");
            }
            return 1;
        }
        ch2 = Base64Decoder.base64toInt(ch2);
        dest[off++] = (byte)(ch1 << 4 | ch2 >> 2);
        if (ch3 == 61) {
            return 2;
        }
        ch3 = Base64Decoder.base64toInt(ch3);
        dest[off++] = (byte)(ch2 << 6 | ch3);
        return 3;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int newoff = off;
        int maxoff = off + len;
        if (this.tripletIdx > 0) {
            while (this.tripletIdx < this.tripletLen && newoff < maxoff) {
                buf[newoff++] = this.triplet[this.tripletIdx++];
            }
            if (this.tripletIdx < this.tripletLen) {
                return newoff - off;
            }
            if (this.tripletLen < 3) {
                return newoff - off > 0 ? newoff - off : -1;
            }
            this.tripletIdx = 0;
        }
        while (newoff + 3 <= maxoff) {
            int read = this.readTriplet(buf, newoff);
            newoff += read;
            if (read >= 3) continue;
            return newoff - off > 0 ? newoff - off : -1;
        }
        if (newoff == maxoff) {
            return newoff - off;
        }
        this.tripletLen = this.readTriplet(this.triplet, 0);
        while (this.tripletIdx < this.tripletLen && newoff < maxoff) {
            buf[newoff++] = this.triplet[this.tripletIdx++];
        }
        return newoff - off > 0 ? newoff - off : -1;
    }

    public int read() throws IOException {
        if (this.tripletIdx > 0) {
            if (this.tripletIdx < this.tripletLen) {
                byte b = this.triplet[this.tripletIdx++];
                return b;
            }
            if (this.tripletLen < 3) {
                return -1;
            }
            this.tripletIdx = 0;
        }
        this.tripletLen = this.readTriplet(this.triplet, 0);
        if (this.tripletLen == 0) {
            return -1;
        }
        return this.triplet[this.tripletIdx++];
    }

    public void close() throws IOException {
        this.in.close();
    }

    public static byte[] decode(String base64encoded) throws IllegalArgumentException {
        int expectedLen = Base64Decoder.getDecodedArrayLength(base64encoded);
        byte[] result = new byte[expectedLen];
        Base64Decoder.decode(base64encoded, result, 0, expectedLen);
        return result;
    }

    public static void decode(String base64encoded, byte[] buf) throws IllegalArgumentException {
        Base64Decoder.decode(base64encoded, buf, 0);
    }

    public static void decode(String base64encoded, byte[] buf, int off) {
        Base64Decoder.decode(base64encoded, buf, off, Base64Decoder.getDecodedArrayLength(base64encoded));
    }

    private static void decode(String base64encoded, byte[] buf, int off, int expectedLen) throws IllegalArgumentException {
        StringReader sr = new StringReader(base64encoded);
        Base64Decoder dec = new Base64Decoder(sr);
        int len = expectedLen;
        try {
            while (len > 0) {
                int read = dec.read(buf, off, len);
                if (read < 0) {
                    throw new IllegalArgumentException("Encoded array prematurely ended");
                }
                len -= read;
                off += read;
            }
        }
        catch (StreamCorruptedException e) {
            throw new IllegalArgumentException(base64encoded);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private static int getDecodedArrayLength(String base64encoded) throws IllegalArgumentException {
        int slen = base64encoded.length();
        int groups = slen / 4;
        if (4 * groups != slen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int blen = 3 * groups;
        if (slen != 0) {
            if (base64encoded.charAt(slen - 1) == '=') {
                --blen;
            }
            if (base64encoded.charAt(slen - 2) == '=') {
                --blen;
            }
        }
        return blen;
    }

    private static int base64toInt(int c) throws IOException {
        byte result = base64ToInt[c];
        if (result < 0) {
            throw new StreamCorruptedException("Illegal character " + (char)c);
        }
        return result;
    }
}

