/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class Base64Encoder
extends OutputStream {
    final Writer out;
    int pendingBytes = 0;
    byte[] fragBuf = new byte[3];
    volatile boolean closed = false;
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64Encoder(Writer out) {
        this.out = out;
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        int max = off + len;
        this.ensureOpened();
        if (this.pendingBytes > 0) {
            while (off < max && this.pendingBytes < 3) {
                this.fragBuf[this.pendingBytes++] = buf[off++];
            }
            if (this.pendingBytes < 3) {
                return;
            }
            this.writeBase64(this.fragBuf, 0, 3);
            this.pendingBytes = 0;
        }
        while (off + 3 <= max) {
            this.writeBase64(buf, off, 3);
            off += 3;
        }
        while (off < max) {
            this.fragBuf[this.pendingBytes++] = buf[off++];
        }
    }

    public void write(int v) throws IOException {
        this.ensureOpened();
        this.fragBuf[this.pendingBytes++] = (byte)v;
        if (this.pendingBytes == 3) {
            this.writeBase64(this.fragBuf, 0, 3);
            this.pendingBytes = 0;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.pendingBytes > 0) {
            this.writeBase64(this.fragBuf, 0, this.pendingBytes);
        }
        this.out.flush();
        this.out.close();
    }

    private void ensureOpened() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private void writeBase64(byte[] b, int off, int len) throws IOException {
        if (len == 3) {
            this.out.write(intToBase64[(b[off + 0] & 0xFF) >> 2]);
            this.out.write(intToBase64[(b[off + 0] & 0xFF) << 4 & 0x3F | (b[off + 1] & 0xFF) >> 4]);
            this.out.write(intToBase64[(b[off + 1] & 0xFF) << 2 & 0x3F | (b[off + 2] & 0xFF) >> 6]);
            this.out.write(intToBase64[b[off + 2] & 0x3F]);
        } else if (len == 2) {
            this.out.write(intToBase64[(b[off + 0] & 0xFF) >> 2]);
            this.out.write(intToBase64[(b[off + 0] & 0xFF) << 4 & 0x3F | (b[off + 1] & 0xFF) >> 4]);
            this.out.write(intToBase64[(b[off + 1] & 0xFF) << 2 & 0x3F]);
            this.out.write(61);
        } else if (len == 1) {
            this.out.write(intToBase64[(b[off + 0] & 0xFF) >> 2]);
            this.out.write(intToBase64[(b[off + 0] & 0xFF) << 4 & 0x3F]);
            this.out.write("==");
        }
    }

    public static String encode(byte[] buf) {
        return Base64Encoder.encode(buf, 0, buf.length);
    }

    public static String encode(byte[] buf, int off, int len) {
        StringWriter sw = new StringWriter(buf.length * 4 / 3 + 2);
        Base64Encoder enc = new Base64Encoder(sw);
        try {
            enc.write(buf, off, len);
            enc.flush();
            enc.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.getBuffer().toString();
    }
}

