/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CompressedInputStream
extends FilterInputStream {
    static final short DEFLATED = Short.MIN_VALUE;
    static final short STORED = 0;
    final byte[] buf;
    final DataInputStream din;
    final Inflater inflater;
    boolean deflated = false;
    int pending = 0;

    public CompressedInputStream(InputStream in) {
        this(in, 8192);
    }

    public CompressedInputStream(InputStream in, int bufSize) {
        super(in);
        this.buf = new byte[bufSize];
        this.inflater = new Inflater(true);
        this.din = new DataInputStream(in);
    }

    public synchronized int read() throws IOException {
        byte[] tmp = new byte[1];
        int read = this.read(tmp);
        if (read < 0) {
            return -1;
        }
        return tmp[0];
    }

    public synchronized int read(byte[] dest, int off, int len) throws IOException {
        int read;
        int todo;
        while (true) {
            if (this.deflated) {
                try {
                    int inflated = this.inflater.inflate(dest, off, len);
                    if (inflated > 0) {
                        return inflated;
                    }
                }
                catch (DataFormatException e) {
                    throw new IOException(e.toString());
                }
                if (this.pending == 0 || this.inflater.finished()) {
                    if (this.pending > 0) {
                        throw new IOException("Premature end of compressed data block");
                    }
                    if (!this.newPacket()) {
                        return -1;
                    }
                    if (!this.deflated) continue;
                }
                if (this.inflater.needsInput()) {
                    todo = Math.min(this.buf.length, this.pending);
                    read = this.in.read(this.buf, 0, todo);
                    if (read < 0) {
                        throw new EOFException("Unexpected EOF");
                    }
                    this.pending -= read;
                    this.inflater.setInput(this.buf, 0, read);
                    continue;
                }
                throw new RuntimeException();
            }
            if (this.pending != 0) break;
            if (!this.newPacket()) {
                return -1;
            }
            if (!this.deflated) break;
        }
        if ((read = this.in.read(dest, off, todo = Math.min(this.pending, len))) < 0) {
            throw new EOFException("Unexpected EOF");
        }
        this.pending -= read;
        return read;
    }

    private boolean newPacket() throws IOException {
        short header;
        try {
            header = this.din.readShort();
        }
        catch (EOFException e) {
            return false;
        }
        this.deflated = (header & Short.MIN_VALUE) == Short.MIN_VALUE;
        this.pending = header & Short.MAX_VALUE;
        if (this.pending <= 0) {
            throw new IOException("Bogus packet length");
        }
        if (this.deflated) {
            this.inflater.reset();
        }
        return true;
    }
}

