/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class ForkOutputStream
extends OutputStream {
    private final OutputStream[] outs;

    public ForkOutputStream(OutputStream out1, OutputStream out2) {
        this(new OutputStream[]{out1, out2});
    }

    public ForkOutputStream(OutputStream out1, OutputStream out2, OutputStream out3) {
        this(new OutputStream[]{out1, out2, out3});
    }

    public ForkOutputStream(OutputStream[] outs) {
        LinkedHashSet<OutputStream> outset = new LinkedHashSet<OutputStream>(Arrays.asList(outs));
        this.outs = outset.toArray(new OutputStream[outset.size()]);
    }

    public void write(byte[] buf) throws IOException {
        IOException ioe = null;
        for (int i = 0; i < this.outs.length; ++i) {
            OutputStream out = this.outs[i];
            if (out == null) continue;
            try {
                out.write(buf);
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        IOException ioe = null;
        for (int i = 0; i < this.outs.length; ++i) {
            OutputStream out = this.outs[i];
            if (out == null) continue;
            try {
                out.write(buf, off, len);
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void write(int b) throws IOException {
        IOException ioe = null;
        for (int i = 0; i < this.outs.length; ++i) {
            OutputStream out = this.outs[i];
            if (out == null) continue;
            try {
                out.write(b);
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void flush() throws IOException {
        IOException ioe = null;
        for (int i = 0; i < this.outs.length; ++i) {
            OutputStream out = this.outs[i];
            if (out == null) continue;
            try {
                out.flush();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void close() throws IOException {
        IOException ioe = null;
        for (int i = 0; i < this.outs.length; ++i) {
            OutputStream out = this.outs[i];
            if (out == null) continue;
            try {
                out.close();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

