/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import edu.emory.mathcs.util.io.RedirectibleInput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RedirectingInputStream
extends FilterInputStream
implements RedirectibleInput {
    final byte[] buf;
    final boolean autoFlush;
    final boolean autoClose;

    public RedirectingInputStream(InputStream in) {
        this(in, 2048);
    }

    public RedirectingInputStream(InputStream in, int buflen) {
        this(in, true, false, buflen);
    }

    public RedirectingInputStream(InputStream in, boolean autoFlush, boolean autoClose) {
        this(in, autoFlush, autoClose, 2048);
    }

    public RedirectingInputStream(InputStream in, boolean autoFlush, boolean autoClose, int buflen) {
        super(in);
        this.autoFlush = autoFlush;
        this.autoClose = autoClose;
        this.buf = new byte[buflen];
    }

    public int redirect(OutputStream out, int len) throws IOException {
        int read = this.read(this.buf);
        if (read < 0) {
            if (this.autoClose) {
                out.close();
            }
        } else {
            out.write(this.buf, 0, read);
            if (this.autoFlush) {
                out.flush();
            }
        }
        return read;
    }

    public int redirectAll(OutputStream out) throws IOException {
        int total = 0;
        while (true) {
            int read;
            if ((read = this.read(this.buf)) < 0) {
                if (this.autoClose) {
                    out.close();
                }
                return total;
            }
            out.write(this.buf, 0, read);
            if (this.autoFlush) {
                out.flush();
            }
            total += read;
        }
    }
}

