/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ThreadSafeBufferedInputStream
extends BufferedInputStream {
    final boolean tainted;

    public ThreadSafeBufferedInputStream(InputStream in) {
        super(in);
        this.tainted = in.getClass() == BufferedInputStream.class;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (this.tainted) {
            try {
                return super.read(buf, off, len);
            }
            catch (NullPointerException e) {
                throw new IOException("Stream closed");
            }
        }
        return super.read(buf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.in.close();
        ThreadSafeBufferedInputStream threadSafeBufferedInputStream = this;
        synchronized (threadSafeBufferedInputStream) {
            super.close();
        }
    }
}

