/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.natives;

import edu.emory.mathcs.util.io.NullInputStream;
import edu.emory.mathcs.util.io.RedirectingInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecUtils {
    private ExecUtils() {
    }

    public static CmdResult execCommand(String cmd) throws IOException, InterruptedException {
        return ExecUtils.execCommand(Runtime.getRuntime().exec(cmd));
    }

    public static CmdResult execCommand(Process process) throws IOException, InterruptedException {
        return ExecUtils.execCommand(process, new NullInputStream());
    }

    public static CmdResult execCommand(Process process, InputStream stdin) throws IOException, InterruptedException {
        Redir stdout = new Redir(process.getInputStream());
        Redir stderr = new Redir(process.getErrorStream());
        new Thread(stdout).start();
        new Thread(stderr).start();
        if (stdin != null) {
            OutputStream pout = process.getOutputStream();
            new RedirectingInputStream(stdin, true, true).redirectAll(pout);
        }
        process.waitFor();
        int exitValue = process.exitValue();
        stdout.throwIfHadException();
        stderr.throwIfHadException();
        String out = new String(stdout.getResult());
        String err = new String(stderr.getResult());
        return new CmdResult(exitValue, out, err);
    }

    public static void handleProcess(Process process, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        ExecUtils.handleProcess(process, stdin, stdout, stderr, true, false, null, null);
    }

    public static void handleProcess(Process process, InputStream stdin, OutputStream stdout, OutputStream stderr, boolean autoFlush, boolean autoClose, BrokenPipeHandler brokenPipeHandler, ProcessExitHandler exitHandler) throws IOException {
        ExecUtils.handleProcess(process, stdin, autoFlush, autoClose, brokenPipeHandler, stdout, autoFlush, autoClose, brokenPipeHandler, stderr, autoFlush, autoClose, brokenPipeHandler, exitHandler);
    }

    public static void handleProcess(Process process, InputStream stdin, boolean inAutoFlush, boolean inAutoClose, BrokenPipeHandler inBrokenHandler, OutputStream stdout, boolean outAutoFlush, boolean outAutoClose, BrokenPipeHandler outBrokenHandler, OutputStream stderr, boolean errAutoFlush, boolean errAutoClose, BrokenPipeHandler errBrokenHandler, ProcessExitHandler exitHandler) throws IOException {
        ProcessHandler ph = new ProcessHandler(process, stdin, inAutoFlush, inAutoClose, inBrokenHandler, stdout, outAutoFlush, outAutoClose, outBrokenHandler, stderr, errAutoFlush, errAutoClose, errBrokenHandler, exitHandler);
        ph.start();
    }

    private static class ProcessHandler {
        final Process process;
        final Thread tstdin;
        final Thread tstdout;
        final Thread tstderr;
        final Thread texitHandler;

        ProcessHandler(Process process, InputStream stdin, boolean inAutoFlush, boolean inAutoClose, BrokenPipeHandler inBrokenHandler, OutputStream stdout, boolean outAutoFlush, boolean outAutoClose, BrokenPipeHandler outBrokenHandler, OutputStream stderr, boolean errAutoFlush, boolean errAutoClose, BrokenPipeHandler errBrokenHandler, ProcessExitHandler exitHandler) throws IOException {
            this.process = process;
            this.tstdin = ProcessHandler.createPipe(stdin, process.getOutputStream(), inBrokenHandler, inAutoFlush, inAutoClose);
            this.tstdout = ProcessHandler.createPipe(process.getInputStream(), stdout, outBrokenHandler, outAutoFlush, outAutoClose);
            this.tstderr = ProcessHandler.createPipe(process.getErrorStream(), stderr, errBrokenHandler, errAutoFlush, errAutoClose);
            this.texitHandler = exitHandler != null ? new Thread(new ExitHandler(process, exitHandler)) : null;
        }

        void start() {
            if (this.tstdin != null) {
                this.tstdin.start();
            }
            if (this.tstdout != null) {
                this.tstdout.start();
            }
            if (this.tstderr != null) {
                this.tstderr.start();
            }
            if (this.texitHandler != null) {
                this.texitHandler.start();
            }
        }

        private static Thread createPipe(InputStream src, OutputStream sink, BrokenPipeHandler bph, boolean autoFlush, boolean autoClose) throws IOException {
            if (src == null) {
                if (sink != null && autoClose) {
                    sink.close();
                }
                return null;
            }
            if (sink == null) {
                if (autoClose) {
                    src.close();
                }
                return null;
            }
            return new Thread(new Pipe(src, sink, bph, autoFlush, autoClose));
        }

        private static class ExitHandler
        implements Runnable {
            final Process process;
            final ProcessExitHandler exitHandler;

            ExitHandler(Process process, ProcessExitHandler exitHandler) {
                this.process = process;
                this.exitHandler = exitHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.process.destroy();
                    this.exitHandler.processExited(this.process);
                }
            }
        }
    }

    private static class Redir
    implements Runnable {
        final Pipe pipe;
        IOException ex;

        Redir(InputStream is) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BrokenPipeHandler bph = new BrokenPipeHandler(this){
                private final /* synthetic */ Redir this$0;
                {
                    this.this$0 = this$0;
                }

                public void brokenPipe(IOException ex, InputStream src, OutputStream sink) {
                    this.this$0.setException(ex);
                }
            };
            this.pipe = new Pipe(is, bos, bph, true, true);
        }

        public void run() {
            this.pipe.run();
        }

        synchronized void setException(IOException e) {
            this.ex = e;
        }

        synchronized void throwIfHadException() throws IOException {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        public byte[] getResult() {
            return ((ByteArrayOutputStream)this.pipe.sink).toByteArray();
        }
    }

    private static class Pipe
    implements Runnable {
        final InputStream src;
        final OutputStream sink;
        final boolean autoFlush;
        final boolean autoClose;
        final BrokenPipeHandler brokenPipeHandler;

        public Pipe(InputStream src, OutputStream sink, BrokenPipeHandler brokenPipeHandler) {
            this(src, sink, brokenPipeHandler, true, false);
        }

        public Pipe(InputStream src, OutputStream sink, BrokenPipeHandler brokenPipeHandler, boolean autoFlush, boolean autoClose) {
            this.src = src;
            this.sink = sink;
            this.brokenPipeHandler = brokenPipeHandler;
            this.autoFlush = autoFlush;
            this.autoClose = autoClose;
        }

        public void run() {
            block2: {
                RedirectingInputStream sd = new RedirectingInputStream(this.src, this.autoFlush, this.autoClose);
                try {
                    sd.redirectAll(this.sink);
                }
                catch (IOException e) {
                    if (this.brokenPipeHandler == null) break block2;
                    this.brokenPipeHandler.brokenPipe(e, this.src, this.sink);
                }
            }
        }
    }

    public static class CmdResult {
        final int exitValue;
        final String out;
        final String err;

        CmdResult(int exitValue, String out, String err) {
            this.exitValue = exitValue;
            this.out = out;
            this.err = err;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public String getOut() {
            return this.out;
        }

        public String getErr() {
            return this.err;
        }
    }

    public static interface ProcessExitHandler {
        public void processExited(Process var1);
    }

    public static interface BrokenPipeHandler {
        public void brokenPipe(IOException var1, InputStream var2, OutputStream var3);
    }
}

