/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net;

import edu.emory.mathcs.util.net.ConnectionPool;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Connection {
    static final byte USED = -1;
    static final byte CLOSED = 0;
    static final byte READY = 1;
    static final Reaper reaper = new Reaper();
    final ConnectionPool pool;
    final Socket socket;
    long expires = -1L;

    Connection(Socket socket, ConnectionPool pool) {
        this.socket = socket;
        this.pool = pool;
    }

    public void returnToPool() {
        this.release(System.currentTimeMillis() + this.pool.expirationTimeout);
        reaper.registerConnection(this, this.pool.expirationTimeout);
        this.pool.notifyConnectionStateChanged();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pool.notifyConnectionStateChanged();
    }

    public synchronized Socket getSocket() {
        return this.socket;
    }

    synchronized byte acquire() {
        if (this.socket.isClosed()) {
            return 0;
        }
        if (this.expires == -1L) {
            return -1;
        }
        this.expires = -1L;
        return 1;
    }

    synchronized void release(long closeTime) {
        if (this.socket.isClosed()) {
            return;
        }
        if (this.expires != -1L) {
            throw new IllegalStateException("Not currently used");
        }
        this.expires = closeTime;
    }

    synchronized long getCloseTime() {
        return this.expires;
    }

    synchronized boolean isClosed() {
        return this.socket.isClosed();
    }

    synchronized boolean isUsed() {
        return this.expires == -1L;
    }

    static class Reaper {
        private final HashSet connections = new HashSet();
        private final Reap reap = new Reap();
        private volatile long sleepTime = Long.MAX_VALUE;
        private Thread thread;

        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerConnection(Connection conn, long closeDelay) {
            if (conn.isClosed()) {
                return;
            }
            Reaper reaper = this;
            synchronized (reaper) {
                this.connections.add(conn);
                if (closeDelay < this.sleepTime) {
                    this.sleepTime = closeDelay;
                }
                if (this.thread == null) {
                    this.thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ Reaper this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Object run() {
                            Thread thread = new Thread((Runnable)Reaper.access$300(this.this$0), "Reaper");
                            thread.setDaemon(true);
                            thread.start();
                            return thread;
                        }
                    });
                }
            }
        }

        static /* synthetic */ Reap access$300(Reaper x0) {
            return x0.reap;
        }

        class Reap
        implements Runnable {
            Reap() {
            }

            public void run() {
                do {
                    try {
                        Thread.sleep(Reaper.this.sleepTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.doReap());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean doReap() {
                boolean result = true;
                long currentTime = System.currentTimeMillis();
                ArrayList<Connection> connToClose = new ArrayList<Connection>();
                Reaper reaper = Reaper.this;
                synchronized (reaper) {
                    Iterator iter = Reaper.this.connections.iterator();
                    while (iter.hasNext()) {
                        Connection conn = (Connection)iter.next();
                        if (conn.getCloseTime() > currentTime) continue;
                        switch (conn.acquire()) {
                            case -1: 
                            case 0: {
                                break;
                            }
                            case 1: {
                                connToClose.add(conn);
                            }
                        }
                        iter.remove();
                    }
                    if (Reaper.this.connections.isEmpty()) {
                        Reaper.this.thread = null;
                        result = false;
                    }
                }
                Iterator iter = connToClose.iterator();
                while (iter.hasNext()) {
                    Connection conn = (Connection)iter.next();
                    conn.close();
                }
                return result;
            }
        }
    }
}

