/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;

public abstract class SocketWrapper
extends Socket {
    protected final Socket delegate;

    protected SocketWrapper(Socket delegate) throws SocketException {
        super(new WrappingSocketImpl(delegate));
        this.delegate = delegate;
    }

    public SocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return super.isClosed() || this.delegate.isClosed();
    }

    public boolean isConnected() {
        return true;
    }

    public boolean isInputShutdown() {
        return super.isInputShutdown() || this.delegate.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return super.isInputShutdown() || this.delegate.isOutputShutdown();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SocketWrapper)) {
            return false;
        }
        SocketWrapper that = (SocketWrapper)obj;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ 0x1010101;
    }

    private static class WrappingSocketImpl
    extends SocketImpl {
        private final Socket delegate;

        WrappingSocketImpl(Socket delegate) throws SocketException {
            if (delegate == null) {
                throw new NullPointerException();
            }
            if (delegate.isClosed()) {
                throw new SocketException("Delegate server socket is closed");
            }
            if (!delegate.isBound()) {
                throw new SocketException("Delegate server socket is not bound");
            }
            if (!delegate.isConnected()) {
                throw new SocketException("Delegate server socket is not connected");
            }
            this.delegate = delegate;
        }

        protected void create(boolean stream) {
        }

        protected void connect(String host, int port) {
            throw new UnsupportedOperationException();
        }

        protected void connect(InetAddress address, int port) {
            throw new UnsupportedOperationException();
        }

        protected void connect(SocketAddress address, int timeout) {
            throw new UnsupportedOperationException();
        }

        protected void bind(InetAddress host, int port) {
            throw new UnsupportedOperationException();
        }

        protected void listen(int backlog) {
            throw new UnsupportedOperationException();
        }

        protected void accept(SocketImpl s) {
            throw new UnsupportedOperationException();
        }

        protected InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        protected OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        protected int available() throws IOException {
            return this.getInputStream().available();
        }

        protected void close() throws IOException {
            this.delegate.close();
        }

        protected void shutdownInput() throws IOException {
            this.delegate.shutdownInput();
        }

        protected void shutdownOutput() throws IOException {
            this.delegate.shutdownOutput();
        }

        protected FileDescriptor getFileDescriptor() {
            throw new UnsupportedOperationException();
        }

        protected InetAddress getInetAddress() {
            return this.delegate.getInetAddress();
        }

        protected int getPort() {
            return this.delegate.getPort();
        }

        protected boolean supportsUrgentData() {
            return false;
        }

        protected void sendUrgentData(int data) throws IOException {
            this.delegate.sendUrgentData(data);
        }

        protected int getLocalPort() {
            return this.delegate.getLocalPort();
        }

        public Object getOption(int optID) throws SocketException {
            switch (optID) {
                case 3: {
                    return new Integer(this.delegate.getTrafficClass());
                }
                case 15: {
                    return this.delegate.getLocalAddress();
                }
                case 8: {
                    return this.delegate.getKeepAlive();
                }
                case 128: {
                    return new Integer(this.delegate.getSoLinger());
                }
                case 4099: {
                    return this.delegate.getOOBInline();
                }
                case 4098: {
                    return new Integer(this.delegate.getReceiveBufferSize());
                }
                case 4: {
                    return this.delegate.getReuseAddress();
                }
                case 4097: {
                    return new Integer(this.delegate.getSendBufferSize());
                }
                case 4102: {
                    return new Integer(this.delegate.getSoTimeout());
                }
                case 1: {
                    return this.delegate.getTcpNoDelay();
                }
            }
            throw new IllegalArgumentException("Unsupported option type");
        }

        public void setOption(int optID, Object value) throws SocketException {
            switch (optID) {
                case 15: {
                    throw new IllegalArgumentException("Socket is bound");
                }
                case 8: {
                    this.delegate.setKeepAlive((Boolean)value);
                    break;
                }
                case 128: {
                    if (value instanceof Boolean) {
                        this.delegate.setSoLinger((Boolean)value, 0);
                        break;
                    }
                    this.delegate.setSoLinger(true, (Integer)value);
                    break;
                }
                case 4099: {
                    this.delegate.setOOBInline((Boolean)value);
                    break;
                }
                case 4098: {
                    this.delegate.setReceiveBufferSize((Integer)value);
                    break;
                }
                case 4: {
                    this.delegate.setReuseAddress((Boolean)value);
                    break;
                }
                case 4097: {
                    this.delegate.setSendBufferSize((Integer)value);
                    break;
                }
                case 4102: {
                    this.delegate.setSoTimeout((Integer)value);
                    break;
                }
                case 1: {
                    this.delegate.setTcpNoDelay((Boolean)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported option type");
                }
            }
        }
    }
}

