/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.inproc;

import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.util.io.TimedInput;
import edu.emory.mathcs.util.net.inproc.InProcServerSocket;
import edu.emory.mathcs.util.net.inproc.InProcSocketAddress;
import java.io.FileDescriptor;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class InProcSocket
extends Socket {
    static final InProcSocket CONNECT_CANCELLED = new InProcSocket(false);
    static final InetAddress inprocInetAddr;
    int remotePort;
    int localPort;
    volatile int soTimeout;
    volatile boolean closed;
    volatile boolean connected;
    volatile boolean inputShut;
    volatile boolean outputShut;
    volatile boolean inputClosed;
    volatile boolean outputClosed;
    boolean connecting;
    InputStream in;
    OutputStream out;

    public InProcSocket(int port) throws IOException {
        this();
        this.connect(new InProcSocketAddress(port));
    }

    public InProcSocket() throws SocketException {
        super(new InProcSocketImpl());
    }

    private InProcSocket(boolean dummy) {
    }

    InProcSocket(Channel channel, int localPort) {
        this.localPort = localPort;
        this.setChannel(channel);
    }

    private synchronized void setChannel(Channel ch) {
        this.in = new InProcSocketInputStream(ch.getInput());
        this.out = new InProcSocketOutputStream(ch.getOutput());
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        InProcSocket inProcSocket;
        if (!(endpoint instanceof InProcSocketAddress)) {
            throw new IllegalArgumentException("connect: The address must be an instance of InProcSocketAddress");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        InProcSocketAddress addr = (InProcSocketAddress)endpoint;
        InProcSocket inProcSocket2 = this;
        synchronized (inProcSocket2) {
            if (this.connecting) {
                throw new IOException("Connect already in progress");
            }
            this.connecting = true;
        }
        try {
            try {
                Channel channel = InProcServerSocket.connect(addr.port, timeout);
                this.setChannel(channel);
            }
            catch (IOException e) {
                this.close();
                Object var7_7 = null;
                InProcSocket inProcSocket3 = this;
                synchronized (inProcSocket3) {
                    this.connecting = false;
                    return;
                }
            }
            Object var7_6 = null;
            inProcSocket = this;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            InProcSocket inProcSocket4 = this;
            synchronized (inProcSocket4) {
                this.connecting = false;
                throw throwable;
            }
        }
        synchronized (inProcSocket) {
            this.connecting = false;
            return;
        }
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.ensureNotClosed();
        throw new UnsupportedOperationException();
    }

    public InetAddress getInetAddress() {
        return inprocInetAddr;
    }

    public InetAddress getLocalAddress() {
        return inprocInetAddr;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.remotePort;
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.localPort;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InProcSocketAddress(this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InProcSocketAddress(this.getLocalPort());
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.ensureNotClosed();
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.in;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.ensureNotClosed();
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.out;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.ensureNotClosed();
    }

    public boolean getTcpNoDelay() throws SocketException {
        this.ensureNotClosed();
        return true;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.ensureNotClosed();
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.ensureNotClosed();
    }

    public boolean getOOBInline() throws SocketException {
        this.ensureNotClosed();
        return false;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.soTimeout = timeout;
    }

    public synchronized int getSoTimeout() throws SocketException {
        this.ensureNotClosed();
        return this.soTimeout;
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        this.ensureNotClosed();
    }

    public int getSendBufferSize() throws SocketException {
        return Integer.MAX_VALUE;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        this.ensureNotClosed();
    }

    public int getReceiveBufferSize() throws SocketException {
        return Integer.MAX_VALUE;
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.ensureNotClosed();
    }

    public boolean getKeepAlive() throws SocketException {
        this.ensureNotClosed();
        return true;
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.ensureNotClosed();
    }

    public int getTrafficClass() throws SocketException {
        return 0;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.ensureNotClosed();
    }

    public boolean getReuseAddress() throws SocketException {
        this.ensureNotClosed();
        return true;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.isConnected()) {
            if (!this.isOutputShutdown()) {
                this.shutdownOutput();
            }
            if (!this.isInputShutdown()) {
                this.shutdownInput();
            }
        }
        this.closed = true;
    }

    public synchronized void shutdownInput() throws IOException {
        this.ensureNotClosed();
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.inputShut = true;
        this.closeInput();
    }

    private void closeInput() throws IOException {
        this.inputClosed = true;
        if (this.outputClosed) {
            this.close();
        }
    }

    public void shutdownOutput() throws IOException {
        this.ensureNotClosed();
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.outputShut = true;
        try {
            this.out.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeOutput();
    }

    private void closeOutput() throws IOException {
        this.outputClosed = true;
        if (this.inputClosed) {
            this.close();
        }
    }

    public String toString() {
        if (this.isConnected()) {
            return "Socket[port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isInputShutdown() {
        return this.inputShut;
    }

    public boolean isOutputShutdown() {
        return this.outputShut;
    }

    private void ensureNotClosed() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    static {
        try {
            inprocInetAddr = InetAddress.getByAddress("inproc.localhost", new byte[]{127, 0, 0, -127});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("FATAL:", e);
        }
    }

    private class InProcSocketOutputStream
    extends FilterOutputStream {
        InProcSocketOutputStream(OutputStream output) {
            super(output);
        }

        public void write(int b) throws IOException {
            try {
                super.write(b);
            }
            catch (IOException e) {
                InProcSocket.this.closeOutput();
            }
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            try {
                super.write(buf, off, len);
            }
            catch (IOException e) {
                InProcSocket.this.closeOutput();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                InProcSocket.this.close();
            }
        }
    }

    private class InProcSocketInputStream
    extends FilterInputStream {
        final TimedInput input;

        InProcSocketInputStream(TimedInput input) {
            super((InputStream)((Object)input));
            this.input = input;
        }

        /*
         * WARNING - void declaration
         */
        public int read() throws IOException {
            void var2_2;
            int val;
            if (InProcSocket.this.inputShut) {
                return -1;
            }
            int timeout = InProcSocket.this.soTimeout;
            if (timeout == 0) {
                val = this.input.read();
            } else {
                try {
                    val = this.input.timedRead(timeout);
                }
                catch (TimeoutException e) {
                    throw new SocketTimeoutException(e.getMessage());
                }
            }
            if (var2_2 < 0) {
                InProcSocket.this.closeInput();
            }
            return (int)var2_2;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        /*
         * WARNING - void declaration
         */
        public int read(byte[] buf, int off, int len) throws IOException {
            void var5_5;
            int read;
            if (InProcSocket.this.inputShut) {
                return -1;
            }
            int timeout = InProcSocket.this.soTimeout;
            if (timeout == 0) {
                read = this.input.read(buf, off, len);
            } else {
                try {
                    read = this.input.timedRead(buf, off, len, timeout);
                }
                catch (IOException e) {
                    InProcSocket.this.shutdownInput();
                    throw e;
                }
                catch (TimeoutException e) {
                    throw new SocketTimeoutException(e.getMessage());
                }
            }
            if (var5_5 < 0) {
                InProcSocket.this.closeInput();
            }
            return (int)var5_5;
        }

        public long skip(long n) throws IOException {
            if (InProcSocket.this.inputShut) {
                return -1L;
            }
            return super.skip(n);
        }

        public int available() throws IOException {
            if (InProcSocket.this.inputShut) {
                return 0;
            }
            return super.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                InProcSocket.this.close();
            }
        }
    }

    static class Channel {
        final TimedInput is;
        final OutputStream os;

        Channel(TimedInput is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        public TimedInput getInput() {
            return this.is;
        }

        public OutputStream getOutput() {
            return this.os;
        }
    }

    private static class InProcSocketImpl
    extends SocketImpl {
        InProcSocketImpl() {
        }

        protected void create(boolean stream) throws SocketException {
            throw new UnsupportedOperationException();
        }

        protected void connect(String host, int port) {
            throw new UnsupportedOperationException();
        }

        protected void connect(InetAddress address, int port) {
            throw new UnsupportedOperationException();
        }

        protected void connect(SocketAddress address, int timeout) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void bind(InetAddress host, int port) {
            throw new UnsupportedOperationException();
        }

        protected void listen(int backlog) {
            throw new UnsupportedOperationException();
        }

        protected void accept(SocketImpl s) {
            throw new UnsupportedOperationException();
        }

        protected InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected int available() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void close() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void shutdownInput() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void shutdownOutput() throws IOException {
            throw new UnsupportedOperationException();
        }

        protected FileDescriptor getFileDescriptor() {
            throw new UnsupportedOperationException();
        }

        protected InetAddress getInetAddress() {
            throw new UnsupportedOperationException();
        }

        protected int getPort() {
            throw new UnsupportedOperationException();
        }

        protected boolean supportsUrgentData() {
            throw new UnsupportedOperationException();
        }

        protected void sendUrgentData(int data) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected int getLocalPort() {
            throw new UnsupportedOperationException();
        }

        public Object getOption(int optID) throws SocketException {
            throw new UnsupportedOperationException();
        }

        public void setOption(int optID, Object value) throws SocketException {
            throw new UnsupportedOperationException();
        }
    }
}

