/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.ssl;

import edu.emory.mathcs.util.net.ssl.SSLSocketWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class SSLServerSocketWrapper
extends SSLServerSocket {
    final SSLServerSocket delegate;

    protected SSLServerSocketWrapper(SSLServerSocket delegate) throws IOException {
        if (delegate == null) {
            throw new NullPointerException();
        }
        if (delegate.isClosed()) {
            throw new SocketException("Delegate server socket is closed");
        }
        if (!delegate.isBound()) {
            throw new SocketException("Delegate server socket is not bound");
        }
        this.delegate = delegate;
    }

    protected SSLSocket wrapAcceptedSocket(SSLSocket accepted) throws SocketException {
        return new SSLSocketWrapper(accepted);
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public Socket accept() throws IOException {
        SSLSocket socket = (SSLSocket)this.delegate.accept();
        return this.wrapAcceptedSocket(socket);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public ServerSocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws IOException {
        return this.delegate.getSoTimeout();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.delegate.setEnabledProtocols(protocols);
    }

    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.delegate.setEnabledCipherSuites(enabledCipherSuites);
    }

    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    public void setWantClientAuth(boolean want) {
        this.delegate.setWantClientAuth(want);
    }

    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    public void setNeedClientAuth(boolean want) {
        this.delegate.setNeedClientAuth(want);
    }

    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    public void setUseClientMode(boolean clientMode) {
        this.delegate.setUseClientMode(clientMode);
    }

    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }

    public void setEnableSessionCreation(boolean enable) {
        this.delegate.setEnableSessionCreation(enable);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSLServerSocketWrapper)) {
            return false;
        }
        SSLServerSocketWrapper that = (SSLServerSocketWrapper)obj;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ 0x1010101;
    }
}

