/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class SSLSocketWrapper
extends SSLSocket {
    protected final SSLSocket delegate;

    protected SSLSocketWrapper(SSLSocket delegate) throws SocketException {
        if (delegate == null) {
            throw new NullPointerException();
        }
        if (delegate.isClosed()) {
            throw new SocketException("Delegate server socket is closed");
        }
        if (!delegate.isBound()) {
            throw new SocketException("Delegate server socket is not bound");
        }
        if (!delegate.isConnected()) {
            throw new SocketException("Delegate server socket is not connected");
        }
        this.delegate = delegate;
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.delegate.connect(endpoint);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.delegate.connect(endpoint, timeout);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.delegate.bind(bindpoint);
    }

    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    public SocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.delegate.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.delegate.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.delegate.setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        return this.delegate.getSoLinger();
    }

    public void sendUrgentData(int data) throws IOException {
        this.delegate.sendUrgentData(data);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.delegate.setOOBInline(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.delegate.getOOBInline();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.delegate.getSoTimeout();
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.delegate.setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.delegate.getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.delegate.setKeepAlive(on);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.delegate.getKeepAlive();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.delegate.setTrafficClass(tc);
    }

    public int getTrafficClass() throws SocketException {
        return this.delegate.getTrafficClass();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void shutdownInput() throws IOException {
        this.delegate.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
    }

    public boolean isConnected() {
        return true;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public boolean isInputShutdown() {
        return this.delegate.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.delegate.isOutputShutdown();
    }

    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.delegate.setEnabledCipherSuites(suites);
    }

    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.delegate.setEnabledProtocols(protocols);
    }

    public SSLSession getSession() {
        return this.delegate.getSession();
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.delegate.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.delegate.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void startHandshake() throws IOException {
        this.delegate.startHandshake();
    }

    public void setUseClientMode(boolean mode) {
        this.delegate.setUseClientMode(mode);
    }

    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    public void setNeedClientAuth(boolean need) {
        this.delegate.setNeedClientAuth(need);
    }

    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    public void setWantClientAuth(boolean want) {
        this.delegate.setWantClientAuth(want);
    }

    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    public void setEnableSessionCreation(boolean enable) {
        this.delegate.setEnableSessionCreation(enable);
    }

    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSLSocketWrapper)) {
            return false;
        }
        SSLSocketWrapper that = (SSLSocketWrapper)obj;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ 0x1010101;
    }
}

