/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.net.tunnel;

import edu.emory.mathcs.util.net.tunnel.TunnelServerSocket;
import edu.emory.mathcs.util.net.tunnel.TunnelSocketAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public class TunnelSocket
extends Socket {
    int remotePort;
    Socket tunnel;
    volatile int soTimeout = 0;
    volatile boolean closed;
    volatile boolean connected;
    volatile boolean isConnecting;

    public TunnelSocket(Socket tunnel, TunnelSocketAddress addr) throws IOException {
        this(tunnel);
        this.connect(addr);
    }

    public TunnelSocket(TunnelSocketAddress addr) throws IOException {
        this();
        this.connect(addr);
    }

    public TunnelSocket(InetSocketAddress addr, int port) throws IOException {
        this();
        this.connect(new TunnelSocketAddress(addr, port));
    }

    public TunnelSocket(Socket tunnel) throws IOException {
        if (tunnel == null) {
            throw new NullPointerException();
        }
        this.tunnel = tunnel;
    }

    public TunnelSocket() throws IOException {
        this.tunnel = new Socket();
    }

    public TunnelSocket(Socket tunnel, int port) throws IOException {
        this(tunnel, port, 0);
    }

    public TunnelSocket(Socket tunnel, int port, int timeout) throws IOException {
        this(tunnel);
        this.connectOverConnected(tunnel, port, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof TunnelSocketAddress)) {
            throw new IllegalArgumentException("connect: The address must be an instance of TunnelSocketAddress");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        TunnelSocketAddress addr = (TunnelSocketAddress)endpoint;
        SocketAddress tunnelAddr = addr.getTunnelAddress();
        int port = addr.getPort();
        TunnelSocket tunnelSocket = this;
        synchronized (tunnelSocket) {
            if (this.isConnecting) {
                throw new IOException("Connect already in progress");
            }
            this.isConnecting = true;
        }
        try {
            this.tunnel.connect(tunnelAddr);
            this.handShake(this.tunnel, port, timeout);
            this.setConnected(this.remotePort);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        finally {
            this.isConnecting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectOverConnected(Socket tunnel, int port, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (!tunnel.isConnected()) {
            throw new IllegalArgumentException("Tunnel must be connected");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        TunnelSocket tunnelSocket = this;
        synchronized (tunnelSocket) {
            if (this.isConnecting) {
                throw new IOException("Connect already in progress");
            }
            this.isConnecting = true;
        }
        try {
            this.handShake(tunnel, port, timeout);
            this.setConnected(this.remotePort);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        finally {
            this.isConnecting = false;
        }
    }

    private void handShake(Socket tunnel, int port, int timeout) throws IOException {
        long deadline = 0L;
        if (timeout > 0) {
            deadline = System.currentTimeMillis() + (long)timeout;
            tunnel.setSoTimeout(timeout);
        }
        DataOutputStream out = new DataOutputStream(tunnel.getOutputStream());
        out.writeInt(TunnelServerSocket.PROTOCOL_MAGIC);
        out.writeInt(TunnelServerSocket.PROTOCOL_VERSION_1);
        out.writeInt(port);
        out.flush();
        DataInputStream in = new DataInputStream(tunnel.getInputStream());
        int response = in.readInt();
        switch (response) {
            case 1: {
                break;
            }
            case -2: {
                throw new ConnectException("Connection refused");
            }
            case -4: {
                throw new ConnectException("Connection refused (server busy, try again later)");
            }
            default: {
                throw new ConnectException();
            }
        }
        if (deadline != 0L || this.soTimeout >= 0) {
            tunnel.setSoTimeout(this.soTimeout >= 0 ? this.soTimeout : 0);
        }
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.ensureNotClosed();
        throw new UnsupportedOperationException();
    }

    protected Socket getTunnel() {
        return this.tunnel;
    }

    public InetAddress getInetAddress() {
        return this.tunnel.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.tunnel.getLocalAddress();
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.tunnel.getPort();
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.tunnel.getLocalPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new TunnelSocketAddress(this.tunnel.getRemoteSocketAddress(), this.remotePort);
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return this.tunnel.getLocalSocketAddress();
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.ensureNotClosed();
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.tunnel.getInputStream();
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.ensureNotClosed();
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.tunnel.getOutputStream();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.tunnel.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.tunnel.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.tunnel.setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        return this.tunnel.getSoLinger();
    }

    public void sendUrgentData(int data) throws IOException {
        this.tunnel.sendUrgentData(data);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.tunnel.setOOBInline(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.tunnel.getOOBInline();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative; got: " + timeout);
        }
        this.soTimeout = timeout;
    }

    public synchronized int getSoTimeout() throws SocketException {
        this.ensureNotClosed();
        return this.soTimeout;
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.tunnel.setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.tunnel.getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.tunnel.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.tunnel.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.tunnel.setKeepAlive(on);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.tunnel.getKeepAlive();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.tunnel.setTrafficClass(tc);
    }

    public int getTrafficClass() throws SocketException {
        return this.tunnel.getTrafficClass();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.tunnel.setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.tunnel.getReuseAddress();
    }

    public void close() throws IOException {
        this.tunnel.close();
    }

    public void shutdownInput() throws IOException {
        this.tunnel.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.tunnel.shutdownOutput();
    }

    public String toString() {
        if (this.isConnected()) {
            return "Socket[remote=" + this.getRemoteSocketAddress() + ",local=" + this.getLocalSocketAddress() + "]";
        }
        return "Socket[unconnected]";
    }

    synchronized void setConnected(int remotePort) {
        this.remotePort = remotePort;
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return this.tunnel.isClosed();
    }

    public boolean isInputShutdown() {
        return this.tunnel.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.tunnel.isOutputShutdown();
    }

    private void ensureNotClosed() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }
}

