/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote;

import edu.emory.mathcs.util.remote.io.RemoteInputStream;
import edu.emory.mathcs.util.remote.io.RemoteOutputStream;
import edu.emory.mathcs.util.remote.io.server.RemoteInputStreamSrv;
import edu.emory.mathcs.util.remote.io.server.RemoteOutputStreamSrv;
import edu.emory.mathcs.util.remote.server.RemoteProcessSrv;
import edu.emory.mathcs.util.remote.server.impl.RemoteProcessSrvImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.rmi.RemoteException;

public class RemoteProcess
implements Externalizable {
    RemoteProcessSrv server;
    transient RemoteInputStream srvin;
    transient RemoteInputStream srverr;
    transient RemoteOutputStream srvout;

    public RemoteProcess() {
    }

    public RemoteProcess(Process process) {
        this(new RemoteProcessSrvImpl(process));
    }

    public RemoteProcess(RemoteProcessSrv server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        this.server = server;
        this.initStreams();
    }

    private void initStreams() {
        this.srvin = new RemoteInputStream(new RemoteInputStreamSrv(){

            public byte[] read(int maxRead) throws IOException {
                return RemoteProcess.this.server.readFromIn(maxRead);
            }

            public long skip(long n) throws IOException {
                return RemoteProcess.this.server.skipInIn(n);
            }

            public int available() throws IOException {
                return RemoteProcess.this.server.availableInIn();
            }

            public void close() throws IOException {
                RemoteProcess.this.server.closeIn();
            }
        });
        this.srverr = new RemoteInputStream(new RemoteInputStreamSrv(){

            public byte[] read(int maxRead) throws IOException {
                return RemoteProcess.this.server.readFromErr(maxRead);
            }

            public long skip(long n) throws IOException {
                return RemoteProcess.this.server.skipInErr(n);
            }

            public int available() throws IOException {
                return RemoteProcess.this.server.availableInErr();
            }

            public void close() throws IOException {
                RemoteProcess.this.server.closeErr();
            }
        });
        this.srvout = new RemoteOutputStream(new RemoteOutputStreamSrv(){

            public void write(byte[] data) throws IOException {
                RemoteProcess.this.server.writeToOut(data);
            }

            public void flush() throws IOException {
                RemoteProcess.this.server.flushOut();
            }

            public void close() throws IOException {
                RemoteProcess.this.server.closeOut();
            }
        });
    }

    public void destroy() throws RemoteException {
        this.server.destroy();
    }

    public int exitValue() throws RemoteException {
        return this.server.exitValue();
    }

    public int waitFor() throws RemoteException, InterruptedException {
        return this.server.waitFor();
    }

    public InputStream getInputStream() {
        return this.srvin;
    }

    public InputStream getErrorStream() {
        return this.srverr;
    }

    public OutputStream getOutputStream() {
        return this.srvout;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.server);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.server = (RemoteProcessSrv)in.readObject();
        this.initStreams();
    }
}

