/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.remote.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.util.remote.locks.RemoteCondition;
import edu.emory.mathcs.util.remote.locks.RemoteLock;
import java.rmi.RemoteException;

public abstract class AbstractPollingLock
implements RemoteLock {
    final int retries;
    final float backoff;
    final long initDelay;
    final long maxDelay;

    protected AbstractPollingLock() {
        this(1.6f, TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.MINUTES.toNanos(1L));
    }

    protected AbstractPollingLock(float backoff, long initDelay, long maxDelay) {
        this(3, backoff, initDelay, maxDelay);
    }

    protected AbstractPollingLock(int retries, float backoff, long initDelay, long maxDelay) {
        this.retries = retries;
        this.backoff = backoff;
        this.initDelay = initDelay;
        this.maxDelay = maxDelay;
    }

    public void lock() throws RemoteException {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.lockInterruptibly();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public void lockInterruptibly() throws InterruptedException, RemoteException {
        if (this.tryLock()) {
            return;
        }
        for (int i = 0; i < this.retries; ++i) {
            if (!this.tryLock()) continue;
            return;
        }
        long delay = this.initDelay;
        while (true) {
            TimeUnit.NANOSECONDS.sleep(delay);
            if (this.tryLock()) {
                return;
            }
            delay = this.calculateNextDelay(delay);
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException, RemoteException {
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        if (nanos <= 0L) {
            return false;
        }
        if (this.tryLock()) {
            return true;
        }
        nanos = deadline - Utils.nanoTime();
        for (int i = 0; i < this.retries; ++i) {
            if (nanos <= 0L) {
                return false;
            }
            if (this.tryLock()) {
                return true;
            }
            nanos = deadline - Utils.nanoTime();
        }
        long delay = this.initDelay;
        while (nanos > 0L) {
            TimeUnit.NANOSECONDS.sleep(delay < nanos ? delay : nanos);
            if (this.tryLock()) {
                return true;
            }
            nanos = deadline - Utils.nanoTime();
            delay = this.calculateNextDelay(delay);
        }
        return false;
    }

    public RemoteCondition newCondition() {
        throw new UnsupportedOperationException();
    }

    private long calculateNextDelay(long prev) {
        long delay = (long)((float)prev * this.backoff);
        if (delay > this.maxDelay) {
            delay = this.maxDelay;
        }
        return delay;
    }
}

