/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.security;

import edu.emory.mathcs.util.security.action.GetPropertyAction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CertUtils {
    private static CertificateFactory x509certFact;

    private CertUtils() {
    }

    public static synchronized CertificateFactory getX509CertFactory() {
        if (x509certFact == null) {
            try {
                x509certFact = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new RuntimeException("FATAL: X.509 factory not supported");
            }
        }
        return x509certFact;
    }

    public static KeyStore createKeystore() {
        try {
            return CertUtils.createKeystore(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("FATAL: keystore type \"" + KeyStore.getDefaultType() + "\" not supported");
        }
    }

    public static KeyStore createKeystore(String type) throws KeyStoreException {
        KeyStore ks = KeyStore.getInstance(type);
        try {
            ks.load(null, null);
            return ks;
        }
        catch (IOException e) {
            throw new RuntimeException("FATAL: can't initialize empty keystore");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("FATAL: can't initialize empty keystore");
        }
        catch (CertificateException e) {
            throw new RuntimeException("FATAL: can't initialize empty keystore");
        }
    }

    public static KeyStore loadKeystore(File file, char[] passwd) throws IOException, CertificateException, NoSuchAlgorithmException {
        try {
            return CertUtils.loadKeystore(file, passwd, KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("FATAL: keystore type \"" + KeyStore.getDefaultType() + "\" not supported");
        }
    }

    public static KeyStore loadKeystore(File file, char[] passwd, String type) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        FileInputStream fis = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(type);
        ks.load(fis, passwd);
        fis.close();
        return ks;
    }

    public static List getKeystoreCerts(KeyStore ks) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        try {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!ks.isCertificateEntry(alias)) continue;
                Certificate c = ks.getCertificate(alias);
                list.add(c);
            }
            return list;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Keystore not loaded", e);
        }
    }

    public static Collection createTrustAnchors(Collection certs) {
        return CertUtils.createTrustAnchors(certs, null);
    }

    public static Collection createTrustAnchors(Collection certs, byte[] nameConstraints) {
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>(certs.size());
        Iterator i = certs.iterator();
        while (i.hasNext()) {
            Certificate cert = (Certificate)i.next();
            if (!(cert instanceof X509Certificate)) continue;
            anchors.add(new TrustAnchor((X509Certificate)cert, nameConstraints));
        }
        return anchors;
    }

    public static Collection getJSSETrustAnchors() {
        String trustStore = (String)AccessController.doPrivileged(new GetPropertyAction("javax.net.ssl.trustStore"));
        if (trustStore != null) {
            String trustStorePassStr = (String)AccessController.doPrivileged(new GetPropertyAction("javax.net.ssl.trustStorePassword", ""));
            char[] pass = trustStorePassStr.toCharArray();
            File file = new File(trustStore);
            try {
                if (file.exists()) {
                    KeyStore ks = CertUtils.loadKeystore(file, pass);
                    return CertUtils.createTrustAnchors(CertUtils.getKeystoreCerts(ks));
                }
            }
            catch (IOException e) {
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (CertificateException e) {
                // empty catch block
            }
            return Collections.EMPTY_SET;
        }
        return (Collection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CertUtils.getDefaultJavaTrustAnchorsPrivileged();
            }
        });
    }

    private static Collection getDefaultJavaTrustAnchorsPrivileged() {
        String javaHome = System.getProperty("java.home");
        File jssecacerts = new File(javaHome, "lib/security/jssecacerts".replace('/', File.separatorChar));
        File cacerts = new File(javaHome, "lib/security/cacerts".replace('/', File.separatorChar));
        HashSet trustAnchors = new HashSet();
        try {
            KeyStore ks = jssecacerts.exists() ? CertUtils.loadKeystore(jssecacerts, null) : CertUtils.loadKeystore(cacerts, null);
            return CertUtils.createTrustAnchors(CertUtils.getKeystoreCerts(ks));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate[] getX509Certs(Collection trustAnchors) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(trustAnchors.size());
        Iterator i = trustAnchors.iterator();
        while (i.hasNext()) {
            TrustAnchor anchor = (TrustAnchor)i.next();
            certs.add(anchor.getTrustedCert());
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public static CertPathValidator createPKIXValidator() {
        try {
            return CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("FATAL: PKIX validation not supported");
        }
    }

    public static CertPath convertToCertPath(X509Certificate[] certs) {
        try {
            return CertUtils.getX509CertFactory().generateCertPath(Arrays.asList(certs));
        }
        catch (CertificateException e) {
            throw new RuntimeException("FATAL: X509 cert path construction failed");
        }
    }

    public static X509Certificate decodeX509Cert(byte[] encoded) throws CertificateException {
        return (X509Certificate)CertUtils.getX509CertFactory().generateCertificate(new ByteArrayInputStream(encoded));
    }

    public static byte[] encodeX509Cert(X509Certificate cert) {
        try {
            return cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("FATAL: X509 cert can't be encoded");
        }
    }

    public static void verifySSLServerHostname(X509Certificate cert, String hostname) throws CertificateException {
        String subject = CertUtils.getCN(cert);
        if (!CertUtils.serverHostnameMatches(subject, hostname)) {
            throw new CertificateException("The certificate subject \"" + subject + "\" does not match the host name \"" + hostname + "\"");
        }
    }

    public static String getCN(X509Certificate cert) {
        String dn = cert.getSubjectX500Principal().getName("RFC1779");
        String dnl = dn.toLowerCase();
        int beg = dnl.indexOf("cn=");
        if (beg < 0) {
            return null;
        }
        int end = dnl.indexOf(44, beg);
        dn = end >= beg ? dn.substring(beg + "cn=".length(), end) : dn.substring(beg + "cn=".length());
        if ((dn = dn.trim()).startsWith("\"")) {
            dn = dn.substring(1);
        }
        if (dn.endsWith("\"")) {
            dn = dn.substring(0, dn.length() - 1);
        }
        return dn;
    }

    private static boolean serverHostnameMatches(final String subject, final String hostname) {
        if (hostname.equals(subject)) {
            return true;
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress addr1 = InetAddress.getByName(hostname);
                    InetAddress addr2 = InetAddress.getByName(subject);
                    String n1 = addr1.getCanonicalHostName();
                    String n2 = addr2.getCanonicalHostName();
                    return n1.equals(n2) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (UnknownHostException e) {
                    return Boolean.FALSE;
                }
            }
        });
    }
}

