/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;

public class JDetailedMessageBox
extends JDialog {
    static Color BACKGROUND_COLOR = UIManager.getColor("OptionPane.background");
    static Font MESSAGE_FONT = UIManager.getFont("OptionPane.messageFont");
    static Font BUTTON_FONT = UIManager.getFont("OptionPane.font");
    static Font LABEL_FONT = UIManager.getFont("Label.font");
    JPanel detailPane;
    JButton detailBtn;
    JButton initialFocus;
    int selectedBtn = -1;
    int defaultBtn;
    DetailButtonListener dblistener = new DetailButtonListener();

    JDetailedMessageBox(Dialog owner, String title) {
        super(owner, title, true);
    }

    JDetailedMessageBox(Frame owner, String title) {
        super(owner, title, true);
    }

    public static JDetailedMessageBox newInstance(Component parentComponent, String title, Object message, int messageType, int optionType, Object details) {
        return JDetailedMessageBox.newInstance(parentComponent, title, message, messageType, optionType, JDetailedMessageBox.iconForMessageType(messageType), details);
    }

    public static JDetailedMessageBox newInstance(Component parentComponent, String title, Object message, int messageType, int optionType, Icon icon, Object details) {
        return JDetailedMessageBox.newInstance(parentComponent, title, message, messageType, optionType, icon, null, details);
    }

    public static JDetailedMessageBox newInstance(Component parentComponent, String title, Object message, int messageType, int optionType, Icon icon, Object[] options, Object details) {
        return JDetailedMessageBox.newInstance(parentComponent, title, message, messageType, optionType, icon, options, 0, details);
    }

    public static JDetailedMessageBox newInstance(Component parentComponent, String title, Object message, int messageType, int optionType, Icon icon, Object[] options, int initialIndex, Object details) {
        return JDetailedMessageBox.newInstance(parentComponent, title, message, messageType, optionType, (Object)icon, options, initialIndex, details);
    }

    public static JDetailedMessageBox newInstance(Component parentComponent, String title, Object message, int messageType, int optionType, Object icon, Object[] options, int initialIndex, Object details) {
        Component iconComponent;
        Window window = JDetailedMessageBox.getWindowForComponent(parentComponent);
        final JDetailedMessageBox dialog = window instanceof Frame ? new JDetailedMessageBox((Frame)window, title) : new JDetailedMessageBox((Dialog)window, title);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        if (icon == null) {
            iconComponent = null;
        } else if (icon instanceof Component) {
            iconComponent = (Component)icon;
        } else {
            JLabel iconLabel = icon instanceof Icon ? new JLabel((Icon)icon) : new JLabel(icon.toString());
            iconLabel.setBackground(BACKGROUND_COLOR);
            iconComponent = iconLabel;
        }
        if (iconComponent != null) {
            contentPane.add(iconComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 5, 5), 0, 0));
        }
        JPanel msgPane = new JPanel();
        contentPane.add((Component)msgPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.001, 18, 1, new Insets(6, 6, 5, 5), 0, 0));
        JPanel auxBtnPane = new JPanel();
        JPanel btnPane = new JPanel();
        contentPane.add((Component)auxBtnPane, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(6, 6, 5, 5), 0, 0));
        auxBtnPane.setLayout(new BorderLayout());
        auxBtnPane.add((Component)btnPane, "North");
        btnPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        GridLayout btnLayout = new GridLayout(0, 1, 5, 5);
        btnPane.setLayout(btnLayout);
        if (options == null) {
            options = JDetailedMessageBox.buttonsFromOptionType(optionType, dialog.getLocale());
        }
        for (int i = 0; i < options.length; ++i) {
            Object btnObj = options[i];
            JButton jbutton = btnObj instanceof JButton ? (JButton)btnObj : new JButton(btnObj.toString());
            if (i == initialIndex) {
                dialog.getRootPane().setDefaultButton(jbutton);
                dialog.initialFocus = jbutton;
            }
            JDetailedMessageBox.configureButton(jbutton);
            JDetailedMessageBox jDetailedMessageBox = dialog;
            jDetailedMessageBox.getClass();
            jbutton.addActionListener(jDetailedMessageBox.new ButtonActionListener(i));
            btnPane.add(jbutton);
        }
        msgPane.setLayout(new BorderLayout());
        if (message instanceof Component) {
            msgPane.add((Component)message);
        } else {
            String msg = message.toString();
            JTextArea ta = new JTextArea(msg);
            Font font = JDetailedMessageBox.getMessageFont(dialog);
            if (font != null) {
                ta.setFont(font);
            }
            ta.setEditable(false);
            ta.setBackground(BACKGROUND_COLOR);
            Dimension tapref = ta.getPreferredSize();
            int width = (int)tapref.getWidth();
            int height = (int)tapref.getHeight();
            int preflines = (int)(btnPane.getPreferredSize().getHeight() / (double)height);
            if (preflines == 0) {
                preflines = 1;
            }
            if (width > 250) {
                if ((width /= preflines) < 250) {
                    width = 250;
                } else if (width > 500) {
                    width = 500;
                }
            }
            ta.setSize(width, Integer.MAX_VALUE);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            msgPane.add((Component)ta, "Center");
            ta.invalidate();
        }
        JButton dbtn = new JButton();
        JDetailedMessageBox.configureButton(dbtn);
        auxBtnPane.add((Component)dbtn, "South");
        dialog.detailBtn = dbtn;
        dbtn.addActionListener(dialog.dblistener);
        JPanel detailPane = new JPanel();
        detailPane.setLayout(new BorderLayout());
        if (details instanceof Component) {
            detailPane.add((Component)details, "Center");
        } else {
            JScrollPane scrollPane = new JScrollPane();
            detailPane.add((Component)scrollPane, "Center");
            JTextArea dtt = new JTextArea(details.toString());
            dtt.setEditable(false);
            dtt.setTabSize(4);
            scrollPane.setViewport(new DetailViewport());
            scrollPane.setViewportView(dtt);
        }
        Dimension dsize = detailPane.getSize();
        dsize.height = 150;
        detailPane.setSize(dsize);
        detailPane.invalidate();
        dialog.detailPane = detailPane;
        contentPane.add((Component)detailPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(6, 6, 5, 5), 0, 0));
        dialog.dblistener.update(false);
        if (JDialog.isDefaultLookAndFeelDecorated()) {
            int style = JDetailedMessageBox.styleFromMessageType(messageType);
            boolean supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations();
            if (supportsWindowDecorations) {
                dialog.setUndecorated(true);
                dialog.getRootPane().setWindowDecorationStyle(style);
            }
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent we) {
                dialog.selectedBtn = -1;
            }

            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    dialog.selectedBtn = dialog.defaultBtn;
                    this.gotFocus = true;
                }
            }
        });
        dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                dialog.selectedBtn = -1;
            }
        });
        return dialog;
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JDetailedMessageBox.getWindowForComponent(parentComponent.getParent());
    }

    public void setInitialFocus() {
        if (this.initialFocus != null) {
            this.initialFocus.requestFocus();
        }
    }

    public int getValue() {
        return this.selectedBtn;
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private static JButton[] buttonsFromOptionType(int optionType, Locale l) {
        JButton[] options;
        if (optionType == 0) {
            options = new JButton[2];
            options[0] = new JButton(UIManager.get("OptionPane.yesButtonText", l).toString());
            options[0].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.yesButtonMnemonic", l));
            options[1] = new JButton(UIManager.get("OptionPane.noButtonText", l).toString());
            options[1].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.noButtonMnemonic", l));
        } else if (optionType == 1) {
            options = new JButton[3];
            options[0] = new JButton(UIManager.get("OptionPane.yesButtonText", l).toString());
            options[0].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.yesButtonMnemonic", l));
            options[1] = new JButton(UIManager.get("OptionPane.noButtonText", l).toString());
            options[1].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.noButtonMnemonic", l));
            options[2] = new JButton(UIManager.get("OptionPane.cancelButtonText", l).toString());
            options[2].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.cancelButtonMnemonic", l));
        } else if (optionType == 2) {
            options = new JButton[2];
            options[0] = new JButton(UIManager.get("OptionPane.okButtonText", l).toString());
            options[0].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.okButtonMnemonic", l));
            options[1] = new JButton(UIManager.get("OptionPane.cancelButtonText", l).toString());
            options[1].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.cancelButtonMnemonic", l));
        } else {
            options = new JButton[]{new JButton(UIManager.get("OptionPane.okButtonText", l).toString())};
            options[0].setMnemonic(JDetailedMessageBox.getMnemonic("OptionPane.okButtonMnemonic", l));
        }
        return options;
    }

    private static Icon iconForMessageType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private static int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static void configureButton(JButton btn) {
        if (BUTTON_FONT != null && btn.getFont() == null) {
            btn.setFont(BUTTON_FONT);
        }
    }

    private static Font getMessageFont(Component owner) {
        Font font = MESSAGE_FONT;
        if (font == null) {
            font = LABEL_FONT;
        }
        if (font == null) {
            font = owner.getFont();
        }
        return font;
    }

    private static Locale getLocaleForComponent(Component c) {
        return c == null ? Locale.getDefault() : c.getLocale();
    }

    public static void showMessageDialog(Component parentComponent, Object message, Object details) {
        JDetailedMessageBox.showMessageDialog(parentComponent, message, UIManager.getString((Object)"OptionPane.messageDialogTitle", JDetailedMessageBox.getLocaleForComponent(parentComponent)), 1, details);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Object details) {
        JDetailedMessageBox.showMessageDialog(parentComponent, message, title, messageType, JDetailedMessageBox.iconForMessageType(messageType), details);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object details) {
        JDetailedMessageBox.showOptionDialog(parentComponent, message, title, -1, messageType, icon, null, details);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, Object details) {
        return JDetailedMessageBox.showConfirmDialog(parentComponent, message, UIManager.getString("OptionPane.titleText"), 1, details);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, Object details) {
        return JDetailedMessageBox.showConfirmDialog(parentComponent, message, title, optionType, 3, details);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Object details) {
        return JDetailedMessageBox.showConfirmDialog(parentComponent, message, title, optionType, messageType, JDetailedMessageBox.iconForMessageType(messageType), details);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object details) {
        return JDetailedMessageBox.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, null, details);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Object[] options, Object details) {
        return JDetailedMessageBox.showOptionDialog(parentComponent, message, title, optionType, messageType, JDetailedMessageBox.iconForMessageType(messageType), options, details);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object details) {
        JDetailedMessageBox mbox = JDetailedMessageBox.newInstance(parentComponent, title, message, messageType, optionType, icon, options, details);
        mbox.setInitialFocus();
        mbox.show();
        mbox.dispose();
        int selectedValue = mbox.getValue();
        return selectedValue;
    }

    private static class DetailViewport
    extends JViewport {
        private DetailViewport() {
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = 150;
            return d;
        }
    }

    protected class ButtonActionListener
    implements ActionListener {
        int buttonIndex;

        public ButtonActionListener(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }

        public void actionPerformed(ActionEvent e) {
            JDetailedMessageBox.this.selectedBtn = this.buttonIndex;
            JDetailedMessageBox.this.setVisible(false);
        }
    }

    private class DetailButtonListener
    implements ActionListener {
        boolean shown = false;

        private DetailButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            this.update(!this.shown);
        }

        void update(boolean show) {
            String label = show ? ">> Details" : "Details >>";
            JDetailedMessageBox.this.detailBtn.setText(label);
            JDetailedMessageBox.this.detailPane.setVisible(show);
            if (show == this.shown) {
                return;
            }
            this.shown = show;
            JDetailedMessageBox.this.pack();
        }
    }
}

