/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.xml;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    private DOMUtils() {
    }

    public static DocumentBuilder createDocumentBuilder() {
        return DOMUtils.createDocumentBuilder(true, true);
    }

    public static DocumentBuilder createDocumentBuilder(boolean validating, boolean namespaceAware) {
        return DOMUtils.createDocumentBuilder(validating, namespaceAware, validating, true);
    }

    public static DocumentBuilder createDocumentBuilder(boolean validating, boolean namespaceAware, boolean ignoringElementContentWhitespace, boolean ignoringComments) {
        return DOMUtils.createDocumentBuilder(validating, namespaceAware, ignoringElementContentWhitespace, ignoringComments, true, true);
    }

    public static DocumentBuilder createDocumentBuilder(boolean validating, boolean namespaceAware, boolean ignoringElementContentWhitespace, boolean ignoringComments, boolean expandEntityReferences, boolean coalescing) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validating);
        dbf.setNamespaceAware(namespaceAware);
        dbf.setIgnoringElementContentWhitespace(ignoringElementContentWhitespace);
        dbf.setIgnoringComments(ignoringComments);
        dbf.setExpandEntityReferences(expandEntityReferences);
        dbf.setCoalescing(coalescing);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getAttribute(Element element, String name) {
        return DOMUtils.getAttribute(element, name, null);
    }

    public static String getAttribute(Element element, String name, String defVal) {
        Attr attr = (Attr)element.getAttributes().getNamedItem(name);
        if (attr != null) {
            return attr.getValue();
        }
        return defVal;
    }

    public static void setAttribute(Element element, String name, String val) {
        element.setAttribute(name, val);
    }

    public static Element[] getChildElements(Element element) {
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        ArrayList<Node> elems = new ArrayList<Node>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            elems.add(node);
        }
        return elems.toArray(new Element[elems.size()]);
    }

    public static Element createChildElement(Document doc, Element parent, String name) {
        Element elem = doc.createElement(name);
        parent.appendChild(elem);
        return elem;
    }

    public static Text createTextNode(Document doc, Element parent, String text) {
        Text node = doc.createTextNode(text);
        parent.appendChild(node);
        return node;
    }

    public static Text createTextChildElement(Document doc, Element parent, String name, String text) {
        Element elem = DOMUtils.createChildElement(doc, parent, name);
        return DOMUtils.createTextNode(doc, elem, text);
    }

    public static Element getChildElement(Element element, String name) {
        return DOMUtils.getChildElement(element, name, null);
    }

    public static Element getChildElement(Element element, String name, Node initPos) {
        NodeList nodes = element.getChildNodes();
        int length = nodes.getLength();
        ArrayList elems = new ArrayList(length);
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            Element elem;
            Node node = nodes.item(i);
            if (!found && initPos != null) {
                if (node != initPos) continue;
                found = true;
                continue;
            }
            if (node.getNodeType() != 1 || !name.equals((elem = (Element)node).getNodeName())) continue;
            return elem;
        }
        return null;
    }

    public static String getText(Element element) {
        NodeList nodes = element.getChildNodes();
        if (nodes.getLength() == 0) {
            return null;
        }
        if (nodes.getLength() > 1) {
            throw new IllegalArgumentException("Too many nodes; expected 1, is: " + nodes.getLength());
        }
        Node node = nodes.item(0);
        if (node.getNodeType() != 3) {
            throw new IllegalArgumentException("Expected text node, found: " + node.getNodeType());
        }
        return node.getNodeValue();
    }
}

