/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapHeaderConstructor {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapHeaderConstructor == null ? (class$de$kapsi$net$daap$DaapHeaderConstructor = DaapHeaderConstructor.class$("de.kapsi.net.daap.DaapHeaderConstructor")) : class$de$kapsi$net$daap$DaapHeaderConstructor));
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String ISO_8859_1 = "8859_1";
    private static final String HTTP_OK = "HTTP/1.1 200 OK";
    private static final String HTTP_AUTH = "HTTP/1.1 401 Authorization Required";
    private static final String HTTP_PARTIAL_CONTENT = "HTTP/1.1 206 Partial Content";
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapHeaderConstructor;

    public static byte[] createChunkHeader(DaapRequest request, int contentLength) {
        try {
            DaapConnection connection = request.getConnection();
            String serverName = connection.getServer().getConfig().getServerName();
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(new Header("Date", DaapUtil.now()));
            headers.add(new Header("DAAP-Server", serverName));
            headers.add(new Header("Content-Type", "application/x-dmap-tagged"));
            headers.add(new Header("Content-Length", Integer.toString(contentLength)));
            headers.add(new Header("Content-Encoding", "gzip"));
            return DaapHeaderConstructor.toByteArray(HTTP_OK, headers.toArray(new Header[0]));
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] createAudioHeader(DaapRequest request, int pos, int end, int contentLength) {
        try {
            DaapConnection connection = request.getConnection();
            int version = connection.getProtocolVersion();
            if (version == 0) {
                throw new IOException("Client Protocol Version is unknown");
            }
            String serverName = connection.getServer().getConfig().getServerName();
            String statusLine = null;
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(new Header("Date", DaapUtil.now()));
            headers.add(new Header("DAAP-Server", serverName));
            headers.add(new Header("Content-Type", "application/x-dmap-tagged"));
            if (pos == 0 || version <= 131072) {
                statusLine = HTTP_OK;
                headers.add(new Header("Content-Length", Integer.toString(contentLength)));
            } else {
                statusLine = HTTP_PARTIAL_CONTENT;
                String cotentLengthStr = Integer.toString(contentLength - pos);
                String contentRange = "bytes " + pos + "-" + (contentLength - 1) + "/" + contentLength;
                headers.add(new Header("Content-Length", cotentLengthStr));
                headers.add(new Header("Content-Range", contentRange));
            }
            headers.add(new Header("Accept-Ranges", "bytes"));
            return DaapHeaderConstructor.toByteArray(statusLine, headers.toArray(new Header[0]));
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public static byte[] createAuthHeader(DaapRequest request) {
        try {
            DaapConnection connection = request.getConnection();
            String serverName = connection.getServer().getConfig().getServerName();
            Header[] headers = new Header[]{new Header("Date", DaapUtil.now()), new Header("DAAP-Server", serverName), new Header("Content-Type", "text/html"), new Header("Content-Length", "0"), new Header("WWW-Authenticate", "Basic-realm=\"daap\"")};
            return DaapHeaderConstructor.toByteArray(HTTP_AUTH, headers);
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    private static byte[] toByteArray(String statusLine, Header[] headers) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(statusLine.getBytes(ISO_8859_1));
        out.write(CRLF);
        for (int i = 0; i < headers.length; ++i) {
            out.write(headers[i].toExternalForm().getBytes(ISO_8859_1));
        }
        out.write(CRLF);
        out.close();
        return out.toByteArray();
    }

    private DaapHeaderConstructor() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

