/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.Chunk;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ContainerChunk
extends AbstractChunk {
    private Collection collection;

    protected ContainerChunk(String type, String name) {
        this(type, name, new ArrayList());
    }

    protected ContainerChunk(String type, String name, Collection collection) {
        super(type, name);
        this.collection = collection;
    }

    public void add(Chunk chunk) {
        this.collection.add(chunk);
    }

    public int size() {
        return this.collection.size();
    }

    public int getLength() {
        int length = 0;
        Iterator it = this.collection.iterator();
        while (it.hasNext()) {
            length += ((Chunk)it.next()).getSize();
        }
        return length;
    }

    public int getType() {
        return 12;
    }

    public void serialize(OutputStream os) throws IOException {
        super.serialize(os);
        Iterator it = this.collection.iterator();
        while (it.hasNext()) {
            ((Chunk)it.next()).serialize(os);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString()).append("=[");
        Iterator it = this.collection.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

