/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.random;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.logi.crypto.Crypto;

public class RandomFromStream
extends Random {
    private static String emptyMsg = "RandomFromStream ran out of random bytes.";
    private InputStream in;

    public void nextBytes(byte[] byArray) {
        try {
            if (Crypto.readBlock(this.in, byArray, 0, byArray.length) == -1) {
                throw new Error(emptyMsg);
            }
        }
        catch (IOException iOException) {
            throw new Error(emptyMsg);
        }
    }

    protected synchronized int next(int n) {
        try {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = this.in.read();
                if (n4 < 0) {
                    throw new Error(emptyMsg);
                }
                n2 = n2 << 8 | n4;
                n3 += 8;
            }
            return n2 >>> n3 - n;
        }
        catch (IOException iOException) {
            throw new Error(emptyMsg);
        }
    }

    public RandomFromStream(InputStream inputStream) {
        this.in = inputStream;
    }
}

