/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader;

import edu.emory.mathcs.util.classloader.ResourceFinder;
import edu.emory.mathcs.util.classloader.ResourceHandle;
import edu.emory.mathcs.util.classloader.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class URIClassLoader
extends URLClassLoader {
    final URIResourceFinder finder;
    final AccessControlContext acc;

    public URIClassLoader(URI[] uris) {
        this(uris, (URLStreamHandler)null);
    }

    public URIClassLoader(URI[] uris, URLStreamHandler jarHandler) {
        super(new URL[0]);
        this.finder = new URIResourceFinder(uris, jarHandler);
        this.acc = AccessController.getContext();
    }

    public URIClassLoader(URI[] uris, ClassLoader parent) {
        this(uris, parent, null);
    }

    public URIClassLoader(URI[] uris, ClassLoader parent, URLStreamHandler jarHandler) {
        super(new URL[0], parent);
        this.finder = new URIResourceFinder(uris, jarHandler);
        this.acc = AccessController.getContext();
    }

    protected void addURI(URI uri) {
        this.finder.addURI(uri);
    }

    protected void addURL(URL url) {
        this.finder.addURI(URI.create(url.toExternalForm()));
    }

    public URL[] getURLs() {
        return (URL[])this.finder.getUrls().clone();
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    ResourceHandle h = URIClassLoader.this.finder.getResource(path);
                    if (h != null) {
                        try {
                            return URIClassLoader.this.defineClass(name, h);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected Class defineClass(String name, ResourceHandle h) throws IOException {
        int i = name.lastIndexOf(46);
        URL url = h.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = h.getManifest();
            if (pkg != null) {
                boolean ok;
                if (pkg.isSealed()) {
                    ok = pkg.isSealed(url);
                } else {
                    boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                }
                if (!ok) {
                    throw new SecurityException("sealing violation: " + name);
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        byte[] b = h.getBytes();
        Certificate[] certs = h.getCertificates();
        CodeSource cs = new CodeSource(url, certs);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    public URL findResource(final String name) {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.findResource(name);
            }
        }, this.acc);
    }

    public Enumeration findResources(final String name) throws IOException {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.findResources(name);
            }
        }, this.acc);
    }

    protected String findLibrary(String libname) {
        ResourceHandle md = this.getLibraryHandle(libname);
        if (md == null) {
            return null;
        }
        URL url = md.getURL();
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        return new File(URI.create(url.toString())).getPath();
    }

    protected ResourceHandle getClassHandle(String name) {
        String path = name.replace('.', '/').concat(".class");
        return this.getResourceHandle(path);
    }

    protected ResourceHandle getResourceHandle(final String name) {
        return (ResourceHandle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.getResource(name);
            }
        }, this.acc);
    }

    protected ResourceHandle getLibraryHandle(String name) {
        String simplename;
        String path;
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            path = "";
            simplename = name;
        } else {
            if (idx == name.length() - 1) {
                throw new IllegalArgumentException(name);
            }
            path = name.substring(0, idx + 1);
            simplename = name.substring(idx + 1);
        }
        return this.getResourceHandle(path + System.mapLibraryName(simplename));
    }

    protected Enumeration getResourceHandles(final String name) {
        return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URIClassLoader.this.finder.getResources(name);
            }
        }, this.acc);
    }

    protected URLStreamHandler getJarHandler() {
        return this.finder.loader.jarHandler;
    }

    private static class URIResourceFinder
    implements ResourceFinder {
        URL[] urls;
        final ResourceLoader loader;

        public URIResourceFinder(URI[] uris, URLStreamHandler jarHandler) {
            try {
                this.loader = jarHandler != null ? new ResourceLoader(jarHandler) : new ResourceLoader();
                URL[] urls = new URL[uris.length];
                for (int i = 0; i < uris.length; ++i) {
                    urls[i] = uris[i].toURL();
                }
                this.urls = urls;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public synchronized void addURI(URI uri) {
            try {
                URL url = uri.toURL();
                int len = this.urls.length;
                URL[] urls = new URL[len + 1];
                System.arraycopy(this.urls, 0, urls, 0, len);
                urls[len] = url;
                this.urls = urls;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        private final synchronized URL[] getUrls() {
            return this.urls;
        }

        public ResourceHandle getResource(String name) {
            return this.loader.getResource(this.getUrls(), name);
        }

        public Enumeration getResources(String name) {
            return this.loader.getResources(this.getUrls(), name);
        }

        public URL findResource(String name) {
            return this.loader.findResource(this.getUrls(), name);
        }

        public Enumeration findResources(String name) {
            return this.loader.findResources(this.getUrls(), name);
        }
    }
}

