/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.classloader.jar;

import edu.emory.mathcs.util.classloader.ResourceUtils;
import edu.emory.mathcs.util.classloader.jar.JarProxy;
import edu.emory.mathcs.util.classloader.jar.JarURLConnection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JarURLStreamHandler
extends URLStreamHandler {
    private static final Pattern ABSOLUTE_JAR_URL_PATTERN = Pattern.compile("jar:(.*)!(/(?:.*/)?)((?:[^/#]+)?)((?:#.*)?)");
    final JarURLConnection.JarOpener opener;

    public JarURLStreamHandler() {
        this(new JarProxy());
    }

    public JarURLStreamHandler(JarURLConnection.JarOpener opener) {
        this.opener = opener;
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new JarURLConnection(url, this.opener);
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        Matcher matcher = ABSOLUTE_JAR_URL_PATTERN.matcher(spec);
        if (matcher.matches()) {
            String base = matcher.group(1);
            try {
                URL baseURL = new URL(base);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.toString());
            }
            String path = matcher.group(2) + matcher.group(3);
            path = ResourceUtils.canonizePath(path);
            String ref = matcher.group(4);
            ref = ref.length() == 0 ? null : ref.substring(1);
            this.setURL(u, "jar", "", -1, "", "", base + "!" + path, null, ref);
        } else {
            matcher = ABSOLUTE_JAR_URL_PATTERN.matcher(u.toString());
            if (matcher.matches()) {
                String path;
                String ref = spec.substring(limit);
                ref = ref.length() == 0 ? null : ref.substring(1);
                spec = spec.substring(start, limit);
                String base = matcher.group(1);
                if (spec.length() > 0 && spec.charAt(0) == '/') {
                    path = spec;
                } else {
                    String cxtDir = matcher.group(2);
                    path = cxtDir + spec;
                }
                path = ResourceUtils.canonizePath(path);
                this.setURL(u, "jar", "", -1, "", "", base + "!" + path, null, ref);
            } else {
                throw new IllegalArgumentException("Neither URL nor the spec are valid JAR urls");
            }
        }
    }
}

