/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.util.security;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class KeyUtils {
    private KeyUtils() {
    }

    public static KeyPair generateRSAKeyPair() {
        return KeyUtils.generateRSAKeyPair(1024);
    }

    public static KeyPair generateRSAKeyPair(int keysize) {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(keysize);
            return gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("FATAL: RSA not supported", e);
        }
    }

    public static PublicKey decodeRSAPublicKey(byte[] encoded) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encoded);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("FATAL: RSA not supported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("FATAL: RSA does not support X509 encoding", e);
        }
    }

    public static KeyPair generateDSAKeyPair() {
        return KeyUtils.generateDSAKeyPair(1024);
    }

    public static KeyPair generateDSAKeyPair(int keysize) {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
            gen.initialize(keysize);
            return gen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("FATAL: DSA not supported", e);
        }
    }

    public static PublicKey decodeDSAPublicKey(byte[] encoded) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encoded);
        try {
            KeyFactory kf = KeyFactory.getInstance("DSA");
            return kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("FATAL: DSA not supported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("FATAL: DSA does not support X509 encoding", e);
        }
    }
}

